/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.SolarPanelContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVEPowerGenerator;
import com.veteam.voluminousenergy.blocks.tiles.VESolarTile;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class SolarPanelTile
extends VESolarTile
implements IVEPowerGenerator {
    private int generation;

    public SolarPanelTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.SOLAR_PANEL_TILE.get(), pos, state);
    }

    @Deprecated
    public SolarPanelTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.SOLAR_PANEL_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        if (this.f_58857_ != null && this.f_58857_.m_6042_().f_223549_() && this.isClear()) {
            this.generation = this.getGeneration();
            this.generateEnergy(this.generation);
            this.m_6596_();
        }
        this.sendOutPower();
    }

    private void generateEnergy(int fe) {
        if (this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) < (Integer)Config.SOLAR_PANEL_MAX_POWER.get()) {
            this.energy.ifPresent(e -> e.addEnergy(fe));
        }
    }

    public static int receiveEnergy(BlockEntity tileEntity, Direction from, int maxReceive) {
        return tileEntity.getCapability(ForgeCapabilities.ENERGY, from).map(handler -> handler.receiveEnergy(maxReceive, false)).orElse(0);
    }

    private void sendOutPower() {
        this.energy.ifPresent(energy -> {
            for (Direction dir : Direction.values()) {
                BlockEntity tileEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                Direction opposite = dir.m_122424_();
                if (tileEntity == null) continue;
                int smallest = Math.min((Integer)Config.SOLAR_PANEL_SEND.get(), energy.getEnergyStored());
                int received = SolarPanelTile.receiveEnergy(tileEntity, opposite, smallest);
                energy.consumeEnergy(received);
                if (energy.getEnergyStored() <= 0) break;
            }
        });
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        CompoundTag energyTag = tag.m_128469_("energy");
        this.energy.ifPresent(h -> h.deserializeNBT(energyTag));
        tag.m_128405_("generation_rate", this.generation);
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        this.energy.ifPresent(h -> h.serializeNBT(tag));
        this.generation = tag.m_128451_("generation_rate");
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
        return new SolarPanelContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nullable
    public ItemStackHandler getInventoryHandler() {
        return null;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return new ArrayList<VESlotManager>();
    }

    public int getGeneration() {
        return (int)((float)((Integer)Config.SOLAR_PANEL_GENERATE.get()).intValue() * this.solarIntensity());
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.SOLAR_PANEL_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return 0;
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.SOLAR_PANEL_SEND.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 0;
    }
}

