/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.SawmillContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.recipe.SawmillingRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SawmillTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager inputSm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_slot");
    public VESlotManager plankSm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "plank_slot");
    public VESlotManager secondOutputSm = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "second_output_slot");
    public VESlotManager bucketTopSm = new VESlotManager(3, Direction.SOUTH, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "bucket_top_slot");
    public VESlotManager bucketBottomSm = new VESlotManager(4, Direction.EAST, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "bucket_bottom_slot");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(SawmillTile.this.inputSm);
            this.add(SawmillTile.this.plankSm);
            this.add(SawmillTile.this.secondOutputSm);
            this.add(SawmillTile.this.bucketTopSm);
            this.add(SawmillTile.this.bucketBottomSm);
        }
    };
    RelationalTank outputTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.OUTPUT, 0, "outputTank:output_tank_gui");
    private final FluidStack configuredFluidForNoRecipe = new FluidStack(Objects.requireNonNull((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation((String)Config.SAWMILL_FLUID_LOCATION.get()))), ((Integer)Config.SAWMILL_FLUID_AMOUNT.get()).intValue());
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(SawmillTile.this.outputTank);
        }
    };
    private final ItemStackHandler inventory = this.createHandler();

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public SawmillTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.SAWMILL_TILE.get(), pos, state);
        this.outputTank.setAllowAny(true);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack logInput = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack topBucketInput = this.inventory.getStackInSlot(3).m_41777_();
        ItemStack bottomBucketOutput = this.inventory.getStackInSlot(4).m_41777_();
        this.outputTank.setInput(topBucketInput.m_41777_());
        this.outputTank.setOutput(bottomBucketOutput.m_41777_());
        if (this.inputFluid(this.outputTank, 3, 4)) {
            return;
        }
        if (this.outputFluid(this.outputTank, 3, 4)) {
            return;
        }
        if (!logInput.m_41619_()) {
            SawmillingRecipe sawmillingRecipe = RecipeUtil.getSawmillingRecipeFromLog(this.f_58857_, logInput.m_41777_());
            if (sawmillingRecipe == null && ((Boolean)Config.SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED.get()).booleanValue() || sawmillingRecipe != null && sawmillingRecipe.isLogRecipe() && ((Boolean)Config.SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED.get()).booleanValue()) {
                ItemStack plankOutputStack = RecipeUtil.getPlankFromLogParallel(this.f_58857_, logInput.m_41777_());
                ItemStack secondOutputStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)Config.SAWMILL_SECOND_OUTPUT_RESOURCE_LOCATION.get())), ((Integer)Config.SAWMILL_SECOND_OUTPUT_COUNT.get()).intValue());
                if (plankOutputStack != null) {
                    if (this.configuredFluidForNoRecipe != null && this.outputTank.getTank().getFluidAmount() + (Integer)Config.SAWMILL_FLUID_AMOUNT.get() <= 4000 && (this.inventory.getStackInSlot(1).m_41619_() || this.inventory.getStackInSlot(1).m_41720_() == plankOutputStack.m_41720_()) && (this.inventory.getStackInSlot(2).m_41619_() || this.inventory.getStackInSlot(2).m_41720_() == secondOutputStack.m_41720_()) && this.inventory.getStackInSlot(1).m_41613_() + (Integer)Config.SAWMILL_PRIMARY_OUTPUT_COUNT.get() <= 64 && this.inventory.getStackInSlot(2).m_41613_() + (Integer)Config.SAWMILL_SECOND_OUTPUT_COUNT.get() <= 64) {
                        if (this.outputTank.getTank().getFluid().isFluidEqual(this.configuredFluidForNoRecipe.copy()) || this.outputTank.getTank().getFluid().isEmpty()) {
                            plankOutputStack.m_41764_(((Integer)Config.SAWMILL_PRIMARY_OUTPUT_COUNT.get()).intValue());
                            this.coreTickProcessing(null, logInput, plankOutputStack.m_41777_(), secondOutputStack.m_41777_(), this.configuredFluidForNoRecipe.copy());
                        } else {
                            this.counter = 0;
                        }
                    } else {
                        this.counter = 0;
                    }
                } else {
                    this.counter = 0;
                }
            } else if (sawmillingRecipe != null && !sawmillingRecipe.isLogRecipe()) {
                ItemStack plankOutputStack = sawmillingRecipe.result.m_41777_();
                ItemStack secondOutputStack = sawmillingRecipe.secondResult.m_41777_();
                FluidStack outputFluid = sawmillingRecipe.getOutputFluid().copy();
                if (this.outputTank.getTank().getFluidAmount() + outputFluid.getAmount() <= 4000 && (this.inventory.getStackInSlot(1).m_41619_() || this.inventory.getStackInSlot(1).m_41720_() == plankOutputStack.m_41720_()) && (this.inventory.getStackInSlot(2).m_41619_() || this.inventory.getStackInSlot(2).m_41720_() == secondOutputStack.m_41720_()) && this.inventory.getStackInSlot(1).m_41613_() + sawmillingRecipe.result.m_41613_() <= 64 && this.inventory.getStackInSlot(2).m_41613_() + sawmillingRecipe.secondResult.m_41613_() <= 64) {
                    if (this.outputTank.getTank().getFluid().isFluidEqual(outputFluid.copy()) || this.outputTank.getTank().getFluid().isEmpty()) {
                        this.coreTickProcessing(sawmillingRecipe, logInput, plankOutputStack, secondOutputStack, outputFluid);
                    } else {
                        this.counter = 0;
                    }
                } else {
                    this.counter = 0;
                }
            }
        } else {
            this.counter = 0;
        }
    }

    private void coreTickProcessing(@Nullable SawmillingRecipe sawmillingRecipe, ItemStack logInput, ItemStack resolvedPlankOutput, ItemStack secondItemOutput, FluidStack fluidOutput) {
        if (this.canConsumeEnergy()) {
            if (this.counter == 1) {
                this.inventory.extractItem(0, sawmillingRecipe != null ? sawmillingRecipe.ingredientCount : (Integer)Config.SAWMILL_LOG_CONSUMPTION_RATE.get(), false);
                ItemStack currentPlankStack = this.inventory.getStackInSlot(1);
                if (currentPlankStack.m_41720_() != resolvedPlankOutput.m_41720_() || currentPlankStack.m_41720_() == Items.f_41852_) {
                    if (currentPlankStack.m_41720_() == Items.f_41852_) {
                        currentPlankStack.m_41764_(1);
                    }
                    this.inventory.insertItem(1, resolvedPlankOutput.m_41777_(), false);
                } else {
                    this.inventory.insertItem(1, resolvedPlankOutput.m_41777_(), false);
                }
                ItemStack currentSecondOutput = this.inventory.getStackInSlot(2);
                if (currentSecondOutput.m_41720_() != secondItemOutput.m_41720_() || currentSecondOutput.m_41720_() == Items.f_41852_) {
                    if (currentSecondOutput.m_41720_() == Items.f_41852_) {
                        currentSecondOutput.m_41764_(1);
                    }
                    this.inventory.insertItem(2, secondItemOutput.m_41777_(), false);
                } else {
                    this.inventory.insertItem(2, secondItemOutput.m_41777_(), false);
                }
                if (this.outputTank.getTank().getFluid().getRawFluid() != fluidOutput.getRawFluid()) {
                    this.outputTank.getTank().setFluid(fluidOutput.copy());
                } else {
                    this.outputTank.getTank().fill(fluidOutput.copy(), IFluidHandler.FluidAction.EXECUTE);
                }
                --this.counter;
                this.consumeEnergy();
                this.m_6596_();
            } else if (this.counter > 0) {
                --this.counter;
                this.consumeEnergy();
                if (++this.sound_tick == 19) {
                    this.sound_tick = 0;
                    if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else {
                this.length = this.counter = sawmillingRecipe != null ? this.calculateCounter(sawmillingRecipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_()) : this.calculateCounter((Integer)Config.SAWMILL_PROCESSING_TIME.get(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
            }
        } else {
            this.decrementSuperCounterOnNoPower();
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                SawmillTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    ItemStack altPlankStack;
                    SawmillingRecipe recipe = RecipeUtil.getSawmillingRecipeFromLog(SawmillTile.this.f_58857_, stack);
                    if (recipe != null) {
                        return true;
                    }
                    return (Boolean)Config.SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED.get() != false && (altPlankStack = RecipeUtil.getPlankFromLogParallel(SawmillTile.this.f_58857_, stack.m_41777_())) != null;
                }
                if (slot == 1) {
                    SawmillingRecipe recipe = RecipeUtil.getSawmillingRecipeFromPlank(SawmillTile.this.f_58857_, stack);
                    if (recipe != null) {
                        return true;
                    }
                    if (((Boolean)Config.SAWMILL_ALLOW_NON_SAWMILL_RECIPE_LOGS_TO_BE_SAWED.get()).booleanValue()) {
                        ArrayList<ItemStack> plankList = RecipeUtil.getLogFromPlankParallel(SawmillTile.this.f_58857_, stack.m_41777_());
                        return plankList != null && !plankList.isEmpty();
                    }
                    return false;
                }
                if (slot == 2) {
                    SawmillingRecipe recipe = RecipeUtil.getSawmillingRecipeFromSecondOutput(SawmillTile.this.f_58857_, stack.m_41777_());
                    return recipe != null;
                }
                if (slot == 3 || slot == 4) {
                    return stack.m_41720_() instanceof BucketItem;
                }
                if (slot == 5) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new SawmillContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.outputTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    public RelationalTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.SAWMILL_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.SAWMILL_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.SAWMILL_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 5;
    }
}

