/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.PumpContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PumpTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity {
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IFluidHandler> fluid = LazyOptional.of(this::createFluid);
    public VESlotManager slotManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "slot_manager");
    private final int tankCapacity = 4000;
    private boolean initDone = false;
    private int lX = 0;
    private int lY = 0;
    private int lZ = 0;
    private final RelationalTank fluidTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.OUTPUT, "tank:tank_gui");
    private Fluid pumpingFluid = Fluids.f_76191_;
    private final ItemStackHandler inventory = this.createHandler();

    public PumpTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.PUMP_TILE.get(), pos, state);
        this.fluidTank.setAllowAny(true);
    }

    @Deprecated
    public PumpTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.PUMP_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        this.handler.ifPresent(h -> {
            ItemStack slotStack = h.getStackInSlot(0).m_41777_();
            if (slotStack.m_41777_() != ItemStack.f_41583_ && slotStack.m_41720_() == Items.f_42446_ && this.fluidTank.getTank().getFluidAmount() >= 1000 && slotStack.m_41613_() == 1) {
                ItemStack bucketStack = new ItemStack((ItemLike)this.fluidTank.getTank().getFluid().getRawFluid().m_6859_(), 1);
                this.fluidTank.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                h.extractItem(0, 1, false);
                h.insertItem(0, bucketStack, false);
            }
            if (this.fluidTank.getTank() != null && this.fluidTank.getTank().getFluidAmount() + 1000 <= 4000 && this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) > 0) {
                for (int i = 0; i < 50 && !this.fluidPumpMethod(); ++i) {
                }
                this.m_6596_();
                if (++this.sound_tick == 19) {
                    this.sound_tick = 0;
                    if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.AIR_COMPRESSOR, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        });
    }

    public void addFluidToTank() {
        if (this.fluidTank.getTank().getFluidAmount() + 1000 <= 4000) {
            this.energy.ifPresent(e -> e.consumeEnergy((Integer)Config.PUMP_POWER_USAGE.get()));
            this.fluidTank.getTank().fill(new FluidStack(this.pumpingFluid, 1000), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pumpingFluid = this.fluidTank.getTank().getFluid().getRawFluid();
        this.lX = tag.m_128451_("lx");
        this.lY = tag.m_128451_("ly");
        this.lZ = tag.m_128451_("lz");
        this.initDone = tag.m_128471_("init_done");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("lx", this.lX);
        tag.m_128405_("ly", this.lY);
        tag.m_128405_("lz", this.lZ);
        tag.m_128379_("init_done", this.initDone);
        super.m_183515_(tag);
    }

    @Nonnull
    private IFluidHandler createFluid() {
        return new IFluidHandler(){

            public int getTanks() {
                return 1;
            }

            @Nonnull
            public FluidStack getFluidInTank(int tank) {
                return PumpTile.this.fluidTank.getTank().getFluid();
            }

            public int getTankCapacity(int tank) {
                return PumpTile.this.fluidTank.getTank() == null ? 0 : PumpTile.this.fluidTank.getTank().getCapacity();
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return PumpTile.this.fluidTank.getTank().isFluidValid(stack);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.isFluidValid(0, resource) && PumpTile.this.fluidTank.getTank().isEmpty() || resource.isFluidEqual(PumpTile.this.fluidTank.getTank().getFluid())) {
                    return PumpTile.this.fluidTank.getTank().fill(resource.copy(), action);
                }
                return 0;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                if (resource.isFluidEqual(PumpTile.this.fluidTank.getTank().getFluid())) {
                    return PumpTile.this.fluidTank.getTank().drain(resource.copy(), action);
                }
                return FluidStack.EMPTY;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                if (PumpTile.this.fluidTank.getTank().getFluidAmount() > 0) {
                    return PumpTile.this.fluidTank.getTank().drain(maxDrain, action);
                }
                return FluidStack.EMPTY;
            }
        };
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                PumpTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluid.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new PumpContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nullable
    public ItemStackHandler getInventoryHandler() {
        return null;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return new ArrayList<VESlotManager>();
    }

    public FluidStack getAirTankFluid() {
        return this.fluidTank.getTank().getFluid();
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return Collections.singletonList(this.fluidTank);
    }

    public boolean fluidPumpMethod() {
        if (!this.initDone) {
            this.lX = -22;
            this.lY = -1;
            this.lZ = -22;
            try {
                this.pumpingFluid = this.f_58857_.m_8055_(this.m_58899_().m_7918_(0, -1, 0)).m_60819_().m_76152_();
                this.initDone = true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.pumpingFluid == Fluids.f_76191_ || this.pumpingFluid.m_6212_(Fluids.f_76191_) || this.pumpingFluid == null) {
            this.initDone = false;
            return false;
        }
        if (this.lX < 22) {
            ++this.lX;
            if (this.pumpingFluid.m_6212_(this.f_58857_.m_8055_(this.m_58899_().m_7918_(this.lX, this.lY, this.lZ)).m_60819_().m_76152_())) {
                this.f_58857_.m_46597_(this.m_58899_().m_7918_(this.lX, this.lY, this.lZ), Blocks.f_50016_.m_49966_());
                this.addFluidToTank();
                return true;
            }
        } else if (this.lZ < 22) {
            ++this.lZ;
            this.lX = -22;
            if (this.pumpingFluid.m_6212_(this.f_58857_.m_8055_(this.m_58899_().m_7918_(this.lX, this.lY, this.lZ)).m_60819_().m_76152_())) {
                this.f_58857_.m_46597_(this.m_58899_().m_7918_(this.lX, this.lY, this.lZ), Blocks.f_50016_.m_49966_());
                this.addFluidToTank();
                return true;
            }
        } else if (this.m_58899_().m_7918_(0, this.lY, 0).m_123342_() > -63) {
            --this.lY;
            this.lX = -22;
            this.lZ = -22;
            if (this.pumpingFluid.m_6212_(this.f_58857_.m_8055_(this.m_58899_().m_7918_(this.lX, this.lY, this.lZ)).m_60819_().m_76152_())) {
                this.f_58857_.m_46597_(this.m_58899_().m_7918_(this.lX, this.lY, this.lZ), Blocks.f_50016_.m_49966_());
                this.addFluidToTank();
                return true;
            }
        }
        return false;
    }

    public RelationalTank getTank() {
        return this.fluidTank;
    }

    @Override
    public void updatePacketFromGui(boolean status, int slotId) {
        if (slotId == this.slotManager.getSlotNum()) {
            this.slotManager.setStatus(status);
        }
    }

    @Override
    public void updatePacketFromGui(int direction, int slotId) {
        if (slotId == this.slotManager.getSlotNum()) {
            this.slotManager.setDirection(direction);
        }
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.PUMP_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.PUMP_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.PUMP_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 0;
    }
}

