/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.PrimitiveBlastFurnaceContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.recipe.PrimitiveBlastFurnaceRecipe;
import com.veteam.voluminousenergy.tools.energy.VEEnergyStorage;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class PrimitiveBlastFurnaceTile
extends VoluminousTileEntity
implements IVECountable {
    public VESlotManager inputSm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_gui");
    public VESlotManager outputSm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_gui");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(PrimitiveBlastFurnaceTile.this.inputSm);
            this.add(PrimitiveBlastFurnaceTile.this.outputSm);
        }
    };
    private final AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    private ItemStackHandler inventory = this.createHandler();

    public PrimitiveBlastFurnaceTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.PRIMITIVE_BLAST_FURNACE_TILE.get(), pos, state);
    }

    @Deprecated
    public PrimitiveBlastFurnaceTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.PRIMITIVE_BLAST_FURNACE_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack input = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack output = this.inventory.getStackInSlot(1).m_41777_();
        PrimitiveBlastFurnaceRecipe recipe = this.f_58857_.m_7465_().m_44015_(PrimitiveBlastFurnaceRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_).orElse(null);
        this.inputItemStack.set(input.m_41777_());
        if (!input.m_41619_()) {
            if (output.m_41613_() + recipe.getOutputAmount() < 64) {
                if (this.counter == 1) {
                    this.inventory.extractItem(0, recipe.ingredientCount, false);
                    ItemStack newOutputStack = recipe.getResult().m_41777_();
                    if (output.m_41720_() != newOutputStack.m_41720_()) {
                        if (output.m_41720_() == Items.f_41852_) {
                            output.m_41764_(1);
                        }
                        newOutputStack.m_41764_(recipe.getOutputAmount());
                        this.inventory.insertItem(1, newOutputStack.m_41777_(), false);
                    } else {
                        output.m_41764_(recipe.getOutputAmount());
                        this.inventory.insertItem(1, output.m_41777_(), false);
                    }
                    --this.counter;
                    this.m_6596_();
                } else if (this.counter > 0) {
                    --this.counter;
                } else if (output.m_41619_() || output.m_41720_() == recipe.getResult().m_41720_()) {
                    this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(2).m_41777_());
                } else {
                    this.counter = 0;
                }
            } else {
                this.counter = 0;
            }
        } else {
            this.counter = 0;
        }
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ItemStack referenceStack = stack.m_41777_();
                referenceStack.m_41764_(64);
                PrimitiveBlastFurnaceRecipe recipeOutput = PrimitiveBlastFurnaceTile.this.f_58857_.m_7465_().m_44015_(PrimitiveBlastFurnaceRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{PrimitiveBlastFurnaceTile.this.inputItemStack.get().m_41777_()}), PrimitiveBlastFurnaceTile.this.f_58857_).orElse(null);
                PrimitiveBlastFurnaceRecipe recipe = PrimitiveBlastFurnaceTile.this.f_58857_.m_7465_().m_44015_(PrimitiveBlastFurnaceRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), PrimitiveBlastFurnaceTile.this.f_58857_).orElse(null);
                if (slot == 0 && recipe != null) {
                    return ((Ingredient)recipe.ingredient.get()).test(stack);
                }
                if (slot == 1 && recipeOutput != null) {
                    return stack.m_41720_() == recipeOutput.result.m_41720_();
                }
                if (slot == 2) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack referenceStack = stack.m_41777_();
                referenceStack.m_41764_(64);
                PrimitiveBlastFurnaceRecipe recipeOut = PrimitiveBlastFurnaceTile.this.f_58857_.m_7465_().m_44015_(PrimitiveBlastFurnaceRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{PrimitiveBlastFurnaceTile.this.inputItemStack.get().m_41777_()}), PrimitiveBlastFurnaceTile.this.f_58857_).orElse(null);
                PrimitiveBlastFurnaceRecipe recipe = PrimitiveBlastFurnaceTile.this.f_58857_.m_7465_().m_44015_(PrimitiveBlastFurnaceRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), PrimitiveBlastFurnaceTile.this.f_58857_).orElse(null);
                if (slot == 0 && recipe != null) {
                    for (ItemStack testStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                        if (stack.m_41720_() != testStack.m_41720_()) continue;
                        return super.insertItem(slot, stack, simulate);
                    }
                } else if (slot == 1 && recipeOut != null ? stack.m_41720_() == recipeOut.result.m_41720_() : slot == 2 && TagUtil.isTaggedMachineUpgradeItem(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new PrimitiveBlastFurnaceContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    @Override
    @Nullable
    public LazyOptional<VEEnergyStorage> getEnergy() {
        return null;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int getCounter() {
        return this.counter;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }
}

