/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.HydroponicIncubatorContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.recipe.HydroponicIncubatorRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class HydroponicIncubatorTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager input0sm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_0_sm");
    public VESlotManager input1sm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "input_1_sm");
    public VESlotManager input2sm = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_2_sm");
    public VESlotManager output0sm = new VESlotManager(3, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_0_sm");
    public VESlotManager output1sm = new VESlotManager(4, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_1_sm");
    public VESlotManager output2sm = new VESlotManager(5, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_2_sm");
    public VESlotManager output3sm = new VESlotManager(6, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_3_sm");
    private final ItemStackHandler inventory = this.createHandler();
    private AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(HydroponicIncubatorTile.this.input0sm);
            this.add(HydroponicIncubatorTile.this.input1sm);
            this.add(HydroponicIncubatorTile.this.input2sm);
            this.add(HydroponicIncubatorTile.this.output0sm);
            this.add(HydroponicIncubatorTile.this.output1sm);
            this.add(HydroponicIncubatorTile.this.output2sm);
            this.add(HydroponicIncubatorTile.this.output3sm);
        }
    };
    RelationalTank inputTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "inputTank:input_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(HydroponicIncubatorTile.this.inputTank);
        }
    };

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public HydroponicIncubatorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.HYDROPONIC_INCUBATOR_TILE.get(), pos, state);
        this.inputTank.setAllowAny(true);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack input = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack input1 = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack inputItem = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack output0 = this.inventory.getStackInSlot(3).m_41777_();
        ItemStack output1 = this.inventory.getStackInSlot(4).m_41777_();
        ItemStack output2 = this.inventory.getStackInSlot(5).m_41777_();
        ItemStack output3 = this.inventory.getStackInSlot(6).m_41777_();
        this.inputTank.setInput(input.m_41777_());
        this.inputTank.setOutput(input1.m_41777_());
        if (this.inputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.inputTank, 0, 1)) {
            return;
        }
        this.inputItemStack.set(inputItem.m_41777_());
        HydroponicIncubatorRecipe recipe = RecipeUtil.getHydroponicIncubatorRecipe(this.f_58857_, this.inputTank.getTank().getFluid(), inputItem.m_41777_());
        if (this.inputTank != null && !this.inputTank.getTank().isEmpty() && recipe != null) {
            if (recipe.getRawFluids().contains(this.inputTank.getTank().getFluid().getRawFluid()) && recipe.getOutputAmount() + output0.m_41613_() <= recipe.getResult().m_41741_() && recipe.getOutputRngAmount0() + output1.m_41613_() <= recipe.getResults().get(1).m_41741_() && recipe.getOutputRngAmount1() + output2.m_41613_() <= recipe.getResults().get(1).m_41741_() && recipe.getOutputRngAmount2() + output3.m_41613_() <= recipe.getResults().get(1).m_41741_()) {
                if (this.inputTank.getTank().getFluidAmount() >= recipe.getInputAmount()) {
                    if (this.canConsumeEnergy()) {
                        if (this.counter == 1) {
                            float random;
                            Random r;
                            ItemStack newRngStack;
                            this.inputTank.getTank().drain(recipe.getInputAmount(), IFluidHandler.FluidAction.EXECUTE);
                            ItemStack newOutputStack = recipe.getResult().m_41777_();
                            if (output0.m_41720_() != newOutputStack.m_41720_() || output0.m_41720_() == Items.f_41852_) {
                                if (output0.m_41720_() == Items.f_41852_) {
                                    output0.m_41764_(1);
                                }
                                newOutputStack.m_41764_(recipe.getOutputAmount());
                                this.inventory.insertItem(3, newOutputStack.m_41777_(), false);
                            } else {
                                output0.m_41764_(recipe.getOutputAmount());
                                this.inventory.insertItem(3, output0.m_41777_(), false);
                            }
                            if (recipe.getChance0() != 0.0f) {
                                newRngStack = recipe.getRngItemSlot0().m_41777_();
                                r = new Random();
                                random = Mth.m_14154_((float)(0.0f + r.nextFloat() * -1.0f));
                                if (random <= recipe.getChance0()) {
                                    if (output1.m_41720_() != recipe.getRngItemSlot0().m_41720_()) {
                                        if (output1.m_41720_() == Items.f_41852_) {
                                            output1.m_41764_(1);
                                        }
                                        newRngStack.m_41764_(recipe.getOutputRngAmount0());
                                        this.inventory.insertItem(4, newRngStack.m_41777_(), false);
                                    } else {
                                        output1.m_41764_(recipe.getOutputRngAmount0());
                                        this.inventory.insertItem(4, output1.m_41777_(), false);
                                    }
                                }
                            }
                            if (recipe.getChance1() != 0.0f) {
                                newRngStack = recipe.getRngItemSlot1().m_41777_();
                                r = new Random();
                                random = Mth.m_14154_((float)(0.0f + r.nextFloat() * -1.0f));
                                if (random <= recipe.getChance1()) {
                                    if (output2.m_41720_() != recipe.getRngItemSlot1().m_41720_()) {
                                        if (output2.m_41720_() == Items.f_41852_) {
                                            output2.m_41764_(1);
                                        }
                                        newRngStack.m_41764_(recipe.getOutputRngAmount1());
                                        this.inventory.insertItem(5, newRngStack.m_41777_(), false);
                                    } else {
                                        output2.m_41764_(recipe.getOutputRngAmount1());
                                        this.inventory.insertItem(5, output2.m_41777_(), false);
                                    }
                                }
                            }
                            if (recipe.getChance2() != 0.0f) {
                                newRngStack = recipe.getRngItemSlot2().m_41777_();
                                r = new Random();
                                random = Mth.m_14154_((float)(0.0f + r.nextFloat() * -1.0f));
                                if (random <= recipe.getChance2()) {
                                    if (output3.m_41720_() != recipe.getRngItemSlot2().m_41720_()) {
                                        if (output3.m_41720_() == Items.f_41852_) {
                                            output3.m_41764_(1);
                                        }
                                        newRngStack.m_41764_(recipe.getOutputRngAmount2());
                                        this.inventory.insertItem(6, newRngStack.m_41777_(), false);
                                    } else {
                                        output3.m_41764_(recipe.getOutputRngAmount2());
                                        this.inventory.insertItem(6, output3.m_41777_(), false);
                                    }
                                }
                            }
                            --this.counter;
                            this.consumeEnergy();
                            this.m_6596_();
                        } else if (this.counter > 0) {
                            --this.counter;
                            this.consumeEnergy();
                            if (++this.sound_tick == 19) {
                                this.sound_tick = 0;
                                if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                    this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                                }
                            }
                        } else {
                            this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                        }
                    } else {
                        this.decrementSuperCounterOnNoPower();
                    }
                } else {
                    this.counter = 0;
                }
            } else {
                this.counter = 0;
            }
        } else {
            this.counter = 0;
        }
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                HydroponicIncubatorTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    return stack.m_41720_() instanceof BucketItem;
                }
                if (slot == 2) {
                    ArrayList<HydroponicIncubatorRecipe> recipes = RecipeUtil.getHydroponicIncubatorRecipesFromItemInput(HydroponicIncubatorTile.this.f_58857_, stack.m_41720_());
                    return !recipes.isEmpty();
                }
                if (slot < 7) {
                    ArrayList<HydroponicIncubatorRecipe> recipes = RecipeUtil.getHydroponicIncubatorRecipesFromAnyItemOutput(HydroponicIncubatorTile.this.f_58857_, stack.m_41720_());
                    return !recipes.isEmpty();
                }
                if (slot == 7) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 2) {
                    if (HydroponicIncubatorTile.this.inventory.getStackInSlot(2).m_41613_() > 0) {
                        return stack;
                    }
                    if (stack.m_41613_() > 1) {
                        ItemStack singleItemStack = stack.m_41777_();
                        singleItemStack.m_41764_(1);
                        stack.m_41764_(stack.m_41613_() - 1);
                        super.insertItem(slot, singleItemStack, false);
                        return stack;
                    }
                } else if (slot > 2 && slot < 7) {
                    ArrayList<HydroponicIncubatorRecipe> recipes = RecipeUtil.getHydroponicIncubatorRecipesFromAnyItemOutput(HydroponicIncubatorTile.this.f_58857_, HydroponicIncubatorTile.this.inputItemStack.get().m_41720_());
                    if (recipes.isEmpty()) {
                        return stack;
                    }
                    if (RecipeUtil.getHydroponicIncubatorRecipesFromAnyItemOutput(HydroponicIncubatorTile.this.f_58857_, stack.m_41720_()).isEmpty()) {
                        return stack;
                    }
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new HydroponicIncubatorContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.inputTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    public RelationalTank getInputTank() {
        return this.inputTank;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.HYDROPONIC_INCUBATOR_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.HYDROPONIC_INCUBATOR_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.HYDROPONIC_INCUBATOR_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 7;
    }
}

