/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.GasFiredFurnaceContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.items.VEItems;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorFuelRecipe;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class GasFiredFurnaceTile
extends VEFluidTileEntity
implements IVECountable {
    public VESlotManager bucketInputSm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "bucket_input_gui");
    public VESlotManager bucketOutputSm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "bucket_output_gui");
    public VESlotManager furnaceInputSm = new VESlotManager(2, Direction.EAST, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "furnace_input_gui");
    public VESlotManager furnaceOutputSm = new VESlotManager(3, Direction.WEST, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "furnace_output_gui");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(GasFiredFurnaceTile.this.bucketInputSm);
            this.add(GasFiredFurnaceTile.this.bucketOutputSm);
            this.add(GasFiredFurnaceTile.this.furnaceInputSm);
            this.add(GasFiredFurnaceTile.this.furnaceOutputSm);
        }
    };
    RelationalTank fuelTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "fuel_tank:fuel_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(GasFiredFurnaceTile.this.fuelTank);
        }
    };
    private int fuelCounter;
    private int fuelLength;
    private final AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    private final AtomicReference<ItemStack> referenceStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    public ItemStackHandler inventory = this.createHandler();

    public GasFiredFurnaceTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.GAS_FIRED_FURNACE_TILE.get(), pos, state);
        this.fuelTank.setValidFluids(RecipeUtil.getCombustibleFuelsWithoutLevel());
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack bucketInput = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack bucketOutput = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack furnaceInput = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack furnaceOutput = this.inventory.getStackInSlot(3).m_41777_();
        this.fuelTank.setInput(bucketInput.m_41777_());
        this.fuelTank.setOutput(bucketOutput.m_41777_());
        if (this.inputFluid(this.fuelTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.fuelTank, 0, 1)) {
            return;
        }
        this.inputItemStack.set(furnaceInput.m_41777_());
        if (this.fuelTank.getTank() != null && !this.fuelTank.getTank().isEmpty()) {
            SmeltingRecipe furnaceRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{furnaceInput.m_41777_()}), this.f_58857_).orElse(null);
            BlastingRecipe blastingRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{furnaceInput.m_41777_()}), this.f_58857_).orElse(null);
            if ((furnaceRecipe != null || blastingRecipe != null) && this.countChecker(furnaceRecipe, blastingRecipe, furnaceOutput.m_41777_()) && this.itemChecker(furnaceRecipe, blastingRecipe, furnaceOutput.m_41777_())) {
                if (this.counter == 1) {
                    this.inventory.extractItem(2, 1, false);
                    ItemStack newOutputStack = furnaceRecipe != null ? furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_() : blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
                    if (furnaceOutput.m_41720_() != newOutputStack.m_41720_() || furnaceOutput.m_41720_() == Items.f_41852_) {
                        if (furnaceOutput.m_41720_() == Items.f_41852_) {
                            furnaceOutput.m_41764_(1);
                        }
                        if (furnaceRecipe != null) {
                            newOutputStack.m_41764_(furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        } else {
                            newOutputStack.m_41764_(blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        }
                        this.inventory.insertItem(3, newOutputStack.m_41777_(), false);
                    } else {
                        if (furnaceRecipe != null) {
                            furnaceOutput.m_41764_(furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        } else {
                            furnaceOutput.m_41764_(blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        }
                        this.inventory.insertItem(3, furnaceOutput.m_41777_(), false);
                    }
                    --this.counter;
                    this.m_6596_();
                } else if (this.counter > 0) {
                    --this.counter;
                } else {
                    this.length = this.counter = this.calculateCounter(200, this.inventory.getStackInSlot(4));
                    this.referenceStack.set(furnaceInput.m_41777_());
                }
                if (this.fuelCounter == 1) {
                    --this.fuelCounter;
                } else if (this.fuelCounter > 0) {
                    --this.fuelCounter;
                } else {
                    CombustionGeneratorFuelRecipe recipe = RecipeUtil.getFuelCombustionRecipe(this.f_58857_, this.fuelTank.getTank().getFluid().copy());
                    if (recipe != null) {
                        ItemStack upgradeStack;
                        this.fuelTank.getTank().drain(250, IFluidHandler.FluidAction.EXECUTE);
                        this.fuelCounter = ((VEFluidRecipe)recipe).getProcessTime() / 4;
                        if (this.inventory.getStackInSlot(4).m_41613_() > 0 && this.inventory.getStackInSlot(4).m_41720_() == VEItems.QUARTZ_MULTIPLIER.get()) {
                            this.fuelCounter /= this.inventory.getStackInSlot(4).m_41613_() ^ 2;
                        } else if (!this.inventory.getStackInSlot(4).m_41619_() && TagUtil.isTaggedMachineUpgradeItem(this.inventory.getStackInSlot(4)) && (upgradeStack = this.inventory.getStackInSlot(4).m_41777_()).m_41783_() != null && !upgradeStack.m_41783_().m_128456_()) {
                            float multiplier = upgradeStack.m_41783_().m_128457_("multiplier");
                            multiplier = multiplier / 0.5f > 1.0f ? 1.0f : multiplier / 0.5f;
                            this.fuelCounter = (int)((float)this.fuelCounter * multiplier);
                        }
                        this.fuelLength = this.fuelCounter;
                        this.m_6596_();
                    }
                }
            } else {
                this.counter = 0;
            }
        } else {
            this.counter = 0;
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.fuelCounter = tag.m_128451_("fuel_counter");
        this.fuelLength = tag.m_128451_("fuel_length");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("fuel_counter", this.fuelCounter);
        tag.m_128405_("fuel_length", this.fuelLength);
        super.m_183515_(tag);
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        super.onDataPacket(net, pkt);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                GasFiredFurnaceTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    return GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(CombustionGeneratorFuelRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{stack}), GasFiredFurnaceTile.this.f_58857_).orElse(null) != null || stack.m_41720_() == Items.f_42446_;
                }
                if (slot == 2) {
                    return GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), GasFiredFurnaceTile.this.f_58857_).orElse(null) != null || GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{stack}), GasFiredFurnaceTile.this.f_58857_).orElse(null) != null;
                }
                if (slot == 3) {
                    SmeltingRecipe furnaceRecipe = GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{GasFiredFurnaceTile.this.inputItemStack.get()}), GasFiredFurnaceTile.this.f_58857_).orElse(null);
                    BlastingRecipe blastingRecipe = GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{GasFiredFurnaceTile.this.inputItemStack.get()}), GasFiredFurnaceTile.this.f_58857_).orElse(null);
                    if (blastingRecipe == null && furnaceRecipe == null) {
                        return false;
                    }
                    if (furnaceRecipe != null) {
                        return stack.m_41720_() == furnaceRecipe.m_8043_(GasFiredFurnaceTile.this.f_58857_.m_9598_()).m_41720_();
                    }
                    return stack.m_41720_() == blastingRecipe.m_8043_(GasFiredFurnaceTile.this.f_58857_.m_9598_()).m_41720_();
                }
                if (slot == 4) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 0 || slot == 1) {
                    return super.insertItem(slot, stack, simulate);
                }
                if (slot == 2) {
                    ItemStack referenceStack = stack.m_41777_();
                    referenceStack.m_41764_(64);
                    SmeltingRecipe recipe = GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), GasFiredFurnaceTile.this.f_58857_).orElse(null);
                    BlastingRecipe blastingRecipe = GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), GasFiredFurnaceTile.this.f_58857_).orElse(null);
                    if (recipe != null || blastingRecipe != null) {
                        return super.insertItem(slot, stack, simulate);
                    }
                } else {
                    if (slot == 3) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    if (slot == 4 && TagUtil.isTaggedMachineUpgradeItem(stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (GasFiredFurnaceTile.this.f_58857_ != null && !simulate) {
                    SmeltingRecipe furnaceRecipe = GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{GasFiredFurnaceTile.this.referenceStack.get()}), GasFiredFurnaceTile.this.f_58857_).orElse(null);
                    BlastingRecipe blastingRecipe = GasFiredFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{GasFiredFurnaceTile.this.referenceStack.get()}), GasFiredFurnaceTile.this.f_58857_).orElse(null);
                    if (blastingRecipe != null) {
                        if (GasFiredFurnaceTile.this.inventory.getStackInSlot(slot).m_41720_() == blastingRecipe.m_8043_(GasFiredFurnaceTile.this.f_58857_.m_9598_()).m_41720_() && blastingRecipe.m_43750_() > 0.0f) {
                            GasFiredFurnaceTile.this.generateXP(amount, blastingRecipe.m_43750_());
                        }
                    } else if (furnaceRecipe != null && GasFiredFurnaceTile.this.inventory.getStackInSlot(slot).m_41720_() == furnaceRecipe.m_8043_(GasFiredFurnaceTile.this.f_58857_.m_9598_()).m_41720_() && furnaceRecipe.m_43750_() > 0.0f) {
                        GasFiredFurnaceTile.this.generateXP(amount, furnaceRecipe.m_43750_());
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    private void generateXP(int craftedAmount, float experience) {
        if (this.f_58857_ == null) {
            return;
        }
        int i = Mth.m_14143_((float)((float)craftedAmount * experience));
        float f = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), j));
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new GasFiredFurnaceContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressFuelCounterPX(int px) {
        if (this.fuelCounter == 0) {
            return 0;
        }
        return px * (this.fuelCounter * 100 / this.fuelLength) / 100;
    }

    @Deprecated
    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.fuelTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    public FluidStack getFluidFromTank() {
        return this.fuelTank.getTank().getFluid();
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    public int getFuelCounter() {
        return this.fuelCounter;
    }

    public int getCounter() {
        return this.counter;
    }

    public int progressFuelCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.fuelCounter / (float)this.fuelLength * 100.0f);
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public boolean countChecker(SmeltingRecipe furnaceRecipe, BlastingRecipe blastingRecipe, ItemStack itemStack) {
        if (furnaceRecipe != null) {
            return itemStack.m_41613_() + furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_() <= 64;
        }
        if (blastingRecipe != null) {
            return itemStack.m_41613_() + blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_() <= 64;
        }
        return false;
    }

    public boolean itemChecker(SmeltingRecipe furnaceRecipe, BlastingRecipe blastingRecipe, ItemStack itemStack) {
        if (furnaceRecipe != null) {
            if (itemStack.m_41720_() == Items.f_41852_ || itemStack.m_41619_()) {
                return true;
            }
            return furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41720_() == itemStack.m_41720_();
        }
        if (blastingRecipe != null) {
            if (itemStack.m_41720_() == Items.f_41852_ || itemStack.m_41619_()) {
                return true;
            }
            return blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41720_() == itemStack.m_41720_();
        }
        return false;
    }

    public RelationalTank getFuelTank() {
        return this.fuelTank;
    }
}

