/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.FluidMixerContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.recipe.FluidMixerRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FluidMixerTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager input0sm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_0_sm");
    public VESlotManager input1sm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "input_1_sm");
    public VESlotManager input2sm = new VESlotManager(2, Direction.EAST, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_2_sm");
    public VESlotManager input3sm = new VESlotManager(3, Direction.WEST, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "input_3_sm");
    public VESlotManager output0sm = new VESlotManager(4, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_0_sm");
    public VESlotManager output1sm = new VESlotManager(5, Direction.SOUTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_1_sm");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(FluidMixerTile.this.input0sm);
            this.add(FluidMixerTile.this.input1sm);
            this.add(FluidMixerTile.this.input2sm);
            this.add(FluidMixerTile.this.input3sm);
            this.add(FluidMixerTile.this.output0sm);
            this.add(FluidMixerTile.this.output1sm);
        }
    };
    RelationalTank inputTank0 = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "inputTank0:input_tank_0_gui");
    RelationalTank inputTank1 = new RelationalTank(new FluidTank(4000), 1, null, null, TankType.INPUT, "inputTank1:input_tank_1_gui");
    RelationalTank outputTank0 = new RelationalTank(new FluidTank(4000), 2, null, null, TankType.OUTPUT, 1, "outputTank0:output_tank_0_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(FluidMixerTile.this.inputTank0);
            this.add(FluidMixerTile.this.inputTank1);
            this.add(FluidMixerTile.this.outputTank0);
        }
    };
    public ItemStackHandler inventory = this.createHandler(7);

    public FluidMixerTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.FLUID_MIXER_TILE.get(), pos, state);
        this.inputTank0.setAllowAny(true);
        this.inputTank1.setAllowAny(true);
        this.outputTank0.setAllowAny(true);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    public void tick() {
        FluidMixerRecipe recipe;
        this.updateClients();
        ItemStack input0 = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack output0 = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack input1 = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack output1 = this.inventory.getStackInSlot(3).m_41777_();
        ItemStack input2 = this.inventory.getStackInSlot(4).m_41777_();
        ItemStack output2 = this.inventory.getStackInSlot(5).m_41777_();
        this.inputTank0.setInput(input0.m_41777_());
        this.inputTank0.setOutput(output0.m_41777_());
        this.inputTank1.setInput(input1.m_41777_());
        this.inputTank1.setOutput(output1.m_41777_());
        this.outputTank0.setInput(input2.m_41777_());
        this.outputTank0.setOutput(output2.m_41777_());
        if (this.inputFluid(this.inputTank0, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.inputTank0, 0, 1)) {
            return;
        }
        if (this.inputFluid(this.inputTank1, 2, 3)) {
            return;
        }
        if (this.outputFluid(this.inputTank1, 2, 3)) {
            return;
        }
        if (this.inputFluid(this.outputTank0, 4, 5)) {
            return;
        }
        if (this.outputFluid(this.outputTank0, 4, 5)) {
            return;
        }
        if (this.inputTank0 != null && (recipe = RecipeUtil.getFluidMixerRecipe(this.f_58857_, this.inputTank0.getTank().getFluid().copy(), this.inputTank1.getTank().getFluid().copy())) != null && this.inputTank1 != null && this.outputTank0 != null) {
            if (this.inputTank0.getTank().getFluidAmount() >= recipe.getInputAmount() && this.inputTank1.getTank().getFluidAmount() >= recipe.getSecondInputAmount() && this.outputTank0.getTank().getFluidAmount() + recipe.getOutputAmount() <= 4000) {
                if (this.canConsumeEnergy()) {
                    if (this.counter == 1) {
                        this.inputTank0.getTank().drain(recipe.getInputAmount(), IFluidHandler.FluidAction.EXECUTE);
                        this.inputTank1.getTank().drain(recipe.getSecondInputAmount(), IFluidHandler.FluidAction.EXECUTE);
                        if (this.outputTank0.getTank().getFluid().getRawFluid() != recipe.getOutputFluid().getRawFluid()) {
                            this.outputTank0.getTank().setFluid(recipe.getOutputFluid().copy());
                        } else {
                            this.outputTank0.getTank().fill(recipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        --this.counter;
                        this.consumeEnergy();
                        this.m_6596_();
                    } else if (this.counter > 0) {
                        --this.counter;
                        this.consumeEnergy();
                        if (++this.sound_tick == 19) {
                            this.sound_tick = 0;
                            if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    } else {
                        this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()));
                    }
                } else {
                    this.decrementSuperCounterOnNoPower();
                }
            } else {
                this.counter = 0;
            }
        }
    }

    @Override
    public int getUpgradeSlotId() {
        return 6;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new FluidMixerContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.inputTank0.getTank().getFluid();
        }
        if (num == 1) {
            return this.inputTank1.getTank().getFluid();
        }
        if (num == 2) {
            return this.outputTank0.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    public RelationalTank getInputTank0() {
        return this.inputTank0;
    }

    public RelationalTank getInputTank1() {
        return this.inputTank1;
    }

    public RelationalTank getOutputTank0() {
        return this.outputTank0;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.FLUID_MIXER_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.FLUID_MIXER_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.FLUID_MIXER_TRANSFER.get();
    }
}

