/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.ElectrolyzerContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.recipe.ElectrolyzerRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ElectrolyzerTile
extends VoluminousTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> this.inventory);
    public VESlotManager inputSm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_manager");
    public VESlotManager bucketSm = new VESlotManager(1, Direction.WEST, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "bucket_manager");
    public VESlotManager outputSm = new VESlotManager(2, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_manager");
    public VESlotManager rngOneSm = new VESlotManager(3, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "rng_one_manager");
    public VESlotManager rngTwoSm = new VESlotManager(4, Direction.SOUTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "rng_two_manager");
    public VESlotManager rngThreeSm = new VESlotManager(5, Direction.EAST, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "rng_three_manager");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(ElectrolyzerTile.this.inputSm);
            this.add(ElectrolyzerTile.this.bucketSm);
            this.add(ElectrolyzerTile.this.outputSm);
            this.add(ElectrolyzerTile.this.rngOneSm);
            this.add(ElectrolyzerTile.this.rngTwoSm);
            this.add(ElectrolyzerTile.this.rngThreeSm);
        }
    };
    private AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    public ItemStackHandler inventory = new ItemStackHandler(7){

        protected void onContentsChanged(int slot) {
            ElectrolyzerTile.this.m_6596_();
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            ItemStack referenceStack = stack.m_41777_();
            referenceStack.m_41764_(64);
            ElectrolyzerRecipe recipe = ElectrolyzerTile.this.f_58857_.m_7465_().m_44015_(ElectrolyzerRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), ElectrolyzerTile.this.f_58857_).orElse(null);
            ElectrolyzerRecipe recipe1 = ElectrolyzerTile.this.f_58857_.m_7465_().m_44015_(ElectrolyzerRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{ElectrolyzerTile.this.inputItemStack.get().m_41777_()}), ElectrolyzerTile.this.f_58857_).orElse(null);
            if (slot == 0 && recipe != null) {
                for (ItemStack testStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                    if (stack.m_41720_() != testStack.m_41720_()) continue;
                    return true;
                }
            } else {
                if (slot == 1 && stack.m_41720_() == Items.f_42446_) {
                    return true;
                }
                if (slot == 2 && recipe1 != null) {
                    return stack.m_41720_() == recipe1.result.m_41720_();
                }
                if (slot == 3 && recipe1 != null) {
                    return stack.m_41720_() == recipe1.getRngItemSlot0().m_41720_();
                }
                if (slot == 4 && recipe1 != null) {
                    return stack.m_41720_() == recipe1.getRngItemSlot1().m_41720_();
                }
                if (slot == 5 && recipe1 != null) {
                    return stack.m_41720_() == recipe1.getRngItemSlot2().m_41720_();
                }
                if (slot == 6) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack referenceStack = stack.m_41777_();
            referenceStack.m_41764_(64);
            ElectrolyzerRecipe recipe = ElectrolyzerTile.this.f_58857_.m_7465_().m_44015_(ElectrolyzerRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack.m_41777_()}), ElectrolyzerTile.this.f_58857_).orElse(null);
            ElectrolyzerRecipe recipe1 = ElectrolyzerTile.this.f_58857_.m_7465_().m_44015_(ElectrolyzerRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{ElectrolyzerTile.this.inputItemStack.get().m_41777_()}), ElectrolyzerTile.this.f_58857_).orElse(null);
            if (slot == 0 && recipe != null) {
                for (ItemStack testStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                    if (stack.m_41720_() != testStack.m_41720_()) continue;
                    return super.insertItem(slot, stack, simulate);
                }
            } else {
                if (slot == 1 && stack.m_41720_() == Items.f_42446_) {
                    return super.insertItem(slot, stack, simulate);
                }
                if (slot == 2 && recipe1 != null ? stack.m_41720_() == recipe1.result.m_41720_() : (slot == 3 && recipe1 != null ? stack.m_41720_() == recipe1.getRngItemSlot0().m_41720_() : (slot == 4 && recipe1 != null ? stack.m_41720_() == recipe1.getRngItemSlot1().m_41720_() : (slot == 5 && recipe1 != null ? stack.m_41720_() == recipe1.getRngItemSlot2().m_41720_() : slot == 6 && TagUtil.isTaggedMachineUpgradeItem(stack))))) {
                    return super.insertItem(slot, stack, simulate);
                }
            }
            return stack;
        }
    };

    public ElectrolyzerTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.ELECTROLYZER_TILE.get(), pos, state);
    }

    @Deprecated
    public ElectrolyzerTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.ELECTROLYZER_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        this.handler.ifPresent(h -> {
            ItemStack input = h.getStackInSlot(0).m_41777_();
            ItemStack bucket = h.getStackInSlot(1).m_41777_();
            ItemStack output = h.getStackInSlot(2).m_41777_();
            ItemStack rngOne = h.getStackInSlot(3).m_41777_();
            ItemStack rngTwo = h.getStackInSlot(4).m_41777_();
            ItemStack rngThree = h.getStackInSlot(5).m_41777_();
            ElectrolyzerRecipe recipe = this.f_58857_.m_7465_().m_44015_(ElectrolyzerRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_).orElse(null);
            this.inputItemStack.set(input.m_41777_());
            if (this.usesBucket(recipe, bucket.m_41777_())) {
                if (!this.areSlotsFull(recipe, output.m_41777_(), rngOne.m_41777_(), rngTwo.m_41777_(), rngThree.m_41777_()) && this.canConsumeEnergy()) {
                    if (this.counter == 1) {
                        float random;
                        Random r;
                        ItemStack newRngStack;
                        h.extractItem(0, recipe.ingredientCount, false);
                        if (recipe.needsBuckets() > 0) {
                            h.extractItem(1, recipe.needsBuckets(), false);
                        }
                        ItemStack newOutputStack = recipe.getResult().m_41777_();
                        if (output.m_41720_() != newOutputStack.m_41720_() || output.m_41720_() == Items.f_41852_) {
                            if (output.m_41720_() == Items.f_41852_) {
                                output.m_41764_(1);
                            }
                            newOutputStack.m_41764_(recipe.getOutputAmount());
                            h.insertItem(2, newOutputStack.m_41777_(), false);
                        } else {
                            output.m_41764_(recipe.getOutputAmount());
                            h.insertItem(2, output.m_41777_(), false);
                        }
                        if (recipe.getChance0() != 0.0f) {
                            newRngStack = recipe.getRngItemSlot0().m_41777_();
                            r = new Random();
                            random = Mth.m_14154_((float)(0.0f + r.nextFloat() * -1.0f));
                            if (random <= recipe.getChance0()) {
                                if (rngOne.m_41720_() != recipe.getRngItemSlot0().m_41720_()) {
                                    if (rngOne.m_41720_() == Items.f_41852_) {
                                        rngOne.m_41764_(1);
                                    }
                                    newRngStack.m_41764_(recipe.getOutputRngAmount0());
                                    h.insertItem(3, newRngStack.m_41777_(), false);
                                } else {
                                    rngOne.m_41764_(recipe.getOutputRngAmount0());
                                    h.insertItem(3, rngOne.m_41777_(), false);
                                }
                            }
                        }
                        if (recipe.getChance1() != 0.0f) {
                            newRngStack = recipe.getRngItemSlot1().m_41777_();
                            r = new Random();
                            random = Mth.m_14154_((float)(0.0f + r.nextFloat() * -1.0f));
                            if (random <= recipe.getChance1()) {
                                if (rngTwo.m_41720_() != recipe.getRngItemSlot1().m_41720_()) {
                                    if (rngTwo.m_41720_() == Items.f_41852_) {
                                        rngTwo.m_41764_(1);
                                    }
                                    newRngStack.m_41764_(recipe.getOutputRngAmount1());
                                    h.insertItem(4, newRngStack.m_41777_(), false);
                                } else {
                                    rngTwo.m_41764_(recipe.getOutputRngAmount1());
                                    h.insertItem(4, rngTwo.m_41777_(), false);
                                }
                            }
                        }
                        if (recipe.getChance1() != 0.0f) {
                            newRngStack = recipe.getRngItemSlot2().m_41777_();
                            r = new Random();
                            random = Mth.m_14154_((float)(0.0f + r.nextFloat() * -1.0f));
                            if (random <= recipe.getChance2()) {
                                if (rngThree.m_41720_() != recipe.getRngItemSlot2().m_41720_()) {
                                    if (rngThree.m_41720_() == Items.f_41852_) {
                                        rngThree.m_41764_(1);
                                    }
                                    newRngStack.m_41764_(recipe.getOutputRngAmount2());
                                    h.insertItem(5, newRngStack.m_41777_(), false);
                                } else {
                                    rngThree.m_41764_(recipe.getOutputRngAmount2());
                                    h.insertItem(5, rngThree.m_41777_(), false);
                                }
                            }
                        }
                        --this.counter;
                        this.consumeEnergy();
                        this.m_6596_();
                    } else if (this.counter > 0) {
                        --this.counter;
                        this.consumeEnergy();
                        if (++this.sound_tick == 19) {
                            this.sound_tick = 0;
                            if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    } else if (this.areSlotsEmptyOrHaveCurrentItems(recipe, output, rngOne, rngTwo, rngThree)) {
                        this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                    } else {
                        this.counter = 0;
                    }
                } else if (!this.canConsumeEnergy()) {
                    this.decrementSuperCounterOnNoPower();
                } else {
                    this.counter = 0;
                }
            } else {
                this.counter = 0;
            }
        });
    }

    private boolean areSlotsFull(ElectrolyzerRecipe recipe, ItemStack one, ItemStack two, ItemStack three, ItemStack four) {
        if (one.m_41613_() + recipe.getOutputAmount() > one.m_41720_().getMaxStackSize(one.m_41777_())) {
            return true;
        }
        if (two.m_41613_() + recipe.getOutputRngAmount0() > two.m_41720_().getMaxStackSize(two.m_41777_())) {
            return true;
        }
        if (three.m_41613_() + recipe.getOutputRngAmount1() > three.m_41720_().getMaxStackSize(three.m_41777_())) {
            return true;
        }
        return four.m_41613_() + recipe.getOutputRngAmount2() > four.m_41720_().getMaxStackSize(four.m_41777_());
    }

    private boolean usesBucket(ElectrolyzerRecipe recipe, ItemStack bucket) {
        if (recipe != null) {
            if (recipe.needsBuckets() > 0) {
                if (!bucket.m_41619_() && bucket.m_41720_() == Items.f_42446_) {
                    return bucket.m_41613_() >= recipe.needsBuckets();
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean areSlotsEmptyOrHaveCurrentItems(ElectrolyzerRecipe recipe, ItemStack one, ItemStack two, ItemStack three, ItemStack four) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        outputList.add(one.m_41777_());
        outputList.add(two.m_41777_());
        outputList.add(three.m_41777_());
        outputList.add(four.m_41777_());
        boolean isEmpty = true;
        boolean matchesRecipe = true;
        for (ItemStack x : outputList) {
            if (x.m_41619_()) continue;
            isEmpty = false;
            if (one.m_41720_() != recipe.getResult().m_41720_() && one.m_41720_() != Items.f_41852_) {
                return false;
            }
            if (two.m_41720_() != recipe.getRngItemSlot0().m_41720_() && two.m_41720_() != Items.f_41852_) {
                return false;
            }
            if (three.m_41720_() != recipe.getRngItemSlot1().m_41720_() && three.m_41720_() != Items.f_41852_) {
                return false;
            }
            return four.m_41720_() == recipe.getRngItemSlot2().m_41720_() || four.m_41720_() == Items.f_41852_;
        }
        return isEmpty;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new ElectrolyzerContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.ELECTROLYZER_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.ELECTROLYZER_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.ELECTROLYZER_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 6;
    }
}

