/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.ElectricFurnaceContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class ElectricFurnaceTile
extends VoluminousTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager inputSlotManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_slot_manager");
    public VESlotManager outputSlotManager = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_slot_manager");
    public List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(ElectricFurnaceTile.this.inputSlotManager);
            this.add(ElectricFurnaceTile.this.outputSlotManager);
        }
    };
    private final AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    private final AtomicReference<ItemStack> referenceStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    public ItemStackHandler inventory = this.createHandler();

    public ElectricFurnaceTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.ELECTRIC_FURNACE_TILE.get(), pos, state);
    }

    @Deprecated
    public ElectricFurnaceTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.ELECTRIC_FURNACE_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack furnaceInput = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack furnaceOutput = this.inventory.getStackInSlot(1).m_41777_();
        this.inputItemStack.set(furnaceInput.m_41777_());
        if (this.canConsumeEnergy()) {
            SmeltingRecipe furnaceRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{furnaceInput.m_41777_()}), this.f_58857_).orElse(null);
            BlastingRecipe blastingRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{furnaceInput.m_41777_()}), this.f_58857_).orElse(null);
            if ((furnaceRecipe != null || blastingRecipe != null) && this.countChecker(furnaceRecipe, blastingRecipe, furnaceOutput.m_41777_()) && this.itemChecker(furnaceRecipe, blastingRecipe, furnaceOutput.m_41777_())) {
                if (this.counter == 1) {
                    this.inventory.extractItem(0, 1, false);
                    ItemStack newOutputStack = furnaceRecipe != null ? furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_() : blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
                    if (furnaceOutput.m_41720_() != newOutputStack.m_41720_() || furnaceOutput.m_41720_() == Items.f_41852_) {
                        if (furnaceOutput.m_41720_() == Items.f_41852_) {
                            furnaceOutput.m_41764_(1);
                        }
                        if (furnaceRecipe != null) {
                            newOutputStack.m_41764_(furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        } else {
                            newOutputStack.m_41764_(blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        }
                        this.inventory.insertItem(1, newOutputStack.m_41777_(), false);
                    } else {
                        if (furnaceRecipe != null) {
                            furnaceOutput.m_41764_(furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        } else {
                            furnaceOutput.m_41764_(blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_());
                        }
                        this.inventory.insertItem(1, furnaceOutput.m_41777_(), false);
                    }
                    this.consumeEnergy();
                    --this.counter;
                    this.m_6596_();
                } else if (this.counter > 0) {
                    this.consumeEnergy();
                    --this.counter;
                    if (++this.sound_tick == 19) {
                        this.sound_tick = 0;
                        if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                            this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                } else {
                    this.length = this.counter = this.calculateCounter(200, this.inventory.getStackInSlot(this.getUpgradeSlotId()));
                    this.referenceStack.set(furnaceInput.m_41777_());
                }
            } else {
                this.counter = 0;
            }
        } else {
            this.decrementSuperCounterOnNoPower();
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                ElectricFurnaceTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), ElectricFurnaceTile.this.f_58857_).orElse(null) != null || ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{stack}), ElectricFurnaceTile.this.f_58857_).orElse(null) != null;
                }
                if (slot == 1) {
                    SmeltingRecipe furnaceRecipe = ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{ElectricFurnaceTile.this.inputItemStack.get()}), ElectricFurnaceTile.this.f_58857_).orElse(null);
                    BlastingRecipe blastingRecipe = ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{ElectricFurnaceTile.this.inputItemStack.get()}), ElectricFurnaceTile.this.f_58857_).orElse(null);
                    if (blastingRecipe == null && furnaceRecipe == null) {
                        return false;
                    }
                    if (furnaceRecipe != null) {
                        return stack.m_41720_() == furnaceRecipe.m_8043_(ElectricFurnaceTile.this.f_58857_.m_9598_()).m_41720_();
                    }
                    return stack.m_41720_() == blastingRecipe.m_8043_(ElectricFurnaceTile.this.f_58857_.m_9598_()).m_41720_();
                }
                if (slot == 2) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    ItemStack referenceStack = stack.m_41777_();
                    referenceStack.m_41764_(64);
                    SmeltingRecipe recipe = ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), ElectricFurnaceTile.this.f_58857_).orElse(null);
                    BlastingRecipe blastingRecipe = ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), ElectricFurnaceTile.this.f_58857_).orElse(null);
                    if (recipe != null || blastingRecipe != null) {
                        return super.insertItem(slot, stack, simulate);
                    }
                } else {
                    if (slot == 1) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    if (slot == 2 && TagUtil.isTaggedMachineUpgradeItem(stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (ElectricFurnaceTile.this.f_58857_ != null && !simulate) {
                    SmeltingRecipe furnaceRecipe = ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{ElectricFurnaceTile.this.referenceStack.get()}), ElectricFurnaceTile.this.f_58857_).orElse(null);
                    BlastingRecipe blastingRecipe = ElectricFurnaceTile.this.f_58857_.m_7465_().m_44015_(RecipeType.f_44109_, (Container)new SimpleContainer(new ItemStack[]{ElectricFurnaceTile.this.referenceStack.get()}), ElectricFurnaceTile.this.f_58857_).orElse(null);
                    if (blastingRecipe != null) {
                        if (ElectricFurnaceTile.this.inventory.getStackInSlot(slot).m_41720_() == blastingRecipe.m_8043_(ElectricFurnaceTile.this.f_58857_.m_9598_()).m_41720_() && blastingRecipe.m_43750_() > 0.0f) {
                            ElectricFurnaceTile.this.generateXP(amount, blastingRecipe.m_43750_());
                        }
                    } else if (furnaceRecipe != null && ElectricFurnaceTile.this.inventory.getStackInSlot(slot).m_41720_() == furnaceRecipe.m_8043_(ElectricFurnaceTile.this.f_58857_.m_9598_()).m_41720_() && furnaceRecipe.m_43750_() > 0.0f) {
                        ElectricFurnaceTile.this.generateXP(amount, furnaceRecipe.m_43750_());
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    private void generateXP(int craftedAmount, float experience) {
        if (this.f_58857_ == null) {
            return;
        }
        int i = Mth.m_14143_((float)((float)craftedAmount * experience));
        float f = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), j));
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new ElectricFurnaceContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public boolean countChecker(SmeltingRecipe furnaceRecipe, BlastingRecipe blastingRecipe, ItemStack itemStack) {
        if (furnaceRecipe != null) {
            return itemStack.m_41613_() + furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_() <= 64;
        }
        if (blastingRecipe != null) {
            return itemStack.m_41613_() + blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_() <= 64;
        }
        return false;
    }

    public boolean itemChecker(SmeltingRecipe furnaceRecipe, BlastingRecipe blastingRecipe, ItemStack itemStack) {
        if (furnaceRecipe != null) {
            if (itemStack.m_41720_() == Items.f_41852_ || itemStack.m_41619_()) {
                return true;
            }
            return furnaceRecipe.m_8043_(this.f_58857_.m_9598_()).m_41720_() == itemStack.m_41720_();
        }
        if (blastingRecipe != null) {
            if (itemStack.m_41720_() == Items.f_41852_ || itemStack.m_41619_()) {
                return true;
            }
            return blastingRecipe.m_8043_(this.f_58857_.m_9598_()).m_41720_() == itemStack.m_41720_();
        }
        return false;
    }

    public int getCounter() {
        return this.counter;
    }

    @Override
    public void updatePacketFromGui(boolean status, int slotId) {
        if (slotId == this.inputSlotManager.getSlotNum()) {
            this.inputSlotManager.setStatus(status);
        } else if (slotId == this.outputSlotManager.getSlotNum()) {
            this.outputSlotManager.setStatus(status);
        }
    }

    @Override
    public void updatePacketFromGui(int direction, int slotId) {
        if (slotId == this.inputSlotManager.getSlotNum()) {
            this.inputSlotManager.setDirection(direction);
        } else if (slotId == this.outputSlotManager.getSlotNum()) {
            this.outputSlotManager.setDirection(direction);
        }
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.ELECTRIC_FURNACE_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.ELECTRIC_FURNACE_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.ELECTRIC_FURNACE_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 2;
    }
}

