/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.DistillationUnitContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEMultiBlockTileEntity;
import com.veteam.voluminousenergy.recipe.DistillationRecipe;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class DistillationUnitTile
extends VEMultiBlockTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager iTopManager = new VESlotManager(0, Direction.UP, false, "slot.voluminousenergy.input_slot", SlotType.INPUT, "i_top_manager");
    public VESlotManager iBottomManager = new VESlotManager(1, Direction.DOWN, false, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "i_bottom_manager");
    public VESlotManager o0TopManager = new VESlotManager(2, Direction.UP, false, "slot.voluminousenergy.input_slot", SlotType.INPUT, "o_0_top_manager");
    public VESlotManager o0BottomManager = new VESlotManager(3, Direction.DOWN, false, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "o_0_top_manager");
    public VESlotManager o1TopManager = new VESlotManager(4, Direction.UP, false, "slot.voluminousenergy.input_slot", SlotType.INPUT, "0_1_top_manager");
    public VESlotManager o1BottomManager = new VESlotManager(5, Direction.DOWN, false, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "o_1_bottom_manager");
    public VESlotManager o2Manager = new VESlotManager(6, Direction.DOWN, false, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "o_2_manager");
    public List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(DistillationUnitTile.this.iTopManager);
            this.add(DistillationUnitTile.this.iBottomManager);
            this.add(DistillationUnitTile.this.o0TopManager);
            this.add(DistillationUnitTile.this.o0BottomManager);
            this.add(DistillationUnitTile.this.o1TopManager);
            this.add(DistillationUnitTile.this.o1BottomManager);
            this.add(DistillationUnitTile.this.o2Manager);
        }
    };
    private final int tankCapacity = 4000;
    RelationalTank inputTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "inputTank:input_tank_gui");
    RelationalTank outputTank0 = new RelationalTank(new FluidTank(4000), 1, null, null, TankType.OUTPUT, 0, "outputTank0:output_tank_0_gui");
    RelationalTank outputTank1 = new RelationalTank(new FluidTank(4000), 2, null, null, TankType.OUTPUT, 1, "outputTank1:output_tank_1_gui");
    public List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(DistillationUnitTile.this.inputTank);
            this.add(DistillationUnitTile.this.outputTank0);
            this.add(DistillationUnitTile.this.outputTank1);
        }
    };
    private byte tick = (byte)19;
    public ItemStackHandler inventory = this.createHandler();

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    public DistillationUnitTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.DISTILLATION_UNIT_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        DistillationRecipe recipe;
        if (!this.inputTank.isValidFluidsSet()) {
            this.inputTank.setValidFluids(RecipeUtil.getDistillationInputFluids(this.f_58857_));
        }
        if (!this.outputTank0.isValidFluidsSet()) {
            this.outputTank0.setAllowAny(true);
        }
        if (!this.outputTank1.isValidFluidsSet()) {
            this.outputTank1.setAllowAny(true);
        }
        this.updateClients();
        this.tick = (byte)(this.tick + 1);
        if (this.tick == 20) {
            this.tick = 0;
            this.validity = this.isMultiBlockValid((Block)VEBlocks.ALUMINUM_MACHINE_CASING_BLOCK.get());
        }
        if (!this.validity) {
            return;
        }
        ItemStack inputTop = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack inputBottom = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack firstOutputTop = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack firstOutputBottom = this.inventory.getStackInSlot(3).m_41777_();
        ItemStack secondOutputTop = this.inventory.getStackInSlot(4).m_41777_();
        ItemStack secondOutputBottom = this.inventory.getStackInSlot(5).m_41777_();
        ItemStack thirdOutput = this.inventory.getStackInSlot(6).m_41777_();
        this.inputTank.setIOItemstack(inputTop.m_41777_(), inputBottom.m_41777_());
        this.outputTank0.setIOItemstack(firstOutputTop.m_41777_(), firstOutputBottom.m_41777_());
        this.outputTank1.setIOItemstack(secondOutputTop.m_41777_(), secondOutputBottom.m_41777_());
        if (this.inputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.inputFluid(this.outputTank0, 2, 3)) {
            return;
        }
        if (this.outputFluid(this.outputTank0, 2, 3)) {
            return;
        }
        if (this.inputFluid(this.outputTank1, 4, 5)) {
            return;
        }
        if (this.outputFluid(this.outputTank1, 4, 5)) {
            return;
        }
        if (!(this.inputTank == null && this.inputTank.getTank().isEmpty() || (recipe = RecipeUtil.getDistillationRecipe(this.f_58857_, this.inputTank.getTank().getFluid())) == null || this.outputTank0 == null || this.outputTank1 == null)) {
            if (thirdOutput.m_41613_() < recipe.getThirdResult().m_41741_() && this.inputTank.getTank().getFluidAmount() >= recipe.getInputAmount() && this.outputTank0.getTank().getFluidAmount() + recipe.getOutputAmount() <= 4000 && this.outputTank1.getTank().getFluidAmount() + recipe.getSecondFluid().getAmount() <= 4000) {
                if (this.canConsumeEnergy()) {
                    if (this.counter == 1) {
                        this.inputTank.getTank().drain(recipe.getInputAmount(), IFluidHandler.FluidAction.EXECUTE);
                        if (this.outputTank0.getTank().getFluid().getRawFluid() != recipe.getOutputFluid().getRawFluid()) {
                            this.outputTank0.getTank().setFluid(recipe.getOutputFluid().copy());
                        } else {
                            this.outputTank0.getTank().fill(recipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        if (this.outputTank1.getTank().getFluid().getRawFluid() != recipe.getSecondResult().getRawFluid()) {
                            this.outputTank1.getTank().setFluid(recipe.getSecondFluid().copy());
                        } else {
                            this.outputTank1.getTank().fill(recipe.getSecondFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        if (Mth.m_14154_((float)(0.0f + this.f_58857_.m_213780_().m_188501_() * -1.0f)) < recipe.getThirdChance()) {
                            if (thirdOutput.m_41720_() != recipe.getThirdResult().m_41720_()) {
                                if (thirdOutput.m_41720_() == Items.f_41852_) {
                                    thirdOutput.m_41764_(1);
                                }
                                this.inventory.insertItem(6, recipe.getThirdResult().m_41777_(), false);
                            } else {
                                this.inventory.insertItem(6, recipe.getThirdResult().m_41777_(), false);
                            }
                        }
                        --this.counter;
                        this.consumeEnergy();
                        this.m_6596_();
                    } else if (this.counter > 0) {
                        --this.counter;
                        this.consumeEnergy();
                        if (++this.sound_tick == 19) {
                            this.sound_tick = 0;
                            if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    } else {
                        this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                    }
                } else {
                    this.decrementSuperCounterOnNoPower();
                }
            } else {
                this.counter = 0;
            }
        }
    }

    private IFluidHandler createInputFluidHandler() {
        return this.createFluidHandler(new DistillationRecipe(), this.inputTank);
    }

    private IFluidHandler createOutput0FluidHandler() {
        return this.createFluidHandler(new DistillationRecipe(), this.outputTank0);
    }

    private IFluidHandler createOutput1FluidHandler() {
        return this.createFluidHandler(new DistillationRecipe(), this.outputTank1);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(8){

            protected void onContentsChanged(int slot) {
                DistillationUnitTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    VEFluidRecipe recipe = DistillationUnitTile.this.f_58857_.m_7465_().m_44015_(DistillationRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{stack}), DistillationUnitTile.this.f_58857_).orElse(null);
                    return recipe != null || stack.m_41720_() == Items.f_42446_;
                }
                if (slot == 2 || slot == 3 && stack.m_41720_() instanceof BucketItem) {
                    if (stack.m_41720_() == Items.f_42446_) {
                        return true;
                    }
                    return RecipeUtil.getDistillationRecipeFromResult(DistillationUnitTile.this.f_58857_, new FluidStack(((BucketItem)stack.m_41720_()).getFluid(), 1000)) != null;
                }
                if (slot == 4 || slot == 5 && stack.m_41720_() instanceof BucketItem) {
                    if (stack.m_41720_() == Items.f_42446_) {
                        return true;
                    }
                    return RecipeUtil.getDistillationRecipeFromSecondResult(DistillationUnitTile.this.f_58857_, new FluidStack(((BucketItem)stack.m_41720_()).getFluid(), 1000)) != null;
                }
                if (slot == 6) {
                    return RecipeUtil.getDistillationRecipeFromThirdResult(DistillationUnitTile.this.f_58857_, stack) != null;
                }
                if (slot == 7) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new DistillationUnitContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.inputTank.getTank().getFluid();
        }
        if (num == 1) {
            return this.outputTank0.getTank().getFluid();
        }
        if (num == 2) {
            return this.outputTank1.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    public boolean getMultiblockValidity() {
        return this.validity;
    }

    public RelationalTank getInputTank() {
        return this.inputTank;
    }

    public RelationalTank getOutputTank0() {
        return this.outputTank0;
    }

    public RelationalTank getOutputTank1() {
        return this.outputTank1;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.DISTILLATION_UNIT_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.DISTILLATION_UNIT_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.DISTILLATION_UNIT_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 7;
    }
}

