/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.achievements.triggers.VECriteriaTriggers;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.DimensionalLaserContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEMultiBlockTileEntity;
import com.veteam.voluminousenergy.items.tools.RFIDChip;
import com.veteam.voluminousenergy.persistence.ChunkFluid;
import com.veteam.voluminousenergy.persistence.SingleChunkFluid;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import com.veteam.voluminousenergy.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionalLaserTile
extends VEMultiBlockTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager bucketTopSm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_0_sm");
    public VESlotManager bucketBottomSm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "input_1_sm");
    public VESlotManager RFIDsm = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_0_sm");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(DimensionalLaserTile.this.bucketTopSm);
            this.add(DimensionalLaserTile.this.bucketBottomSm);
            this.add(DimensionalLaserTile.this.RFIDsm);
        }
    };
    RelationalTank outputTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.OUTPUT, "outputTank:output_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(DimensionalLaserTile.this.outputTank);
        }
    };
    private int tickTimer = 0;
    private byte multiblockTickChecker = (byte)19;
    private boolean complete = false;
    private boolean firstStageComplete = false;
    private boolean initialized = true;
    private boolean soundPlayed = false;
    public ItemStackHandler inventory = this.createHandler(4);

    public DimensionalLaserTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.DIMENSIONAL_LASER_TILE.get(), pos, state);
        this.outputTank.setAllowAny(true);
    }

    @Override
    public void tick() {
        this.updateClients();
        this.multiblockTickChecker = (byte)(this.multiblockTickChecker + 1);
        if (this.multiblockTickChecker == 20) {
            this.multiblockTickChecker = 0;
            this.validity = this.isMultiBlockValid((Block)VEBlocks.SOLARIUM_MACHINE_CASING_BLOCK.get());
        }
        if (!this.validity) {
            return;
        }
        if (!this.complete) {
            this.m_6596_();
            if (!this.firstStageComplete) {
                this.tickTimer();
                if (this.tickTimer >= 400) {
                    this.setFirstStageComplete();
                    this.resetTickTimer();
                }
            } else {
                this.tickTimer();
                if (this.tickTimer >= 600) {
                    this.complete = true;
                }
                if (this.tickTimer % 12 == 0 && new Random().nextInt(2) == 1) {
                    BlockPos blockPos = this.f_58857_.m_46496_(this.m_58899_().m_123341_(), 0, this.m_58899_().m_123343_(), 5);
                    blockPos = blockPos.m_175288_(this.m_58899_().m_123342_());
                    LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.f_58857_);
                    lightningBolt.m_20874_(true);
                    lightningBolt.m_6034_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
                    this.f_58857_.m_7967_((Entity)lightningBolt);
                }
            }
            if (this.initialized && !this.soundPlayed) {
                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.ENERGY_BEAM_ACTIVATE, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.soundPlayed = true;
            }
            if (this.initialized && this.firstStageComplete) {
                this.initialized = false;
                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.ENERGY_BEAM_FIRED, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        int x = this.m_58899_().m_123341_();
        int y = this.m_58899_().m_123342_();
        int z = this.m_58899_().m_123343_();
        if (this.complete) {
            for (ServerPlayer serverplayer : this.f_58857_.m_45976_(ServerPlayer.class, new AABB((double)x, (double)y, (double)z, (double)x, (double)(y - 4), (double)z).m_82377_(50.0, 50.0, 50.0))) {
                VECriteriaTriggers.CONSTRUCT_DIMENSIONAL_LASER_TRIGGER.trigger(serverplayer, 3);
            }
            ItemStack bucketTop = this.inventory.getStackInSlot(0);
            ItemStack bucketBottom = this.inventory.getStackInSlot(1);
            this.outputTank.setInput(bucketTop.m_41777_());
            this.outputTank.setOutput(bucketBottom.m_41777_());
            if (this.inputFluid(this.outputTank, 0, 1)) {
                return;
            }
            if (this.outputFluid(this.outputTank, 0, 1)) {
                return;
            }
            ItemStack rfidStack = this.inventory.getStackInSlot(2);
            if (rfidStack.m_41720_() instanceof RFIDChip) {
                CompoundTag rfidTag = rfidStack.m_41784_();
                Tag veX = rfidTag.m_128423_("ve_x");
                Tag veZ = rfidTag.m_128423_("ve_z");
                if (veX != null && veZ != null) {
                    int veXi = Integer.valueOf(veX.toString());
                    int veZi = Integer.valueOf(veZ.toString());
                    ChunkPos chunkPos = new ChunkPos(veXi, veZi);
                    BlockPos blockPos = chunkPos.m_151384_(0, 64, 0);
                    ChunkFluid fluidFromPos = WorldUtil.getFluidFromPosition(this.f_58857_, blockPos);
                    SingleChunkFluid fluid = fluidFromPos.getFluids().get(0);
                    if (super.canConsumeEnergy() && this.outputTank.getTank().getFluidAmount() < 4000) {
                        if (this.counter == 1) {
                            if (this.outputTank.isFluidValid(fluid.getFluid())) {
                                int fillSize = Math.min(fluid.getAmount(), 4000 - this.outputTank.getTank().getFluidAmount());
                                fillSize = Math.min(fillSize, fluid.getAmount());
                                this.outputTank.getTank().fill(new FluidStack(fluid.getFluid(), fillSize), IFluidHandler.FluidAction.EXECUTE);
                            }
                            --this.counter;
                            this.consumeEnergy();
                            this.m_6596_();
                        } else if (this.counter > 0) {
                            --this.counter;
                            this.consumeEnergy();
                        } else {
                            int counterTemp = this.calculateCounter((Integer)Config.DIMENSIONAL_LASER_PROCESS_TIME.get(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                            this.length = this.counter = counterTemp != 0 ? counterTemp : 1;
                        }
                    } else {
                        this.decrementSuperCounterOnNoPower();
                    }
                } else {
                    this.counter = 0;
                }
            } else {
                this.counter = 0;
            }
        }
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getTickTimer() {
        return this.tickTimer;
    }

    public void tickTimer() {
        if (this.complete) {
            return;
        }
        ++this.tickTimer;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.firstStageComplete = tag.m_128471_("first_stage_complete");
        this.complete = tag.m_128471_("fully_built");
        this.tickTimer = tag.m_128451_("tick_timer");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128379_("first_stage_complete", this.firstStageComplete);
        tag.m_128379_("fully_built", this.complete);
        tag.m_128405_("tick_timer", this.tickTimer);
        super.m_183515_(tag);
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    @Nonnull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory playerInventory, @Nonnull Player player) {
        return new DimensionalLaserContainer(id, this.f_58857_, this.f_58858_, playerInventory, player);
    }

    @Override
    @Nullable
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public void setComplete() {
        this.complete = true;
    }

    public boolean isFirstStageComplete() {
        return this.firstStageComplete;
    }

    public void setFirstStageComplete() {
        this.firstStageComplete = true;
    }

    public void resetTickTimer() {
        this.tickTimer = 0;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.DIMENSIONAL_LASER_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.DIMENSIONAL_LASER_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.DIMENSIONAL_LASER_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 3;
    }

    @Override
    public boolean isMultiBlockValid(Block block) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, -3, -1), (BlockPos)this.f_58858_.m_7918_(1, -1, 1))) {
            BlockState blockState = this.f_58857_.m_8055_(blockPos);
            if (blockState.m_60734_() == block) continue;
            return false;
        }
        return true;
    }

    public boolean getMultiblockValidity() {
        return this.validity;
    }
}

