/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.CrusherContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.recipe.CrusherRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.randoms.JavaRandomSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CrusherTile
extends VoluminousTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager inputSlotProp = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_slot");
    public VESlotManager outputSlotProp = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_slot");
    public VESlotManager rngSlotProp = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.rng_slot", SlotType.OUTPUT, "rng_slot");
    public List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(CrusherTile.this.inputSlotProp);
            this.add(CrusherTile.this.outputSlotProp);
            this.add(CrusherTile.this.rngSlotProp);
        }
    };
    private LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> this.inventory);
    private AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    public ItemStackHandler inventory = new ItemStackHandler(4){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            ItemStack referenceStack = stack.m_41777_();
            referenceStack.m_41764_(64);
            CrusherRecipe recipe = CrusherTile.this.f_58857_.m_7465_().m_44015_(CrusherRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), CrusherTile.this.f_58857_).orElse(null);
            CrusherRecipe recipe1 = CrusherTile.this.f_58857_.m_7465_().m_44015_(CrusherRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{CrusherTile.this.inputItemStack.get().m_41777_()}), CrusherTile.this.f_58857_).orElse(null);
            if (slot == 0 && recipe != null) {
                return ((Ingredient)recipe.ingredient.get()).test(stack);
            }
            if (slot == 1 && recipe1 != null) {
                return stack.m_41720_() == recipe1.result.m_41720_();
            }
            if (slot == 2 && recipe1 != null) {
                return stack.m_41720_() == recipe1.getRngItem().m_41720_();
            }
            if (slot == 3) {
                return TagUtil.isTaggedMachineUpgradeItem(stack);
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack referenceStack = stack.m_41777_();
            referenceStack.m_41764_(64);
            CrusherRecipe recipe = CrusherTile.this.f_58857_.m_7465_().m_44015_(CrusherRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), CrusherTile.this.f_58857_).orElse(null);
            CrusherRecipe recipe1 = CrusherTile.this.f_58857_.m_7465_().m_44015_(CrusherRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{CrusherTile.this.inputItemStack.get().m_41777_()}), CrusherTile.this.f_58857_).orElse(null);
            if (slot == 0 && recipe != null) {
                for (ItemStack testStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                    if (stack.m_41720_() != testStack.m_41720_()) continue;
                    return super.insertItem(slot, stack, simulate);
                }
            } else if (slot == 1 && recipe1 != null ? stack.m_41720_() == recipe1.result.m_41720_() : (slot == 2 && recipe1 != null ? stack.m_41720_() == recipe1.getRngItem().m_41720_() : slot == 3 && TagUtil.isTaggedMachineUpgradeItem(stack))) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (CrusherTile.this.f_58857_ != null && slot > 0 && !simulate) {
                JavaRandomSource rand = new JavaRandomSource(new Random().nextLong());
                Optional<CrusherRecipe> crusherRecipe = RecipeUtil.getCrusherRecipeFromAnyOutputAndTryInput(CrusherTile.this.inventory.getStackInSlot(slot).m_41777_().m_41720_(), CrusherTile.this.inventory.getStackInSlot(0).m_41720_(), CrusherTile.this.f_58857_);
                if (crusherRecipe.isPresent() && crusherRecipe.get().getMinExperience() != 0) {
                    CrusherTile.this.f_58857_.m_7967_((Entity)new ExperienceOrb(CrusherTile.this.f_58857_, (double)CrusherTile.this.f_58858_.m_123341_(), (double)CrusherTile.this.f_58858_.m_123342_(), (double)CrusherTile.this.f_58858_.m_123343_(), amount * Mth.m_216271_((RandomSource)rand, (int)crusherRecipe.get().getMinExperience(), (int)crusherRecipe.get().getMaxExperience())));
                }
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CrusherTile.this.m_6596_();
        }
    };

    public CrusherTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.CRUSHER_TILE.get(), pos, state);
    }

    @Deprecated
    public CrusherTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.CRUSHER_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack input = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack output = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack rng = this.inventory.getStackInSlot(2).m_41777_();
        CrusherRecipe recipe = this.f_58857_.m_7465_().m_44015_(CrusherRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_).orElse(null);
        this.inputItemStack.set(input.m_41777_());
        if (!input.m_41619_()) {
            if (output.m_41613_() + recipe.getOutputAmount() < 64 && rng.m_41613_() + recipe.getOutputRngAmount() < 64 && this.canConsumeEnergy()) {
                if (this.counter == 1) {
                    this.inventory.extractItem(0, recipe.ingredientCount, false);
                    ItemStack newOutputStack = recipe.getResult().m_41777_();
                    if (output.m_41720_() != newOutputStack.m_41720_() || output.m_41720_() == Items.f_41852_) {
                        if (output.m_41720_() == Items.f_41852_) {
                            output.m_41764_(1);
                        }
                        newOutputStack.m_41764_(recipe.getOutputAmount());
                        this.inventory.insertItem(1, newOutputStack.m_41777_(), false);
                    } else {
                        output.m_41764_(recipe.getOutputAmount());
                        this.inventory.insertItem(1, output.m_41777_(), false);
                    }
                    if (recipe.getChance() != 0.0f) {
                        ItemStack newRngStack = recipe.getRngItem().m_41777_();
                        float random = Mth.m_14154_((float)(0.0f + this.f_58857_.m_213780_().m_188501_() * -1.0f));
                        if (random <= recipe.getChance()) {
                            if (rng.m_41720_() != recipe.getRngItem().m_41720_()) {
                                if (rng.m_41720_() == Items.f_41852_) {
                                    rng.m_41764_(1);
                                }
                                newRngStack.m_41764_(recipe.getOutputRngAmount());
                                this.inventory.insertItem(2, newRngStack.m_41777_(), false);
                            } else {
                                rng.m_41764_(recipe.getOutputRngAmount());
                                this.inventory.insertItem(2, rng.m_41777_(), false);
                            }
                        }
                    }
                    --this.counter;
                    this.consumeEnergy();
                    this.m_6596_();
                } else if (this.counter > 0) {
                    --this.counter;
                    this.consumeEnergy();
                    if (++this.sound_tick == 19) {
                        this.sound_tick = 0;
                        if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                            this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.CRUSHER, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                } else if (output.m_41619_() && rng.m_41619_() || output.m_41619_() && rng.m_41720_() == recipe.getRngItem().m_41720_() || output.m_41720_() == recipe.getResult().m_41720_() && rng.m_41720_() == recipe.getRngItem().m_41720_() || output.m_41720_() == recipe.getResult().m_41720_() && rng.m_41619_()) {
                    this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                } else {
                    this.counter = 0;
                }
            } else if (!this.canConsumeEnergy()) {
                this.decrementSuperCounterOnNoPower();
            } else {
                this.counter = 0;
            }
        } else {
            this.counter = 0;
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new CrusherContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.CRUSHER_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.CRUSHER_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.CRUSHER_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 3;
    }
}

