/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.CompressorContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.recipe.CompressorRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CompressorTile
extends VoluminousTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager inputSlotManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_slot");
    public VESlotManager outputSlotManager = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_slot");
    public List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(CompressorTile.this.inputSlotManager);
            this.add(CompressorTile.this.outputSlotManager);
        }
    };
    private final AtomicReference<ItemStack> inputItemStack = new AtomicReference<ItemStack>(new ItemStack((ItemLike)Items.f_41852_, 0));
    private final ItemStackHandler inventory = this.createHandler();

    public CompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.COMPRESSOR_TILE.get(), pos, state);
    }

    @Deprecated
    public CompressorTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.COMPRESSOR_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack input = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack output = this.inventory.getStackInSlot(1).m_41777_();
        CompressorRecipe recipe = this.f_58857_.m_7465_().m_44015_(CompressorRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_).orElse(null);
        this.inputItemStack.set(input.m_41777_());
        if (!input.m_41619_()) {
            if (output.m_41613_() + recipe.getOutputAmount() < 64 && this.canConsumeEnergy()) {
                if (this.counter == 1) {
                    this.inventory.extractItem(0, recipe.ingredientCount, false);
                    ItemStack newOutputStack = recipe.getResult().m_41777_();
                    if (output.m_41720_() != newOutputStack.m_41720_()) {
                        if (output.m_41720_() == Items.f_41852_) {
                            output.m_41764_(1);
                        }
                        newOutputStack.m_41764_(recipe.getOutputAmount());
                        this.inventory.insertItem(1, newOutputStack.m_41777_(), false);
                    } else {
                        output.m_41764_(recipe.getOutputAmount());
                        this.inventory.insertItem(1, output.m_41777_(), false);
                    }
                    --this.counter;
                    this.consumeEnergy();
                    this.m_6596_();
                } else if (this.counter > 0) {
                    --this.counter;
                    this.consumeEnergy();
                    if (++this.sound_tick == 19) {
                        this.sound_tick = 0;
                        if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                            this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.COMPRESSOR, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                } else if (output.m_41619_() || output.m_41720_() == recipe.getResult().m_41720_()) {
                    this.counter = recipe.getProcessTime();
                    this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()));
                } else {
                    this.counter = 0;
                }
            } else if (!this.canConsumeEnergy()) {
                this.decrementSuperCounterOnNoPower();
            } else {
                this.counter = 0;
            }
        } else {
            this.counter = 0;
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                CompressorTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ItemStack referenceStack = stack.m_41777_();
                referenceStack.m_41764_(64);
                CompressorRecipe recipe = CompressorTile.this.f_58857_.m_7465_().m_44015_(CompressorRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), CompressorTile.this.f_58857_).orElse(null);
                CompressorRecipe recipe1 = CompressorTile.this.f_58857_.m_7465_().m_44015_(CompressorRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{CompressorTile.this.inputItemStack.get().m_41777_()}), CompressorTile.this.f_58857_).orElse(null);
                if (slot == 0 && recipe != null) {
                    return ((Ingredient)recipe.ingredient.get()).test(stack);
                }
                if (slot == 1 && recipe1 != null) {
                    return stack.m_41720_() == recipe1.result.m_41720_();
                }
                if (slot == 2) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack referenceStack = stack.m_41777_();
                referenceStack.m_41764_(64);
                CompressorRecipe recipe = CompressorTile.this.f_58857_.m_7465_().m_44015_(CompressorRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{referenceStack}), CompressorTile.this.f_58857_).orElse(null);
                CompressorRecipe recipe1 = CompressorTile.this.f_58857_.m_7465_().m_44015_(CompressorRecipe.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{CompressorTile.this.inputItemStack.get().m_41777_()}), CompressorTile.this.f_58857_).orElse(null);
                if (slot == 0 && recipe != null) {
                    for (ItemStack testStack : ((Ingredient)recipe.ingredient.get()).m_43908_()) {
                        if (stack.m_41720_() != testStack.m_41720_()) continue;
                        return super.insertItem(slot, stack, simulate);
                    }
                } else if (slot == 1 && recipe1 != null ? stack.m_41720_() == recipe1.result.m_41720_() : slot == 2 && TagUtil.isTaggedMachineUpgradeItem(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new CompressorContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    @Override
    public void updatePacketFromGui(boolean status, int slotId) {
        if (slotId == this.inputSlotManager.getSlotNum()) {
            this.inputSlotManager.setStatus(status);
        } else if (slotId == this.outputSlotManager.getSlotNum()) {
            this.outputSlotManager.setStatus(status);
        }
    }

    @Override
    public void updatePacketFromGui(int direction, int slotId) {
        if (slotId == this.inputSlotManager.getSlotNum()) {
            this.inputSlotManager.setDirection(direction);
        } else if (slotId == this.outputSlotManager.getSlotNum()) {
            this.outputSlotManager.setDirection(direction);
        }
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.COMPRESSOR_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.COMPRESSOR_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.COMPRESSOR_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 2;
    }
}

