/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.CombustionGeneratorContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorFuelRecipe;
import com.veteam.voluminousenergy.recipe.CombustionGenerator.CombustionGeneratorOxidizerRecipe;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CombustionGeneratorTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager oxiInSm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "oxi_in_sm");
    public VESlotManager oxiOutSm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "oxi_out_sm");
    public VESlotManager fuelInSm = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "fuel_in_sm");
    public VESlotManager fuelOutSm = new VESlotManager(3, Direction.SOUTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "fuel_out_sm");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(CombustionGeneratorTile.this.oxiInSm);
            this.add(CombustionGeneratorTile.this.oxiOutSm);
            this.add(CombustionGeneratorTile.this.fuelInSm);
            this.add(CombustionGeneratorTile.this.fuelOutSm);
        }
    };
    private final int tankCapacity = 4000;
    private final RelationalTank oxidizerTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "oxidizerTank:oxidizer_tank_gui");
    private final RelationalTank fuelTank = new RelationalTank(new FluidTank(4000), 1, null, null, TankType.INPUT, "fuelTank:fuel_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(CombustionGeneratorTile.this.oxidizerTank);
            this.add(CombustionGeneratorTile.this.fuelTank);
        }
    };
    private int energyRate;
    private final ItemStackHandler inventory = this.createHandler();
    private static final Logger LOGGER = LogManager.getLogger();

    public CombustionGeneratorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.COMBUSTION_GENERATOR_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        ItemStack bucketStack;
        Fluid fluid;
        if (!this.oxidizerTank.isValidFluidsSet()) {
            this.oxidizerTank.setValidFluids(RecipeUtil.getOxidizerFluids(this.f_58857_));
        }
        if (!this.fuelTank.isValidFluidsSet()) {
            this.fuelTank.setValidFluids(RecipeUtil.getFuelCombustionInputFluidsParallel(this.f_58857_));
        }
        this.updateClients();
        ItemStack oxidizerInput = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack oxidizerOutput = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack fuelInput = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack fuelOutput = this.inventory.getStackInSlot(3).m_41777_();
        if (oxidizerInput.m_41777_() != ItemStack.f_41583_ && (oxidizerOutput.m_41777_() == ItemStack.f_41583_ || oxidizerOutput.m_41777_().m_41720_() == Items.f_42446_) && oxidizerInput.m_41777_().m_41720_() instanceof BucketItem && oxidizerInput.m_41613_() == 1 && this.oxidizerTank.isFluidValid(fluid = ((BucketItem)oxidizerInput.m_41777_().m_41720_()).getFluid()) && (this.oxidizerTank.getTank().isEmpty() || this.oxidizerTank.getTank().getFluid().isFluidEqual(new FluidStack(fluid, 1000)) && this.oxidizerTank.getTank().getFluidAmount() + 1000 <= 4000)) {
            this.oxidizerTank.getTank().fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            this.inventory.extractItem(0, 1, false);
            this.inventory.insertItem(1, new ItemStack((ItemLike)Items.f_42446_, 1), false);
        }
        if (oxidizerInput.m_41777_().m_41720_() == Items.f_42446_ && (oxidizerOutput.m_41777_() == ItemStack.f_41583_ || oxidizerOutput.m_41777_().m_41720_() == Items.f_42446_) && this.oxidizerTank.getTank().getFluidAmount() >= 1000) {
            bucketStack = new ItemStack((ItemLike)this.oxidizerTank.getTank().getFluid().getRawFluid().m_6859_(), 1);
            this.oxidizerTank.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            this.inventory.extractItem(0, 1, false);
            this.inventory.insertItem(1, bucketStack, false);
        }
        if (fuelInput.m_41777_() != ItemStack.f_41583_ && CombustionGeneratorTile.checkOutputSlotForEmptyOrBucket(fuelOutput.m_41777_()) && fuelInput.m_41777_().m_41720_() instanceof BucketItem && fuelInput.m_41613_() == 1 && this.fuelTank.isFluidValid(fluid = ((BucketItem)fuelInput.m_41777_().m_41720_()).getFluid()) && (this.fuelTank.getTank().isEmpty() || this.fuelTank.getTank().getFluid().isFluidEqual(new FluidStack(fluid, 1000)) && this.fuelTank.getTank().getFluidAmount() + 1000 <= 4000)) {
            this.fuelTank.getTank().fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            this.inventory.extractItem(2, 1, false);
            this.inventory.insertItem(3, new ItemStack((ItemLike)Items.f_42446_, 1), false);
        }
        if (fuelInput.m_41777_().m_41720_() == Items.f_42446_ && fuelOutput.m_41777_() == ItemStack.f_41583_ && this.fuelTank.getTank().getFluidAmount() >= 1000) {
            bucketStack = new ItemStack((ItemLike)this.fuelTank.getTank().getFluid().getRawFluid().m_6859_(), 1);
            this.fuelTank.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            this.inventory.extractItem(2, 1, false);
            this.inventory.insertItem(3, bucketStack, false);
        }
        if (this.counter > 0) {
            if (this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0) + this.energyRate <= (Integer)Config.COMBUSTION_GENERATOR_MAX_POWER.get()) {
                --this.counter;
                this.energy.ifPresent(e -> e.addEnergy(this.energyRate));
                if (++this.sound_tick == 19) {
                    this.sound_tick = 0;
                    if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
            this.m_6596_();
        } else if (!(this.oxidizerTank == null && this.oxidizerTank.getTank().isEmpty() || this.fuelTank == null && this.fuelTank.getTank().isEmpty())) {
            CombustionGeneratorOxidizerRecipe oxidizerRecipe = RecipeUtil.getOxidizerCombustionRecipe(this.f_58857_, this.oxidizerTank.getTank().getFluid().copy());
            CombustionGeneratorFuelRecipe fuelRecipe = RecipeUtil.getFuelCombustionRecipe(this.f_58857_, this.fuelTank.getTank().getFluid().copy());
            if (oxidizerRecipe != null && fuelRecipe != null) {
                int amount = 250;
                if (this.oxidizerTank.getTank().getFluidAmount() >= amount && this.fuelTank.getTank().getFluidAmount() >= amount) {
                    this.oxidizerTank.getTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    this.fuelTank.getTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    this.counter = (Boolean)Config.COMBUSTION_GENERATOR_BALANCED_MODE.get() != false ? oxidizerRecipe.getProcessTime() / 4 : (Integer)Config.COMBUSTION_GENERATOR_FIXED_TICK_TIME.get() / 4;
                    this.energyRate = ((VEFluidRecipe)fuelRecipe).getProcessTime() / oxidizerRecipe.getProcessTime();
                    this.length = this.counter;
                    this.m_6596_();
                }
            }
        }
        if (this.counter == 0) {
            this.energyRate = 0;
        }
        this.sendOutPower();
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energyRate = tag.m_128451_("energy_rate");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128405_("energy_rate", this.energyRate);
        super.m_183515_(tag);
    }

    public static int receiveEnergy(BlockEntity tileEntity, Direction from, int maxReceive) {
        return tileEntity.getCapability(ForgeCapabilities.ENERGY, from).map(handler -> handler.receiveEnergy(maxReceive, false)).orElse(0);
    }

    private void sendOutPower() {
        this.energy.ifPresent(energy -> {
            for (Direction dir : Direction.values()) {
                BlockEntity tileEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                Direction opposite = dir.m_122424_();
                if (tileEntity == null) continue;
                int smallest = Math.min((Integer)Config.COMBUSTION_GENERATOR_SEND.get(), energy.getEnergyStored());
                int received = CombustionGeneratorTile.receiveEnergy(tileEntity, opposite, smallest);
                energy.consumeEnergy(received);
                if (energy.getEnergyStored() <= 0) break;
            }
        });
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(4){

            protected void onContentsChanged(int slot) {
                CombustionGeneratorTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (!(stack.m_41720_() instanceof BucketItem)) {
                    return false;
                }
                if (slot == 0 || slot == 1) {
                    CombustionGeneratorOxidizerRecipe recipe = RecipeUtil.getOxidizerCombustionRecipe(CombustionGeneratorTile.this.f_58857_, new FluidStack(((BucketItem)stack.m_41720_()).getFluid(), 1000));
                    return recipe != null || stack.m_41720_() == Items.f_42446_;
                }
                if (slot == 2 || slot == 3) {
                    CombustionGeneratorFuelRecipe recipe = RecipeUtil.getFuelCombustionRecipe(CombustionGeneratorTile.this.f_58857_, new FluidStack(((BucketItem)stack.m_41720_()).getFluid(), 1000));
                    return recipe != null || stack.m_41720_() == Items.f_42446_;
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new CombustionGeneratorContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @NotNull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public int progressCounterPX(int px) {
        if (this.counter == 0) {
            return 0;
        }
        return px * (this.counter * 100 / this.length) / 100;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.oxidizerTank.getTank().getFluid();
        }
        if (num == 1) {
            return this.fuelTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public int getEnergyRate() {
        return this.energyRate;
    }

    public RelationalTank getOxidizerTank() {
        return this.oxidizerTank;
    }

    public RelationalTank getFuelTank() {
        return this.fuelTank;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.COMBUSTION_GENERATOR_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return -1;
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.COMBUSTION_GENERATOR_SEND.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return -1;
    }
}

