/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.CentrifugalAgitatorContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.recipe.CentrifugalAgitatorRecipe;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class CentrifugalAgitatorTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager input0sm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_0_sm");
    public VESlotManager input1sm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "input_1_sm");
    public VESlotManager output0sm = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_0_sm");
    public VESlotManager output1sm = new VESlotManager(3, Direction.SOUTH, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_1_sm");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(CentrifugalAgitatorTile.this.input0sm);
            this.add(CentrifugalAgitatorTile.this.input1sm);
            this.add(CentrifugalAgitatorTile.this.output0sm);
            this.add(CentrifugalAgitatorTile.this.output1sm);
        }
    };
    RelationalTank inputTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "inputTank:input_tank_gui");
    RelationalTank outputTank0 = new RelationalTank(new FluidTank(4000), 1, null, null, TankType.OUTPUT, 0, "outputTank0:output_tank_0_gui");
    RelationalTank outputTank1 = new RelationalTank(new FluidTank(4000), 2, null, null, TankType.OUTPUT, 1, "outputTank1:output_tank_1_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(CentrifugalAgitatorTile.this.inputTank);
            this.add(CentrifugalAgitatorTile.this.outputTank0);
            this.add(CentrifugalAgitatorTile.this.outputTank1);
        }
    };
    public ItemStackHandler inventory = this.createHandler(5);

    public CentrifugalAgitatorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.CENTRIFUGAL_AGITATOR_TILE.get(), pos, state);
        this.inputTank.setAllowAny(true);
        this.outputTank0.setAllowAny(true);
        this.outputTank1.setAllowAny(true);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    public void tick() {
        CentrifugalAgitatorRecipe recipe;
        this.updateClients();
        ItemStack input = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack input1 = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack output0 = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack output1 = this.inventory.getStackInSlot(3).m_41777_();
        this.inputTank.setInput(input.m_41777_());
        this.inputTank.setOutput(input1.m_41777_());
        this.outputTank0.setOutput(output0);
        this.outputTank1.setOutput(output1);
        if (this.inputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.outputFluidStatic(this.outputTank0, 2)) {
            return;
        }
        if (this.outputFluidStatic(this.outputTank1, 3)) {
            return;
        }
        if (this.inputTank != null && (recipe = RecipeUtil.getCentrifugalAgitatorRecipe(this.f_58857_, this.inputTank.getTank().getFluid().copy())) != null && this.outputTank0 != null && this.outputTank1 != null) {
            if (this.inputTank.getTank().getFluidAmount() >= ((VEFluidRecipe)recipe).getInputAmount() && this.outputTank0.getTank().getFluidAmount() + ((VEFluidRecipe)recipe).getOutputAmount() <= 4000 && this.outputTank1.getTank().getFluidAmount() + ((VEFluidRecipe)recipe).getFluids().get(1).getAmount() <= 4000) {
                if (this.canConsumeEnergy()) {
                    if (this.counter == 1) {
                        this.inputTank.getTank().drain(((VEFluidRecipe)recipe).getInputAmount(), IFluidHandler.FluidAction.EXECUTE);
                        if (this.outputTank0.getTank().getFluid().getRawFluid() != ((VEFluidRecipe)recipe).getOutputFluid().getRawFluid()) {
                            this.outputTank0.getTank().setFluid(((VEFluidRecipe)recipe).getOutputFluid().copy());
                        } else {
                            this.outputTank0.getTank().fill(((VEFluidRecipe)recipe).getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        CentrifugalAgitatorRecipe centrifugalAgitatorRecipe = recipe;
                        if (this.outputTank1.getTank().getFluid().getRawFluid() != centrifugalAgitatorRecipe.getSecondFluid().getRawFluid()) {
                            this.outputTank1.getTank().setFluid(centrifugalAgitatorRecipe.getSecondFluid().copy());
                        } else {
                            this.outputTank1.getTank().fill(centrifugalAgitatorRecipe.getSecondResult().copy(), IFluidHandler.FluidAction.EXECUTE);
                        }
                        --this.counter;
                        this.consumeEnergy();
                        this.m_6596_();
                    } else if (this.counter > 0) {
                        --this.counter;
                        this.consumeEnergy();
                        if (++this.sound_tick == 19) {
                            this.sound_tick = 0;
                            if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    } else {
                        this.length = this.counter = this.calculateCounter(((VEFluidRecipe)recipe).getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()));
                    }
                } else {
                    this.decrementSuperCounterOnNoPower();
                }
            } else {
                this.counter = 0;
            }
        }
    }

    @Override
    public int getUpgradeSlotId() {
        return 4;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new CentrifugalAgitatorContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.inputTank.getTank().getFluid();
        }
        if (num == 1) {
            return this.outputTank0.getTank().getFluid();
        }
        if (num == 2) {
            return this.outputTank1.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    public RelationalTank getInputTank() {
        return this.inputTank;
    }

    public RelationalTank getOutputTank0() {
        return this.outputTank0;
    }

    public RelationalTank getOutputTank1() {
        return this.outputTank1;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.CENTRIFUGAL_AGITATOR_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.CENTRIFUGAL_AGITATOR_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.CENTRIFUGAL_AGITATOR_TRANSFER.get();
    }
}

