/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.BlastFurnaceContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEMultiBlockTileEntity;
import com.veteam.voluminousenergy.recipe.IndustrialBlastingRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BlastFurnaceTile
extends VEMultiBlockTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager heatTankItemTopManager = new VESlotManager(0, Direction.UP, false, "slot.voluminousenergy.input_slot", SlotType.INPUT, "heat_top_manager");
    public VESlotManager heatTankItemBottomManager = new VESlotManager(1, Direction.DOWN, false, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "heat_bottom_manager");
    public VESlotManager firstInputSlotManager = new VESlotManager(2, Direction.EAST, false, "slot.voluminousenergy.input_slot", SlotType.INPUT, "first_input_manager");
    public VESlotManager secondInputSlotManager = new VESlotManager(3, Direction.WEST, false, "slot.voluminousenergy.input_slot", SlotType.INPUT, "second_input_manager");
    public VESlotManager outputSlotManager = new VESlotManager(4, Direction.NORTH, false, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_manager");
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(BlastFurnaceTile.this.heatTankItemTopManager);
            this.add(BlastFurnaceTile.this.heatTankItemBottomManager);
            this.add(BlastFurnaceTile.this.firstInputSlotManager);
            this.add(BlastFurnaceTile.this.secondInputSlotManager);
            this.add(BlastFurnaceTile.this.outputSlotManager);
        }
    };
    RelationalTank heatTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "heatTank:heat_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(BlastFurnaceTile.this.heatTank);
            BlastFurnaceTile.this.heatTank.setAllowAny(true);
        }
    };
    private byte tick = (byte)19;
    public ItemStackHandler inventory = this.createHandler();

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public BlastFurnaceTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.BLAST_FURNACE_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        IndustrialBlastingRecipe recipe;
        this.updateClients();
        this.tick = (byte)(this.tick + 1);
        if (this.tick == 20) {
            this.tick = 0;
            this.validity = this.isMultiBlockValid((Block)VEBlocks.TITANIUM_MACHINE_CASING_BLOCK.get());
        }
        if (!this.validity) {
            return;
        }
        ItemStack heatTankItemInputTop = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack heatTankItemInputBottom = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack firstItemInput = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack secondItemInput = this.inventory.getStackInSlot(3).m_41777_();
        ItemStack itemOutput = this.inventory.getStackInSlot(4).m_41777_();
        this.heatTank.setIOItemstack(heatTankItemInputTop.m_41777_(), heatTankItemInputBottom.m_41777_());
        if (this.inputFluid(this.heatTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.heatTank, 0, 1)) {
            return;
        }
        if (!(this.heatTank == null && this.heatTank.getTank().isEmpty() || (recipe = RecipeUtil.getIndustrialBlastingRecipe(this.f_58857_, firstItemInput.m_41777_(), secondItemInput.m_41777_())) == null)) {
            if (itemOutput.m_41613_() < recipe.getResult().m_41741_() && this.heatTank.getTank().getFluidAmount() >= (Integer)Config.BLAST_FURNACE_HEAT_SOURCE_CONSUMPTION.get() && this.heatTank.getTank().getFluid().getRawFluid().getFluidType().getTemperature() >= recipe.getMinimumHeat() && (itemOutput.m_41619_() || recipe.getResult().m_41720_().equals(itemOutput.m_41720_())) && recipe.getFirstInputAsList().contains(firstItemInput.m_41720_()) && firstItemInput.m_41613_() >= recipe.getIngredientCount() && ((ArrayList)recipe.ingredientListIncludingSeconds.get()).contains(secondItemInput.m_41720_()) && secondItemInput.m_41613_() >= recipe.getSecondInputAmount()) {
                if (this.canConsumeEnergy()) {
                    if (this.counter == 1) {
                        this.heatTank.getTank().drain(((Integer)Config.BLAST_FURNACE_HEAT_SOURCE_CONSUMPTION.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
                        this.inventory.extractItem(2, recipe.getIngredientCount(), false);
                        this.inventory.extractItem(3, recipe.getSecondInputAmount(), false);
                        if (itemOutput.m_41720_() != recipe.getResult().m_41720_() && itemOutput.m_41720_() == Items.f_41852_) {
                            itemOutput.m_41764_(1);
                        }
                        this.inventory.insertItem(4, recipe.getResult().m_41777_(), false);
                        --this.counter;
                        this.consumeEnergy();
                        this.m_6596_();
                    } else if (this.counter > 0) {
                        --this.counter;
                        this.consumeEnergy();
                        if (++this.sound_tick == 19) {
                            this.sound_tick = 0;
                            if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.GENERAL_MACHINE_NOISE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                        }
                    } else {
                        this.length = this.counter = this.calculateCounter(recipe.getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                    }
                } else {
                    this.decrementSuperCounterOnNoPower();
                }
            } else {
                this.counter = 0;
            }
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                BlastFurnaceTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    return stack.m_41720_() instanceof BucketItem || stack.m_41720_() == Items.f_42446_;
                }
                if (slot == 2) {
                    return RecipeUtil.isFirstIngredientForIndustrialBlastingRecipe(BlastFurnaceTile.this.f_58857_, stack.m_41777_());
                }
                if (slot == 3) {
                    return RecipeUtil.isSecondIngredientForIndustrialBlastingRecipe(BlastFurnaceTile.this.f_58857_, stack.m_41777_());
                }
                if (slot == 4) {
                    return RecipeUtil.isAnOutputForIndustrialBlastingRecipe(BlastFurnaceTile.this.f_58857_, stack.m_41777_());
                }
                if (slot == 5) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return false;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new BlastFurnaceContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.heatTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    public boolean getMultiblockValidity() {
        return this.validity;
    }

    public RelationalTank getHeatTank() {
        return this.heatTank;
    }

    public int getTemperatureKelvin() {
        return this.heatTank.getTank().getFluid().getRawFluid().getFluidType().getTemperature();
    }

    public int getTemperatureCelsius() {
        return this.getTemperatureKelvin() - 273;
    }

    public int getTemperatureFahrenheit() {
        return (int)((double)(this.getTemperatureKelvin() - 273) * 1.8) + 32;
    }

    @Override
    public void updatePacketFromGui(boolean status, int slotId) {
        if (slotId == this.heatTankItemTopManager.getSlotNum()) {
            this.heatTankItemTopManager.setStatus(status);
        } else if (slotId == this.heatTankItemBottomManager.getSlotNum()) {
            this.heatTankItemBottomManager.setStatus(status);
        } else if (slotId == this.firstInputSlotManager.getSlotNum()) {
            this.firstInputSlotManager.setStatus(status);
        } else if (slotId == this.secondInputSlotManager.getSlotNum()) {
            this.secondInputSlotManager.setStatus(status);
        } else if (slotId == this.outputSlotManager.getSlotNum()) {
            this.outputSlotManager.setStatus(status);
        }
    }

    @Override
    public void updatePacketFromGui(int direction, int slotId) {
        if (slotId == this.heatTankItemTopManager.getSlotNum()) {
            this.heatTankItemTopManager.setDirection(direction);
        } else if (slotId == this.heatTankItemBottomManager.getSlotNum()) {
            this.heatTankItemBottomManager.setDirection(direction);
        } else if (slotId == this.firstInputSlotManager.getSlotNum()) {
            this.firstInputSlotManager.setDirection(direction);
        } else if (slotId == this.secondInputSlotManager.getSlotNum()) {
            this.secondInputSlotManager.setDirection(direction);
        } else if (slotId == this.outputSlotManager.getSlotNum()) {
            this.outputSlotManager.setDirection(direction);
        }
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.BLAST_FURNACE_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.BLAST_FURNACE_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.BLAST_FURNACE_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 5;
    }
}

