/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.BatteryBoxContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VoluminousTileEntity;
import com.veteam.voluminousenergy.items.batteries.VEEnergyItem;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.buttons.VEPowerIOManager;
import com.veteam.voluminousenergy.tools.buttons.batteryBox.VEBatterySwitchManager;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.SlotType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatteryBoxTile
extends VoluminousTileEntity
implements IVEPoweredTileEntity {
    public VESlotManager topManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_slot");
    public VESlotManager bottomManager = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_slot");
    private final int POWER_MAX_TX = (Integer)Config.BATTERY_BOX_TRANSFER.get();
    private final int MAX_POWER = (Integer)Config.BATTERY_BOX_MAX_POWER.get();
    private final LazyOptional<ItemStackHandler> handler = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandlerModifiable> topHandler = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 6));
    private final LazyOptional<IItemHandlerModifiable> bottomHandler = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 6, 12));
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(BatteryBoxTile.this.topManager);
            this.add(BatteryBoxTile.this.bottomManager);
        }
    };
    private final VEBatterySwitchManager[] switchManagers = new VEBatterySwitchManager[]{new VEBatterySwitchManager(0, true), new VEBatterySwitchManager(1, true), new VEBatterySwitchManager(2, true), new VEBatterySwitchManager(3, true), new VEBatterySwitchManager(4, true), new VEBatterySwitchManager(5, true)};
    private boolean topIsIngress = true;
    private final VEPowerIOManager powerIOManager = new VEPowerIOManager(true);
    public ItemStackHandler inventory = new ItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BatteryBoxTile.this.m_6596_();
        }
    };

    public BatteryBoxTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.BATTERY_BOX_TILE.get(), pos, state);
    }

    @Deprecated
    public BatteryBoxTile(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.BATTERY_BOX_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        this.updateClients();
        for (int i = 0; i < 12; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_() || !this.inventory.getStackInSlot(i).getCapability(ForgeCapabilities.ENERGY).isPresent()) continue;
            if (i >= 6) {
                int j = i - 6;
                if (this.switchManagers[j].isFlipped()) {
                    this.dischargeItem(this.inventory.getStackInSlot(j));
                } else {
                    this.chargeItem(this.inventory.getStackInSlot(j));
                }
            } else if (this.switchManagers[i].isFlipped()) {
                this.dischargeItem(this.inventory.getStackInSlot(i));
            } else {
                this.chargeItem(this.inventory.getStackInSlot(i));
            }
            this.moveItem(i);
        }
        if (this.powerIOManager.isFlipped()) {
            this.sendOutPower();
        }
    }

    private void dischargeItem(ItemStack itemStack) {
        this.energy.ifPresent(teEnergy -> {
            if (teEnergy.getEnergyStored() < teEnergy.getMaxEnergyStored()) {
                itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyItem -> {
                    if (energyItem.canExtract()) {
                        int toExtract;
                        if (itemStack.m_41720_() instanceof VEEnergyItem) {
                            int maxExtractItem = ((VEEnergyItem)itemStack.m_41720_()).getMaxTransfer();
                            toExtract = Math.min(energyItem.getEnergyStored(), maxExtractItem);
                            toExtract = Math.min(toExtract, this.POWER_MAX_TX);
                        } else {
                            toExtract = Math.min(energyItem.getEnergyStored(), this.POWER_MAX_TX);
                        }
                        if (energyItem.getEnergyStored() > 0) {
                            if (toExtract + teEnergy.getEnergyStored() <= this.MAX_POWER) {
                                energyItem.extractEnergy(toExtract, false);
                                teEnergy.receiveEnergy(toExtract, false);
                            } else if (teEnergy.getEnergyStored() != this.MAX_POWER) {
                                energyItem.extractEnergy(this.MAX_POWER - teEnergy.getEnergyStored(), false);
                                teEnergy.receiveEnergy(this.MAX_POWER - teEnergy.getEnergyStored(), false);
                            }
                        }
                    }
                });
            }
        });
    }

    private void chargeItem(ItemStack itemStack) {
        this.energy.ifPresent(teEnergy -> {
            if (teEnergy.getEnergyStored() > 0) {
                itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyItem -> {
                    if (energyItem.canReceive()) {
                        int toReceive;
                        if (itemStack.m_41720_() instanceof VEEnergyItem) {
                            int maxReceiveItem = ((VEEnergyItem)itemStack.m_41720_()).getMaxTransfer();
                            toReceive = Math.min(energyItem.getMaxEnergyStored() - energyItem.getEnergyStored(), maxReceiveItem);
                            toReceive = Math.min(toReceive, this.POWER_MAX_TX);
                            toReceive = Math.min(toReceive, teEnergy.getEnergyStored());
                        } else {
                            toReceive = Math.min(energyItem.getMaxEnergyStored() - energyItem.getEnergyStored(), this.POWER_MAX_TX);
                        }
                        if (toReceive + teEnergy.getEnergyStored() <= energyItem.getMaxEnergyStored()) {
                            teEnergy.extractEnergy(toReceive, false);
                            energyItem.receiveEnergy(toReceive, false);
                        } else if (energyItem.getEnergyStored() != energyItem.getMaxEnergyStored()) {
                            teEnergy.extractEnergy(energyItem.getMaxEnergyStored() - energyItem.getEnergyStored(), false);
                            energyItem.receiveEnergy(energyItem.getMaxEnergyStored() - energyItem.getEnergyStored(), false);
                        }
                    }
                });
            }
        });
    }

    private void moveItem(int i) {
        if (i < 6) {
            ItemStack itemStack = this.inventory.getStackInSlot(i).m_41777_();
            if (this.inventory.getStackInSlot(i + 6).m_41619_()) {
                itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                    if (!this.switchManagers[i].isFlipped() && energy.getEnergyStored() == energy.getMaxEnergyStored() || this.switchManagers[i].isFlipped() && energy.getEnergyStored() == 0) {
                        this.inventory.extractItem(i, 1, false);
                        this.inventory.insertItem(i + 6, itemStack.m_41777_(), false);
                    }
                });
            }
        } else if (this.inventory.getStackInSlot(i - 6).m_41619_()) {
            ItemStack itemStack = this.inventory.getStackInSlot(i).m_41777_();
            itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energy -> {
                if (this.switchManagers[i - 6].isFlipped() && energy.getEnergyStored() == energy.getMaxEnergyStored() || !this.switchManagers[i - 6].isFlipped() && energy.getEnergyStored() == 0) {
                    this.inventory.extractItem(i, 1, false);
                    this.inventory.insertItem(i - 6, itemStack.m_41777_(), false);
                }
            });
        }
    }

    public static int receiveEnergy(BlockEntity tileEntity, Direction from, int maxReceive) {
        return tileEntity.getCapability(ForgeCapabilities.ENERGY, from).map(handler -> handler.receiveEnergy(maxReceive, false)).orElse(0);
    }

    private void sendOutPower() {
        this.energy.ifPresent(energy -> {
            for (Direction dir : Direction.values()) {
                BlockEntity tileEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                Direction opposite = dir.m_122424_();
                if (tileEntity == null) continue;
                int smallest = Math.min(this.getTransferRate(), energy.getEnergyStored());
                int received = BatteryBoxTile.receiveEnergy(tileEntity, opposite, smallest);
                energy.consumeEnergy(received);
                if (energy.getEnergyStored() <= 0) break;
            }
        });
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.switchManagers[0].setFlipped(tag.m_128471_("slot_pair_mode_0"));
        this.switchManagers[1].setFlipped(tag.m_128471_("slot_pair_mode_1"));
        this.switchManagers[2].setFlipped(tag.m_128471_("slot_pair_mode_2"));
        this.switchManagers[3].setFlipped(tag.m_128471_("slot_pair_mode_3"));
        this.switchManagers[4].setFlipped(tag.m_128471_("slot_pair_mode_4"));
        this.switchManagers[5].setFlipped(tag.m_128471_("slot_pair_mode_5"));
        this.powerIOManager.setFlipped(tag.m_128471_("send_out_power"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128379_("slot_pair_mode_0", this.switchManagers[0].isFlipped());
        tag.m_128379_("slot_pair_mode_1", this.switchManagers[1].isFlipped());
        tag.m_128379_("slot_pair_mode_2", this.switchManagers[2].isFlipped());
        tag.m_128379_("slot_pair_mode_3", this.switchManagers[3].isFlipped());
        tag.m_128379_("slot_pair_mode_4", this.switchManagers[4].isFlipped());
        tag.m_128379_("slot_pair_mode_5", this.switchManagers[5].isFlipped());
        tag.m_128379_("send_out_power", this.powerIOManager.isFlipped());
        super.m_183515_(tag);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.handler.cast();
            }
            if (side.m_122411_() == this.topManager.getDirection().m_122411_() && this.topManager.getStatus()) {
                return this.topIsIngress ? this.topHandler.cast() : this.bottomHandler.cast();
            }
            if (side.m_122411_() == this.bottomManager.getDirection().m_122411_() && this.bottomManager.getStatus()) {
                return this.topIsIngress ? this.bottomHandler.cast() : this.topHandler.cast();
            }
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new BatteryBoxContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public void updateSlotPair(boolean mode, int pairId) {
        this.switchManagers[pairId].setFlipped(mode);
    }

    public void updateSendOutPower(boolean sendOutPower) {
        this.powerIOManager.setFlipped(sendOutPower);
        if (sendOutPower) {
            this.energy.ifPresent(e -> e.setMaxReceive(0));
        } else {
            this.energy.ifPresent(e -> e.setMaxReceive(this.getTransferRate()));
        }
    }

    public VEBatterySwitchManager[] getSwitchManagers() {
        return this.switchManagers;
    }

    public VEPowerIOManager getPowerIOManager() {
        return this.powerIOManager;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.BATTERY_BOX_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return 0;
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.BATTERY_BOX_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return -1;
    }
}

