/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.AqueoulizerContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.recipe.AqueoulizerRecipe;
import com.veteam.voluminousenergy.recipe.VEFluidRecipe;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TagUtil;
import com.veteam.voluminousenergy.util.TankType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class AqueoulizerTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager input0sm = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "input_0_sm");
    public VESlotManager input1sm = new VESlotManager(1, Direction.DOWN, true, "slot.voluminousenergy.output_slot", SlotType.INPUT, "input_1_sm");
    public VESlotManager output0sm = new VESlotManager(2, Direction.NORTH, true, "slot.voluminousenergy.input_slot", SlotType.OUTPUT, "output_0_sm");
    public VESlotManager output1sm = new VESlotManager(3, Direction.SOUTH, true, "slot.voluminousenergy.input_slot", SlotType.INPUT, "output_1_sm");
    private final ItemStackHandler inventory = this.createHandler();
    List<VESlotManager> slotManagers = new ArrayList<VESlotManager>(){
        {
            this.add(AqueoulizerTile.this.input0sm);
            this.add(AqueoulizerTile.this.input1sm);
            this.add(AqueoulizerTile.this.output0sm);
            this.add(AqueoulizerTile.this.output1sm);
        }
    };
    RelationalTank inputTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.INPUT, "inputTank:input_tank_gui");
    RelationalTank outputTank = new RelationalTank(new FluidTank(4000), 1, null, null, TankType.OUTPUT, 0, "outputTank:output_tank_gui");
    List<RelationalTank> fluidManagers = new ArrayList<RelationalTank>(){
        {
            this.add(AqueoulizerTile.this.inputTank);
            this.add(AqueoulizerTile.this.outputTank);
        }
    };

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return this.slotManagers;
    }

    public AqueoulizerTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.AQUEOULIZER_TILE.get(), pos, state);
        this.inputTank.setAllowAny(true);
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack input = this.inventory.getStackInSlot(0).m_41777_();
        ItemStack input1 = this.inventory.getStackInSlot(1).m_41777_();
        ItemStack output0 = this.inventory.getStackInSlot(2).m_41777_();
        ItemStack inputItem = this.inventory.getStackInSlot(3).m_41777_();
        this.inputTank.setInput(input.m_41777_());
        this.inputTank.setOutput(input1.m_41777_());
        this.outputTank.setOutput(output0);
        if (this.inputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.outputFluid(this.inputTank, 0, 1)) {
            return;
        }
        if (this.outputFluidStatic(this.outputTank, 2)) {
            return;
        }
        AqueoulizerRecipe recipe = RecipeUtil.getAqueoulizerRecipe(this.f_58857_, this.inputTank.getTank().getFluid(), inputItem.m_41777_());
        if (this.inputTank != null && !this.inputTank.getTank().isEmpty() && recipe != null) {
            if (((VEFluidRecipe)recipe).getRawFluids().contains(this.inputTank.getTank().getFluid().getRawFluid())) {
                if (this.outputTank != null) {
                    if (this.inputTank.getTank().getFluidAmount() >= ((VEFluidRecipe)recipe).getInputAmount() && this.outputTank.getTank().getFluidAmount() + ((VEFluidRecipe)recipe).getOutputAmount() <= 4000 && (this.outputTank.getTank().isEmpty() || this.outputTank.getTank().getFluid().equals((Object)((VEFluidRecipe)recipe).getOutputFluid()))) {
                        if (this.canConsumeEnergy()) {
                            if (this.counter == 1) {
                                this.inputTank.getTank().drain(((VEFluidRecipe)recipe).getInputAmount(), IFluidHandler.FluidAction.EXECUTE);
                                if (this.outputTank.getTank().getFluid().getRawFluid() != ((VEFluidRecipe)recipe).getOutputFluid().getRawFluid()) {
                                    this.outputTank.getTank().setFluid(((VEFluidRecipe)recipe).getOutputFluid().copy());
                                } else {
                                    this.outputTank.getTank().fill(((VEFluidRecipe)recipe).getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                                }
                                this.inventory.extractItem(3, recipe.ingredientCount, false);
                                --this.counter;
                                this.consumeEnergy();
                                this.m_6596_();
                            } else if (this.counter > 0) {
                                --this.counter;
                                this.consumeEnergy();
                                if (++this.sound_tick == 19) {
                                    this.sound_tick = 0;
                                    if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                                        this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.AQUEOULIZER, SoundSource.BLOCKS, 1.0f, 1.0f);
                                    }
                                }
                            } else {
                                this.length = this.counter = this.calculateCounter(((VEFluidRecipe)recipe).getProcessTime(), this.inventory.getStackInSlot(this.getUpgradeSlotId()).m_41777_());
                            }
                        } else {
                            this.decrementSuperCounterOnNoPower();
                        }
                    } else {
                        this.counter = 0;
                    }
                } else {
                    this.counter = 0;
                }
            } else {
                this.counter = 0;
            }
        } else {
            this.counter = 0;
        }
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    private IFluidHandler createInputFluidHandler() {
        return this.createInputFluidHandler(this.inputTank);
    }

    private IFluidHandler createOutputFluidHandler() {
        return this.createFluidHandler(new AqueoulizerRecipe(), this.outputTank);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                AqueoulizerTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (!(slot != 0 && slot != 1 || stack.m_41720_() instanceof BucketItem)) {
                    return false;
                }
                if (slot == 3) {
                    ArrayList<AqueoulizerRecipe> recipe = RecipeUtil.getAqueoulizerRecipesFromItemInput(AqueoulizerTile.this.f_58857_, stack);
                    return !recipe.isEmpty();
                }
                if (slot == 4) {
                    return TagUtil.isTaggedMachineUpgradeItem(stack);
                }
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public IFluidHandler createInputFluidHandler(final RelationalTank ... relationalTanks) {
        return new IFluidHandler(){

            public int getTanks() {
                return relationalTanks.length;
            }

            @Nonnull
            public FluidStack getFluidInTank(int tank) {
                for (RelationalTank t : relationalTanks) {
                    if (t.getId() != tank) continue;
                    return t.getTank() == null ? FluidStack.EMPTY : t.getTank().getFluid();
                }
                VoluminousEnergy.LOGGER.debug("Invalid tankId in Aqueoulizer Tile for getFluidInTank");
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                for (RelationalTank t : relationalTanks) {
                    if (t.getId() != tank) continue;
                    return t.getTank() == null ? 0 : t.getTank().getCapacity();
                }
                VoluminousEnergy.LOGGER.debug("Invalid tankId in Aqueoulizer Tile for getTankCapacity");
                return 0;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                try {
                    RelationalTank[] relationalTankArray = relationalTanks;
                    int n = relationalTankArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        RelationalTank t = relationalTankArray[n2];
                        if (t.getTankType() == TankType.INPUT) {
                            ArrayList<AqueoulizerRecipe> recipes = RecipeUtil.getAqueoulizerRecipesFromFluidInput(AqueoulizerTile.this.f_58857_, stack);
                            return !recipes.isEmpty() && t.getTank() != null && t.getTank().isFluidValid(stack);
                        }
                        return RecipeUtil.isAqueoulizerOutput(AqueoulizerTile.this.f_58857_, stack) && t.getTank() != null && t.getTank().isFluidValid(stack);
                    }
                }
                catch (Exception e) {
                    VoluminousEnergy.LOGGER.debug("ERROR with isFluidValid in Aqueoulizer Tile input fluid handler");
                }
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                for (RelationalTank t : relationalTanks) {
                    if ((!this.isFluidValid(t.getId(), resource) || !t.getTank().isEmpty()) && !resource.isFluidEqual(t.getTank().getFluid())) continue;
                    return t.getTank().fill(resource, action);
                }
                return 0;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                for (RelationalTank t : relationalTanks) {
                    if (!resource.isFluidEqual(t.getTank().getFluid())) continue;
                    return t.getTank().drain(resource, action);
                }
                return FluidStack.EMPTY;
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                for (RelationalTank t : relationalTanks) {
                    if (t.getTank().getFluidAmount() <= 0) continue;
                    if (((Boolean)Config.ALLOW_EXTRACTION_FROM_INPUT_TANKS.get()).booleanValue()) {
                        return t.getTank().drain(maxDrain, action);
                    }
                    if (t.getTankType() == TankType.INPUT) continue;
                    return t.getTank().drain(maxDrain, action);
                }
                return FluidStack.EMPTY;
            }
        };
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new AqueoulizerContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public int progressCounterPX(int px) {
        if (this.counter != 0 && this.length != 0) {
            return px * (100 - this.counter * 100 / this.length) / 100;
        }
        return 0;
    }

    public int progressCounterPercent() {
        if (this.length != 0) {
            return (int)(100.0f - (float)this.counter / (float)this.length * 100.0f);
        }
        return 0;
    }

    public int ticksLeft() {
        return this.counter;
    }

    public FluidStack getFluidStackFromTank(int num) {
        if (num == 0) {
            return this.inputTank.getTank().getFluid();
        }
        if (num == 1) {
            return this.outputTank.getTank().getFluid();
        }
        return FluidStack.EMPTY;
    }

    public RelationalTank getInputTank() {
        return this.inputTank;
    }

    public RelationalTank getOutputTank() {
        return this.outputTank;
    }

    @Override
    @NotNull
    public List<RelationalTank> getRelationalTanks() {
        return this.fluidManagers;
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.AQUEOULIZER_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.AQUEOULIZER_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.AQUEOULIZER_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 4;
    }
}

