/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.tiles;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.AirCompressorContainer;
import com.veteam.voluminousenergy.blocks.tiles.IVECountable;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.blocks.tiles.VEFluidTileEntity;
import com.veteam.voluminousenergy.fluids.VEFluids;
import com.veteam.voluminousenergy.sounds.VESounds;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.sidemanager.VESlotManager;
import com.veteam.voluminousenergy.util.RelationalTank;
import com.veteam.voluminousenergy.util.SlotType;
import com.veteam.voluminousenergy.util.TankType;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class AirCompressorTile
extends VEFluidTileEntity
implements IVEPoweredTileEntity,
IVECountable {
    public VESlotManager outputSlotManager = new VESlotManager(0, Direction.UP, true, "slot.voluminousenergy.output_slot", SlotType.OUTPUT, "output_slot");
    private final int TANK_CAPACITY = 4000;
    private final ItemStackHandler inventory = this.createHandler(2, this);
    private final RelationalTank airTank = new RelationalTank(new FluidTank(4000), 0, null, null, TankType.OUTPUT, "air_tank:air_tank_properties");

    public AirCompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)VEBlocks.AIR_COMPRESSOR_TILE.get(), pos, state);
        this.airTank.setValidFluids(Collections.singletonList((Fluid)VEFluids.COMPRESSED_AIR_REG.get()));
    }

    @Override
    public void tick() {
        this.updateClients();
        ItemStack slotStack = this.inventory.getStackInSlot(0).m_41777_();
        if (slotStack.m_41777_() != ItemStack.f_41583_ && slotStack.m_41720_() == Items.f_42446_ && this.airTank.getTank().getFluidAmount() >= 1000 && slotStack.m_41613_() == 1) {
            ItemStack bucketStack = new ItemStack((ItemLike)this.airTank.getTank().getFluid().getRawFluid().m_6859_(), 1);
            this.airTank.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            this.inventory.extractItem(0, 1, false);
            this.inventory.insertItem(0, bucketStack, false);
        }
        if (this.airTank != null && this.airTank.getTank().getFluidAmount() + 250 <= 4000 && this.counter == 0 && this.canConsumeEnergy()) {
            int z;
            int y;
            int x = this.f_58858_.m_123341_();
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x, y = this.f_58858_.m_123342_(), z = this.f_58858_.m_123343_())).m_60734_()) {
                this.addAirToTank();
            }
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x + 1, y, z)).m_60734_()) {
                this.addAirToTank();
            }
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x - 1, y, z)).m_60734_()) {
                this.addAirToTank();
            }
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x, y + 1, z)).m_60734_()) {
                this.addAirToTank();
            }
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x, y - 1, z)).m_60734_()) {
                this.addAirToTank();
            }
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x, y, z + 1)).m_60734_()) {
                this.addAirToTank();
            }
            if (Blocks.f_50016_ == this.f_58857_.m_8055_(new BlockPos(x, y, z - 1)).m_60734_()) {
                this.addAirToTank();
            }
        } else if (this.airTank.getTank() != null && this.airTank.getTank().getFluidAmount() + 250 <= 4000 && this.canConsumeEnergy()) {
            this.consumeEnergy();
            if (++this.sound_tick == 19) {
                this.sound_tick = 0;
                if (((Boolean)Config.PLAY_MACHINE_SOUNDS.get()).booleanValue()) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), VESounds.AIR_COMPRESSOR, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            }
        }
        this.counter = this.counter == 0 ? (int)((byte)this.calculateCounter(20, this.inventory.getStackInSlot(this.getUpgradeSlotId()))) : --this.counter;
    }

    public void addAirToTank() {
        if (this.airTank.getTank().getFluidAmount() + 250 <= 4000) {
            this.airTank.getTank().fill(new FluidStack((Fluid)VEFluids.COMPRESSED_AIR_REG.get(), 250), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int i, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        return new AirCompressorContainer(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public FluidStack getAirTankFluid() {
        return this.airTank.getTank().getFluid();
    }

    @Override
    public int getTankCapacity() {
        return 4000;
    }

    @Override
    @Nonnull
    public List<RelationalTank> getRelationalTanks() {
        return Collections.singletonList(this.airTank);
    }

    public RelationalTank getAirTank() {
        return this.airTank;
    }

    @Override
    @Nonnull
    public ItemStackHandler getInventoryHandler() {
        return this.inventory;
    }

    @Override
    @Nonnull
    public List<VESlotManager> getSlotManagers() {
        return Collections.singletonList(this.outputSlotManager);
    }

    @Override
    public int getMaxPower() {
        return (Integer)Config.AIR_COMPRESSOR_MAX_POWER.get();
    }

    @Override
    public int getPowerUsage() {
        return (Integer)Config.AIR_COMPRESSOR_POWER_USAGE.get();
    }

    @Override
    public int getTransferRate() {
        return (Integer)Config.AIR_COMPRESSOR_TRANSFER.get();
    }

    @Override
    public int getUpgradeSlotId() {
        return 1;
    }
}

