/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.screens.tank;

import com.mojang.blaze3d.systems.RenderSystem;
import com.veteam.voluminousenergy.blocks.containers.tank.TankContainer;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.blocks.tiles.tank.TankTile;
import com.veteam.voluminousenergy.tools.VERender;
import com.veteam.voluminousenergy.tools.buttons.ioMenuButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotBoolButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotDirectionButton;
import com.veteam.voluminousenergy.tools.buttons.tanks.TankBoolButton;
import com.veteam.voluminousenergy.tools.buttons.tanks.TankDirectionButton;
import com.veteam.voluminousenergy.tools.networking.VENetwork;
import com.veteam.voluminousenergy.tools.networking.packets.UuidPacket;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankScreen
extends VEContainerScreen<TankContainer> {
    private TankTile tileEntity;
    private final ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/tank_gui.png");
    private static final ResourceLocation GUI_TOOLS = new ResourceLocation("voluminousenergy", "textures/gui/guitools.png");

    public TankScreen(TankContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.tileEntity = (TankTile)screenContainer.getTileEntity();
        screenContainer.setScreen(this);
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrixStack);
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ioMenuButton(64 + this.f_96543_ / 2, this.f_97736_ + 4, buttons -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.bucketTopSlotManager, this.f_96543_ / 2 - 198, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.bucketTopSlotManager, this.f_96543_ / 2 - 184, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.bucketBottomSlotManager, this.f_96543_ / 2 - 198, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.bucketBottomSlotManager, this.f_96543_ / 2 - 184, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new TankBoolButton(this.tileEntity.getTank(), this.f_96543_ / 2 - 198, this.f_97736_ + 40, button -> {}));
        this.m_142416_((GuiEventListener)new TankDirectionButton(this.tileEntity.getTank(), this.f_96543_ / 2 - 184, this.f_97736_ + 40, button -> {}));
    }

    @Override
    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateString("container.inventory"), 8, this.f_97727_ - 96 + 2, WHITE_TEXT_STYLE);
        super.m_280003_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void renderSlotAndTankLabels(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 70, 19, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 70, 50, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.tank_short").m_6881_().m_130946_("0"), 93, 18, WHITE_TEXT_STYLE);
    }

    protected void m_280072_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        if (this.m_6774_(93, 18, 12, 50, mouseX, mouseY)) {
            int amount = this.tileEntity.getTank().getTank().getFluid().getAmount();
            String name = this.tileEntity.getTank().getTank().getFluid().getTranslationKey();
            matrixStack.m_280557_(this.f_96547_, TextUtil.tankTooltip(name, amount, this.tileEntity.getTankCapacity()), mouseX, mouseY);
        }
        super.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(this.GUI, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.tileEntity != null) {
            try {
                VERender.renderGuiTank(this.tileEntity.m_58904_(), this.tileEntity.m_58899_(), (IFluidHandler)this.tileEntity.getTank().getTank(), this.tileEntity.getTankCapacity(), (double)(i + 93), (double)(j + 18), 0.0, 12.0, 50.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TOOLS);
            this.drawIOSideHelper();
        }
    }

    @Override
    public void updateButtonDirection(int direction, int slotId) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof SlotDirectionButton) || ((SlotDirectionButton)Renderable2).getAssociatedSlotId() != slotId) continue;
            ((SlotDirectionButton)Renderable2).setDirectionFromInt(direction);
        }
    }

    @Override
    public void updateBooleanButton(boolean status, int slotId) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof SlotBoolButton) || ((SlotBoolButton)Renderable2).getAssociatedSlotId() != slotId) continue;
            ((SlotBoolButton)Renderable2).toggleRender(true);
            ((SlotBoolButton)Renderable2).setStatus(status);
            ((SlotBoolButton)Renderable2).toggleRender(false);
        }
    }

    @Override
    public void updateTankDirection(int direction, int id) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof TankDirectionButton) || ((TankDirectionButton)Renderable2).getId() != id) continue;
            ((TankDirectionButton)Renderable2).setDirectionFromInt(direction);
        }
    }

    @Override
    public void updateTankStatus(boolean status, int id) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof TankBoolButton) || ((TankBoolButton)Renderable2).getId() != id) continue;
            ((TankBoolButton)Renderable2).toggleRender(true);
            ((TankBoolButton)Renderable2).setStatus(status);
            ((TankBoolButton)Renderable2).toggleRender(false);
        }
    }

    @Override
    public void informTileOfIOButton(boolean connection) {
        UUID uuid = Minecraft.m_91087_().f_91074_.m_20148_();
        if (uuid != null) {
            VENetwork.channel.sendToServer((Object)new UuidPacket(uuid, connection));
        }
    }
}

