/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.screens;

import com.veteam.voluminousenergy.tools.buttons.VEIOButton;
import com.veteam.voluminousenergy.tools.buttons.ioMenuButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotBoolButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotDirectionButton;
import com.veteam.voluminousenergy.tools.buttons.tanks.TankBoolButton;
import com.veteam.voluminousenergy.tools.buttons.tanks.TankDirectionButton;
import com.veteam.voluminousenergy.tools.networking.VENetwork;
import com.veteam.voluminousenergy.tools.networking.packets.UuidPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class VEContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public static final int WHITE_TEXT_COLOUR = 0xFFFFFF;
    public static final int GREY_TEXT_COLOUR = 0x606060;
    public static final Style WHITE_TEXT_STYLE = Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(0xFFFFFF);
    public static final Style GREY_TEXT_STYLE = Style.f_131099_.m_131150_(Style.f_131100_).m_178520_(0x606060);

    public VEContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        this.f_169369_.stream().filter(Renderable2 -> Renderable2 instanceof ioMenuButton).forEach(button -> {
            if (((ioMenuButton)((Object)button)).shouldIOBeOpen()) {
                this.renderSlotAndTankLabels(matrixStack, mouseX, mouseY);
            }
        });
    }

    protected abstract void renderSlotAndTankLabels(GuiGraphics var1, int var2, int var3);

    public void drawIOSideHelper() {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof ioMenuButton)) continue;
            if (((ioMenuButton)Renderable2).shouldIOBeOpen()) {
                this.f_169369_.forEach(button -> {
                    if (button instanceof VEIOButton) {
                        ((VEIOButton)((Object)button)).toggleRender(true);
                    }
                });
                continue;
            }
            this.f_169369_.forEach(button -> {
                if (button instanceof VEIOButton) {
                    ((VEIOButton)((Object)button)).toggleRender(false);
                }
            });
        }
    }

    public void updateButtonDirection(int direction, int slotId) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof SlotDirectionButton) || ((SlotDirectionButton)Renderable2).getAssociatedSlotId() != slotId) continue;
            ((SlotDirectionButton)Renderable2).setDirectionFromInt(direction);
        }
    }

    public void updateBooleanButton(boolean status, int slotId) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof SlotBoolButton) || ((SlotBoolButton)Renderable2).getAssociatedSlotId() != slotId) continue;
            ((SlotBoolButton)Renderable2).toggleRender(true);
            ((SlotBoolButton)Renderable2).setStatus(status);
            ((SlotBoolButton)Renderable2).toggleRender(false);
        }
    }

    public void updateTankDirection(int direction, int id) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof TankDirectionButton) || ((TankDirectionButton)Renderable2).getId() != id) continue;
            ((TankDirectionButton)Renderable2).setDirectionFromInt(direction);
        }
    }

    public void updateTankStatus(boolean status, int id) {
        for (Renderable Renderable2 : this.f_169369_) {
            if (!(Renderable2 instanceof TankBoolButton) || ((TankBoolButton)Renderable2).getId() != id) continue;
            ((TankBoolButton)Renderable2).toggleRender(true);
            ((TankBoolButton)Renderable2).setStatus(status);
            ((TankBoolButton)Renderable2).toggleRender(false);
        }
    }

    public void informTileOfIOButton(boolean connection) {
        UUID uuid = Minecraft.m_91087_().f_91074_.m_20148_();
        VENetwork.channel.sendToServer((Object)new UuidPacket(uuid, connection));
    }

    protected boolean isHovering(Rect2i rect, double x, double y) {
        return this.m_6774_(rect.m_110085_(), rect.m_110086_(), rect.m_110090_(), rect.m_110091_(), x, y);
    }
}

