/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.containers.CrusherContainer;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.blocks.tiles.CrusherTile;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.buttons.ioMenuButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotBoolButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotDirectionButton;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CrusherScreen
extends VEContainerScreen<CrusherContainer> {
    private final CrusherTile tileEntity;
    private static final ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/crushergui.png");
    private static final ResourceLocation GUI_TOOLS = new ResourceLocation("voluminousenergy", "textures/gui/guitools.png");

    public CrusherScreen(CrusherContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.tileEntity = (CrusherTile)screenContainer.getTileEntity();
        screenContainer.setScreen(this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ioMenuButton(64 + this.f_96543_ / 2, this.f_97736_ + 4, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.inputSlotProp, this.f_96543_ / 2 - 198, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.inputSlotProp, this.f_96543_ / 2 - 184, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.outputSlotProp, this.f_96543_ / 2 - 198, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.outputSlotProp, this.f_96543_ / 2 - 184, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.rngSlotProp, this.f_96543_ / 2 - 198, this.f_97736_ + 40, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.rngSlotProp, this.f_96543_ / 2 - 184, this.f_97736_ + 40, button -> {}));
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrixStack);
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateVEBlock("crusher"), 8, 6, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateString("container.inventory"), 8, this.f_97727_ - 96 + 2, WHITE_TEXT_STYLE);
        super.m_280003_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void renderSlotAndTankLabels(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 80, 13, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 71, 58, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("2"), 89, 58, WHITE_TEXT_STYLE);
    }

    protected void m_280072_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        if (this.m_6774_(11, 16, 12, 49, mouseX, mouseY)) {
            this.tileEntity.getEnergy().ifPresent(veEnergyStorage -> matrixStack.m_280557_(this.f_96547_, TextUtil.powerBarTooltip(veEnergyStorage, (Integer)Config.CRUSHER_MAX_POWER.get()), mouseX, mouseY));
        } else if (!VoluminousEnergy.JEI_LOADED && this.isHovering(this.getTooltipArea(), mouseX, mouseY)) {
            matrixStack.m_280666_(this.f_96547_, this.getTooltips(), mouseX, mouseY);
        }
        super.m_280072_(matrixStack, mouseX, mouseY);
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(79, 31, 17, 24);
    }

    public List<Component> getTooltips() {
        return Arrays.asList(Component.m_130674_((String)(TextUtil.translateString("text.voluminousenergy.percent_complete").getString() + ": " + this.tileEntity.progressCounterPercent() + "%")), Component.m_130674_((String)(TextUtil.translateString("text.voluminousenergy.ticks_left").getString() + ": " + this.tileEntity.ticksLeft())));
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(GUI, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.tileEntity != null) {
            int progress = this.tileEntity.progressCounterPX(24);
            int power = ((CrusherContainer)this.f_97732_).powerScreen(49);
            matrixStack.m_280218_(GUI, i + 79, j + 31, 176, 0, 17, progress);
            matrixStack.m_280218_(GUI, i + 11, j + (16 + (49 - power)), 176, 24 + (49 - power), 12, power);
            this.drawIOSideHelper();
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TOOLS);
        matrixStack.m_280218_(GUI_TOOLS, i + 153, j - 16, 0, 0, 18, 18);
    }

    public static ResourceLocation getGUI() {
        return GUI;
    }
}

