/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.containers.CombustionGeneratorContainer;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.blocks.tiles.CombustionGeneratorTile;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.VERender;
import com.veteam.voluminousenergy.tools.buttons.ioMenuButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotBoolButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotDirectionButton;
import com.veteam.voluminousenergy.tools.buttons.tanks.TankBoolButton;
import com.veteam.voluminousenergy.tools.buttons.tanks.TankDirectionButton;
import com.veteam.voluminousenergy.util.TextUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CombustionGeneratorScreen
extends VEContainerScreen<CombustionGeneratorContainer> {
    private CombustionGeneratorTile tileEntity;
    private final ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/combustion_generator_gui.png");
    private static final ResourceLocation GUI_TOOLS = new ResourceLocation("voluminousenergy", "textures/gui/guitools.png");

    public CombustionGeneratorScreen(CombustionGeneratorContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.tileEntity = (CombustionGeneratorTile)screenContainer.getTileEntity();
        screenContainer.setScreen(this);
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrixStack);
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ioMenuButton(64 + this.f_96543_ / 2, this.f_97736_ - 18, buttons -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.oxiInSm, this.f_96543_ / 2 - 198, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.oxiInSm, this.f_96543_ / 2 - 184, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.oxiOutSm, this.f_96543_ / 2 - 198, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.oxiOutSm, this.f_96543_ / 2 - 184, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.fuelInSm, this.f_96543_ / 2 - 198, this.f_97736_ + 40, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.fuelInSm, this.f_96543_ / 2 - 184, this.f_97736_ + 40, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.fuelOutSm, this.f_96543_ / 2 - 198, this.f_97736_ + 60, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.fuelOutSm, this.f_96543_ / 2 - 184, this.f_97736_ + 60, button -> {}));
        this.m_142416_((GuiEventListener)new TankBoolButton(this.tileEntity.getOxidizerTank(), this.f_96543_ / 2 - 198, this.f_97736_ + 80, button -> {}));
        this.m_142416_((GuiEventListener)new TankDirectionButton(this.tileEntity.getOxidizerTank(), this.f_96543_ / 2 - 184, this.f_97736_ + 80, button -> {}));
        this.m_142416_((GuiEventListener)new TankBoolButton(this.tileEntity.getFuelTank(), this.f_96543_ / 2 - 198, this.f_97736_ + 100, button -> {}));
        this.m_142416_((GuiEventListener)new TankDirectionButton(this.tileEntity.getFuelTank(), this.f_96543_ / 2 - 184, this.f_97736_ + 100, button -> {}));
    }

    @Override
    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateVEBlock("combustion_generator"), 8, 6, WHITE_TEXT_STYLE);
        if (this.tileEntity.getEnergyRate() < 10) {
            TextUtil.renderShadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(this.tileEntity.getEnergyRate() + " FE/t")), 80, 18, WHITE_TEXT_STYLE);
        } else if (this.tileEntity.getEnergyRate() < 100) {
            TextUtil.renderShadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(this.tileEntity.getEnergyRate() + " FE/t")), 77, 18, WHITE_TEXT_STYLE);
        } else {
            TextUtil.renderShadowedText(matrixStack, Minecraft.m_91087_().f_91062_, Component.m_130674_((String)(this.tileEntity.getEnergyRate() + " FE/t")), 75, 18, WHITE_TEXT_STYLE);
        }
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateString("container.inventory"), 8, this.f_97727_ - 96 + 2, WHITE_TEXT_STYLE);
        super.m_280003_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void renderSlotAndTankLabels(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 38, 18, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 38, 49, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("2"), 138, 18, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("3"), 138, 49, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.tank_short").m_6881_().m_130946_("0"), 61, 18, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.tank_short").m_6881_().m_130946_("1"), 119, 18, WHITE_TEXT_STYLE);
    }

    protected void m_280072_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        int amount;
        String name;
        if (this.m_6774_(11, 16, 12, 49, mouseX, mouseY)) {
            this.tileEntity.getEnergy().ifPresent(veEnergyStorage -> matrixStack.m_280557_(this.f_96547_, TextUtil.powerBarTooltip(veEnergyStorage, (Integer)Config.COMBUSTION_GENERATOR_MAX_POWER.get()), mouseX, mouseY));
        }
        if (this.m_6774_(61, 18, 12, 50, mouseX, mouseY)) {
            name = this.tileEntity.getFluidStackFromTank(0).getTranslationKey();
            amount = this.tileEntity.getFluidStackFromTank(0).getAmount();
            matrixStack.m_280557_(this.f_96547_, TextUtil.tankTooltip(name, amount, this.tileEntity.getTankCapacity()), mouseX, mouseY);
        }
        if (this.m_6774_(119, 18, 12, 50, mouseX, mouseY)) {
            name = this.tileEntity.getFluidStackFromTank(1).getTranslationKey();
            amount = this.tileEntity.getFluidStackFromTank(1).getAmount();
            matrixStack.m_280557_(this.f_96547_, TextUtil.tankTooltip(name, amount, this.tileEntity.getTankCapacity()), mouseX, mouseY);
        }
        if (!VoluminousEnergy.JEI_LOADED && this.isHovering(this.getTooltipArea(), mouseX, mouseY)) {
            matrixStack.m_280666_(this.f_96547_, this.getTooltips(), mouseX, mouseY);
        }
        super.m_280072_(matrixStack, mouseX, mouseY);
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(89, 36, 14, 14);
    }

    public List<Component> getTooltips() {
        return Arrays.asList(Component.m_130674_((String)(TextUtil.translateString("text.voluminousenergy.percent_burned").getString() + ": " + this.tileEntity.progressCounterPercent() + "%")), Component.m_130674_((String)(TextUtil.translateString("text.voluminousenergy.ticks_left").getString() + ": " + this.tileEntity.ticksLeft())), Component.m_130674_((String)(TextUtil.translateString("text.voluminousenergy.generating").getString() + ": " + this.tileEntity.getEnergyRate() + " FE/t")));
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(this.GUI, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.tileEntity != null) {
            int progress = this.tileEntity.progressCounterPX(14);
            int power = ((CombustionGeneratorContainer)this.f_97732_).powerScreen(49);
            matrixStack.m_280218_(this.GUI, i + 89, j + (36 + (14 - progress)), 176, 14 - progress, 14, progress);
            matrixStack.m_280218_(this.GUI, i + 11, j + (16 + (49 - power)), 176, 24 + (49 - power), 12, power);
            try {
                VERender.renderGuiTank(this.tileEntity.m_58904_(), this.tileEntity.m_58899_(), this.tileEntity.getFluidStackFromTank(0), this.tileEntity.getTankCapacity(), (double)(i + 61), (double)(j + 18), 0.0, 12.0, 50.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                VERender.renderGuiTank(this.tileEntity.m_58904_(), this.tileEntity.m_58899_(), this.tileEntity.getFluidStackFromTank(1), this.tileEntity.getTankCapacity(), (double)(i + 119), (double)(j + 18), 0.0, 12.0, 50.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TOOLS);
            this.drawIOSideHelper();
        }
    }
}

