/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.veteam.voluminousenergy.blocks.containers.BatteryBoxContainer;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.blocks.tiles.BatteryBoxTile;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.buttons.VEPowerIOManager;
import com.veteam.voluminousenergy.tools.buttons.batteryBox.BatteryBoxSendOutPowerButton;
import com.veteam.voluminousenergy.tools.buttons.batteryBox.BatteryBoxSlotPairButton;
import com.veteam.voluminousenergy.tools.buttons.batteryBox.VEBatterySwitchManager;
import com.veteam.voluminousenergy.tools.buttons.ioMenuButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotBoolButton;
import com.veteam.voluminousenergy.tools.buttons.slots.SlotDirectionButton;
import com.veteam.voluminousenergy.util.TextUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BatteryBoxScreen
extends VEContainerScreen<BatteryBoxContainer> {
    private final BatteryBoxTile tileEntity;
    private final ResourceLocation GUI = new ResourceLocation("voluminousenergy", "textures/gui/battery_box_gui.png");
    private static final ResourceLocation GUI_TOOLS = new ResourceLocation("voluminousenergy", "textures/gui/guitools.png");

    public BatteryBoxScreen(BatteryBoxContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.tileEntity = (BatteryBoxTile)screenContainer.getTileEntity();
        screenContainer.setScreen(this);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ioMenuButton(64 + this.f_96543_ / 2, this.f_97736_ + 4, buttons -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.topManager, this.f_96543_ / 2 - 198, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.topManager, this.f_96543_ / 2 - 184, this.f_97736_, button -> {}));
        this.m_142416_((GuiEventListener)new SlotBoolButton(this.tileEntity.bottomManager, this.f_96543_ / 2 - 198, this.f_97736_ + 20, button -> {}));
        this.m_142416_((GuiEventListener)new SlotDirectionButton(this.tileEntity.bottomManager, this.f_96543_ / 2 - 184, this.f_97736_ + 20, button -> {}));
        VEBatterySwitchManager[] switchManagers = this.tileEntity.getSwitchManagers();
        VEPowerIOManager vePowerIOManager = this.tileEntity.getPowerIOManager();
        this.m_142416_((GuiEventListener)new BatteryBoxSlotPairButton(switchManagers[0], this.f_96543_ / 2 - 54, this.f_97736_ + 34, 0, button -> {}));
        this.m_142416_((GuiEventListener)new BatteryBoxSlotPairButton(switchManagers[1], this.f_96543_ / 2 - 36, this.f_97736_ + 34, 1, button -> {}));
        this.m_142416_((GuiEventListener)new BatteryBoxSlotPairButton(switchManagers[2], this.f_96543_ / 2 - 18, this.f_97736_ + 34, 2, button -> {}));
        this.m_142416_((GuiEventListener)new BatteryBoxSlotPairButton(switchManagers[3], this.f_96543_ / 2, this.f_97736_ + 34, 3, button -> {}));
        this.m_142416_((GuiEventListener)new BatteryBoxSlotPairButton(switchManagers[4], this.f_96543_ / 2 + 18, this.f_97736_ + 34, 4, button -> {}));
        this.m_142416_((GuiEventListener)new BatteryBoxSlotPairButton(switchManagers[5], this.f_96543_ / 2 + 36, this.f_97736_ + 34, 5, button -> {}));
        this.m_142416_((GuiEventListener)new BatteryBoxSendOutPowerButton(vePowerIOManager, this.f_96543_ / 2 - 79, this.f_97736_ + 3, this.tileEntity, button -> {}));
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(matrixStack);
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_280072_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void m_280003_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateVEBlock("battery_box"), 34, 6, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, TextUtil.translateString("container.inventory"), 8, this.f_97726_ - 96 - 8, WHITE_TEXT_STYLE);
        super.m_280003_(matrixStack, mouseX, mouseY);
    }

    @Override
    protected void renderSlotAndTankLabels(GuiGraphics matrixStack, int mouseX, int mouseY) {
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 35, 17, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 53, 17, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 71, 17, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 89, 17, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 107, 17, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("0"), 125, 17, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 35, 54, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 53, 54, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 71, 54, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 89, 54, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 107, 54, WHITE_TEXT_STYLE);
        TextUtil.renderShadowedText(matrixStack, this.f_96547_, (Component)TextUtil.translateString("gui.voluminousenergy.slot_short").m_6881_().m_130946_("1"), 125, 54, WHITE_TEXT_STYLE);
    }

    protected void m_280072_(GuiGraphics matrixStack, int mouseX, int mouseY) {
        if (this.m_6774_(11, 16, 12, 49, mouseX, mouseY)) {
            this.tileEntity.getEnergy().ifPresent(veEnergyStorage -> matrixStack.m_280557_(this.f_96547_, TextUtil.powerBarTooltip(veEnergyStorage, (Integer)Config.BATTERY_BOX_MAX_POWER.get()), mouseX, mouseY));
        }
        if (this.m_6774_(10, 4, 15, 10, mouseX, mouseY)) {
            if (this.tileEntity.getPowerIOManager().isFlipped()) {
                matrixStack.m_280557_(this.f_96547_, TextUtil.translateString("text.voluminousenergy.battery_box.sending_out_power"), mouseX, mouseY);
            } else {
                matrixStack.m_280557_(this.f_96547_, TextUtil.translateString("text.voluminousenergy.battery_box.receiving_power"), mouseX, mouseY);
            }
        }
        super.m_280072_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(this.GUI, i, j, 0, 0, this.f_97726_, this.f_97727_);
        if (this.tileEntity != null) {
            int power = ((BatteryBoxContainer)this.f_97732_).powerScreen(49);
            matrixStack.m_280218_(this.GUI, i + 11, j + (16 + (49 - power)), 176, 24 + (49 - power), 12, power);
            this.drawIOSideHelper();
            for (VEBatterySwitchManager switchManager : this.tileEntity.getSwitchManagers()) {
                this.updateSlotPairButton(switchManager.isFlipped(), switchManager.getSlot());
            }
            this.updateSendOutPowerButton(this.tileEntity.getPowerIOManager().isFlipped());
        }
    }

    public void updateSlotPairButton(boolean status, int id) {
        for (Renderable widget : this.f_169369_) {
            BatteryBoxSlotPairButton batteryBoxSlotPairButton;
            if (!(widget instanceof BatteryBoxSlotPairButton) || (batteryBoxSlotPairButton = (BatteryBoxSlotPairButton)widget).getId() != id) continue;
            batteryBoxSlotPairButton.setStatus(status);
        }
    }

    public void updateSendOutPowerButton(boolean status) {
        for (Renderable widget : this.f_169369_) {
            if (!(widget instanceof BatteryBoxSendOutPowerButton)) continue;
            BatteryBoxSendOutPowerButton batteryBoxSendOutPowerButton = (BatteryBoxSendOutPowerButton)widget;
            batteryBoxSendOutPowerButton.setStatus(status);
        }
    }
}

