/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.containers;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import com.veteam.voluminousenergy.blocks.tiles.IVEPoweredTileEntity;
import com.veteam.voluminousenergy.util.RegistryLookups;
import com.veteam.voluminousenergy.util.TagUtil;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class VoluminousContainer
extends AbstractContainerMenu {
    BlockEntity tileEntity;
    Player playerEntity;
    IItemHandler playerInventory;
    VEContainerScreen<?> screen;

    protected VoluminousContainer(@Nullable MenuType<?> p_i50105_1_, int p_i50105_2_) {
        super(p_i50105_1_, p_i50105_2_);
    }

    public boolean m_6875_(Player p_75145_1_) {
        return false;
    }

    public BlockEntity getTileEntity() {
        return this.tileEntity;
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    public int getEnergy() {
        return this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int powerScreen(int px) {
        int stored = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        int max = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
        int ret = stored * 100 / max * 100 / 100 * px / 100;
        return ret;
    }

    public ItemStack handleCoreQuickMoveStackLogicWithUpgradeSlot(int index, int containerSlots, int upgradeSlotId, ItemStack slotStack) {
        if (index < containerSlots) {
            if (!this.m_38903_(slotStack, containerSlots, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (TagUtil.isTaggedMachineUpgradeItem(slotStack) && !this.m_38903_(slotStack, upgradeSlotId, upgradeSlotId + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (!TagUtil.isTaggedMachineUpgradeItem(slotStack) && !this.m_38903_(slotStack, 0, upgradeSlotId, false)) {
                return ItemStack.f_41583_;
            }
        }
        return null;
    }

    public ItemStack handleCoreQuickMoveStackLogic(int index, int containerSlots, ItemStack slotStack) {
        if (index < containerSlots ? !this.m_38903_(slotStack, containerSlots, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, containerSlots, false)) {
            return ItemStack.f_41583_;
        }
        return null;
    }

    public void setTileEntity(BlockEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void setScreen(VEContainerScreen screen) {
        this.screen = screen;
    }

    public void updateDirectionButton(int direction, int slotId) {
        this.screen.updateButtonDirection(direction, slotId);
    }

    public void updateStatusButton(boolean status, int slotId) {
        this.screen.updateBooleanButton(status, slotId);
    }

    public void updateStatusTank(boolean status, int id) {
        this.screen.updateTankStatus(status, id);
    }

    public void updateDirectionTank(int direction, int id) {
        this.screen.updateTankDirection(direction, id);
    }

    public int getUpgradeSlotId() {
        if (this.tileEntity instanceof IVEPoweredTileEntity) {
            return ((IVEPoweredTileEntity)this.tileEntity).getUpgradeSlotId();
        }
        VoluminousEnergy.LOGGER.error("A container called getUpgradeSlotId when tile doesn't support upgrade slots! Offending tile is: " + RegistryLookups.getBlockEntityTypeKey(this.tileEntity.m_58903_()));
        return 0;
    }
}

