/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.containers;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.VoluminousContainer;
import com.veteam.voluminousenergy.blocks.inventory.slots.VEBucketSlot;
import com.veteam.voluminousenergy.blocks.inventory.slots.VEInsertSlot;
import com.veteam.voluminousenergy.items.tools.multitool.CombustionMultitool;
import com.veteam.voluminousenergy.items.tools.multitool.VEMultitools;
import com.veteam.voluminousenergy.items.tools.multitool.bits.BitItem;
import com.veteam.voluminousenergy.tools.energy.VEEnergyStorage;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.RegistryLookups;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ToolingStationContainer
extends VoluminousContainer {
    public static final int NUMBER_OF_SLOTS = 6;

    public ToolingStationContainer(int id, Level world, BlockPos pos, Inventory inventory, Player player) {
        super((MenuType)VEBlocks.TOOLING_STATION_CONTAINER.get(), id);
        this.tileEntity = world.m_7702_(pos);
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)inventory);
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.m_38897_((Slot)new VEBucketSlot((IItemHandler)h, 0, 38, 18));
            this.m_38897_((Slot)new VEBucketSlot((IItemHandler)h, 1, 38, 49));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 2, 86, 32));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 3, 134, 18));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 4, 134, 49));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 5, 154, -14));
        });
        this.layoutPlayerInventorySlots(8, 84);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ToolingStationContainer.this.getEnergy();
            }

            public void m_6422_(int value) {
                ToolingStationContainer.this.tileEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(h -> ((VEEnergyStorage)((Object)h)).setEnergy(value));
            }
        });
    }

    @Override
    public int getEnergy() {
        return this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    @Override
    public int powerScreen(int px) {
        int stored = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        int max = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
        int ret = stored * 100 / max * 100 / 100 * px / 100;
        return ret;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return ToolingStationContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tileEntity.m_58904_(), (BlockPos)this.tileEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)VEBlocks.TOOLING_STATION_BLOCK.get()));
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (this.handleCoreQuickMoveStackLogic(index, 6, slotStack) != null) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == returnStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return returnStack;
    }

    @Override
    public ItemStack handleCoreQuickMoveStackLogic(int index, int containerSlots, ItemStack slotStack) {
        if (index < containerSlots) {
            if (!this.m_38903_(slotStack, containerSlots, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (slotStack.m_41720_() instanceof CombustionMultitool && (((CombustionMultitool)slotStack.m_41720_()).getBit() == null || slotStack.m_41720_() == VEMultitools.EMPTY_MULTITOOL.get() ? !((Slot)this.f_38839_.get(2)).m_6657_() && !((Slot)this.f_38839_.get(4)).m_6657_() && !this.m_38903_(slotStack, 4, 5, false) : !((Slot)this.f_38839_.get(3)).m_6657_() && !((Slot)this.f_38839_.get(4)).m_6657_() && !this.m_38903_(slotStack, 2, 3, false))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41720_() instanceof BitItem && !((Slot)this.f_38839_.get(2)).m_6657_() && !((Slot)this.f_38839_.get(3)).m_6657_() && !this.m_38903_(slotStack, 3, 4, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41720_() instanceof BucketItem) {
                if (slotStack.m_41720_().equals(Items.f_42446_)) {
                    return !this.m_38903_(slotStack, 0, 1, false) ? ItemStack.f_41583_ : null;
                }
                try {
                    Fluid slotFluid = ((BucketItem)slotStack.m_41720_()).getFluid();
                    if (RecipeUtil.isCombustibleFuel(slotFluid, this.tileEntity.m_58904_()) && !this.m_38903_(slotStack, 0, 1, false)) {
                        return ItemStack.f_41583_;
                    }
                }
                catch (Exception e) {
                    VoluminousEnergy.LOGGER.error("Item: " + RegistryLookups.lookupItem(slotStack) + " Appears to be a bucket, this error is likely caused by it not containing a fluid. This may be a modded bucket that extends BucketItem, but contains no fluid. If not, here's the stacktrace: ");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

