/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.containers;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.VoluminousContainer;
import com.veteam.voluminousenergy.blocks.inventory.slots.VEBucketSlot;
import com.veteam.voluminousenergy.blocks.inventory.slots.VEInsertSlot;
import com.veteam.voluminousenergy.tools.energy.VEEnergyStorage;
import com.veteam.voluminousenergy.util.RecipeUtil;
import com.veteam.voluminousenergy.util.TagUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class HydroponicIncubatorContainer
extends VoluminousContainer {
    public static final int NUMBER_OF_SLOTS = 8;

    public HydroponicIncubatorContainer(int id, Level world, BlockPos pos, Inventory inventory, Player player) {
        super((MenuType)VEBlocks.HYDROPONIC_INCUBATOR_CONTAINER.get(), id);
        this.tileEntity = world.m_7702_(pos);
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)inventory);
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.m_38897_((Slot)new VEBucketSlot((IItemHandler)h, 0, 38, 18));
            this.m_38897_((Slot)new VEBucketSlot((IItemHandler)h, 1, 38, 49));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 2, 83, 34));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 3, 123, 8));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 4, 123, 26));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 5, 123, 44));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 6, 123, 62));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 7, 154, -14));
        });
        this.layoutPlayerInventorySlots(8, 84);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return HydroponicIncubatorContainer.this.getEnergy();
            }

            public void m_6422_(int value) {
                HydroponicIncubatorContainer.this.tileEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(h -> ((VEEnergyStorage)((Object)h)).setEnergy(value));
            }
        });
    }

    @Override
    public int getEnergy() {
        return this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    @Override
    public int powerScreen(int px) {
        int stored = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        int max = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
        int ret = stored * 100 / max * 100 / 100 * px / 100;
        return ret;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return HydroponicIncubatorContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tileEntity.m_58904_(), (BlockPos)this.tileEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)VEBlocks.HYDROPONIC_INCUBATOR_BLOCK.get()));
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            ItemStack processedStack = this.handleCoreQuickMoveStackLogicWithUpgradeSlot(index, 8, 7, slotStack);
            if (processedStack != null && processedStack.m_41613_() > 0) {
                return processedStack;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == returnStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return returnStack;
    }

    @Override
    public ItemStack handleCoreQuickMoveStackLogicWithUpgradeSlot(int index, int containerSlots, int upgradeSlotId, ItemStack slotStack) {
        if (index < containerSlots) {
            if (!this.m_38903_(slotStack, containerSlots, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (slotStack.m_41720_() instanceof BucketItem) {
                if (!((Slot)this.f_38839_.get(0)).m_6657_() && !this.m_38903_(slotStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
                return null;
            }
            if (TagUtil.isTaggedMachineUpgradeItem(slotStack) && !this.m_38903_(slotStack, upgradeSlotId, upgradeSlotId + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (!RecipeUtil.getHydroponicIncubatorRecipesFromItemInput(this.tileEntity.m_58904_(), slotStack.m_41720_()).isEmpty() && ((Slot)this.f_38839_.get(2)).m_7993_().m_41613_() < 1) {
                if (slotStack.m_41613_() > 1) {
                    ItemStack tempStack = slotStack.m_41777_();
                    tempStack.m_41764_(1);
                    if (this.m_38903_(tempStack, 2, 3, false)) {
                        slotStack.m_41764_(slotStack.m_41613_() - 1);
                        return slotStack;
                    }
                } else if (this.m_38903_(slotStack, 2, 3, false)) {
                    return ItemStack.f_41583_;
                }
            }
        }
        return null;
    }
}

