/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.containers;

import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.blocks.containers.VoluminousContainer;
import com.veteam.voluminousenergy.blocks.inventory.slots.VEInsertSlot;
import com.veteam.voluminousenergy.blocks.screens.BatteryBoxScreen;
import com.veteam.voluminousenergy.blocks.screens.VEContainerScreen;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BatteryBoxContainer
extends VoluminousContainer {
    private static final int NUMBER_OF_SLOTS = 12;

    public BatteryBoxContainer(int id, Level world, BlockPos pos, Inventory inventory, Player player) {
        super((MenuType)VEBlocks.BATTERY_BOX_CONTAINER.get(), id);
        this.tileEntity = world.m_7702_(pos);
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)inventory);
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> {
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 0, 35, 17));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 1, 53, 17));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 2, 71, 17));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 3, 89, 17));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 4, 107, 17));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 5, 125, 17));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 6, 35, 54));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 7, 53, 54));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 8, 71, 54));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 9, 89, 54));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 10, 107, 54));
            this.m_38897_((Slot)new VEInsertSlot((IItemHandler)h, 11, 125, 54));
        });
        this.layoutPlayerInventorySlots(8, 84);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return BatteryBoxContainer.this.getEnergy();
            }

            public void m_6422_(int value) {
            }
        });
    }

    @Override
    public int getEnergy() {
        return this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    @Override
    public int powerScreen(int px) {
        int stored = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
        int max = this.tileEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
        int ret = stored * 100 / max * 100 / 100 * px / 100;
        return ret;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return BatteryBoxContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.tileEntity.m_58904_(), (BlockPos)this.tileEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)VEBlocks.BATTERY_BOX_BLOCK.get()));
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (this.handleCoreQuickMoveStackLogic(index, 12, slotStack) != null) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == returnStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return returnStack;
    }

    public void updateSendOutPowerButton(boolean status) {
        VEContainerScreen vEContainerScreen = this.screen;
        if (vEContainerScreen instanceof BatteryBoxScreen) {
            BatteryBoxScreen batteryBoxScreen = (BatteryBoxScreen)vEContainerScreen;
            batteryBoxScreen.updateSendOutPowerButton(status);
        }
    }
}

