/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.blocks.machines.tanks;

import com.veteam.voluminousenergy.blocks.blocks.util.FaceableBlock;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.util.NumberUtil;
import com.veteam.voluminousenergy.util.TextUtil;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;

public class TankBlock
extends FaceableBlock {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");

    public TankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!world.f_46443_) {
            BlockEntity tileEntity = world.m_7702_(pos);
            if (!(tileEntity instanceof MenuProvider)) {
                throw new IllegalStateException("TankBlock named container provider is missing!");
            }
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        FluidStack fluid;
        super.m_5871_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            CompoundTag blockEntityTag = tag.m_128469_("BlockEntityTag");
            CompoundTag tankTag = blockEntityTag.m_128469_("tank");
            FluidTank tank = new FluidTank(0);
            tank.readFromNBT(tankTag);
            fluid = tank.getFluid();
        } else {
            fluid = FluidStack.EMPTY;
        }
        int tankCapacity = this.getTankCapacity() * 1000;
        if (((Boolean)Config.SHORTEN_ITEM_TOOLTIP_VALUES.get()).booleanValue()) {
            tooltip.add((Component)TextUtil.translateString(fluid.getTranslationKey()).m_6881_().m_130946_(": ").m_130946_(NumberUtil.numberToString4Fluids(fluid.getAmount())).m_130946_(" / ").m_130946_(NumberUtil.numberToString4Fluids(tankCapacity)));
        } else {
            String amount = String.format("%s mB", DECIMAL_FORMAT.format(fluid.getAmount()));
            String capacity = String.format("%s mB", DECIMAL_FORMAT.format(tankCapacity));
            tooltip.add((Component)TextUtil.translateString(fluid.getTranslationKey()).m_6881_().m_130946_(": " + amount + " / " + capacity));
        }
    }

    public int getTankCapacity() {
        return 0;
    }
}

