/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy.blocks.blocks.machines;

import com.veteam.voluminousenergy.VoluminousEnergy;
import com.veteam.voluminousenergy.datagen.VETagDataGenerator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class PressureLadder
extends LadderBlock {
    private String registryName;
    protected static final AABB TOUCH_AABB = new AABB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final PressurePlateBlock.Sensitivity sensitivity = PressurePlateBlock.Sensitivity.MOBS;

    public PressureLadder() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50155_).m_60999_().m_60977_().m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54337_, (Comparable)Direction.NORTH)).m_61124_((Property)f_54338_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        VETagDataGenerator.setRequiresAxe((Block)this);
        VETagDataGenerator.setRequiresWood((Block)this);
        this.setRegistryName("pressure_ladder");
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{f_54337_, f_54338_, POWERED});
    }

    public boolean isLadder(BlockState blockState, LevelReader levelReader, BlockPos blockPos, LivingEntity livingEntity) {
        return true;
    }

    protected int getPressedTime() {
        return 20;
    }

    public boolean isPossibleToRespawnInThis() {
        return true;
    }

    protected int getSignalForState(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    protected BlockState setSignalForState(BlockState blockState, int signalPower) {
        return (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(signalPower > 0));
    }

    protected void playOnSound(LevelAccessor accessor, BlockPos pos) {
        accessor.m_5594_((Player)null, pos, SoundEvents.f_12637_, SoundSource.BLOCKS, 0.3f, 0.8f);
    }

    protected void playOffSound(LevelAccessor accessor, BlockPos pos) {
        accessor.m_5594_((Player)null, pos, SoundEvents.f_12636_, SoundSource.BLOCKS, 0.3f, 0.7f);
    }

    protected int getSignalStrength(Level level, BlockPos blockPos) {
        List list;
        AABB aabb = TOUCH_AABB.m_82338_(blockPos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                list = level.m_45933_((Entity)null, aabb);
                break;
            }
            case MOBS: {
                list = level.m_45976_(LivingEntity.class, aabb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_6090_()) continue;
                return 15;
            }
        }
        return 0;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        Player player = serverLevel.m_5788_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 2.0, EntitySelector.f_20408_);
        if ((player == null || player.m_5833_()) && ((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            VoluminousEnergy.LOGGER.info("Pressure Ladder active with no player! Might be jammed! Deactivating to unjam!");
            this.powerOff((Level)serverLevel, blockState, blockPos, (Entity)player);
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (!level.f_46443_ && entity instanceof LivingEntity) {
            double deltaX = entity.m_20185_() - (double)blockPos.m_123341_();
            double deltaY = entity.m_20186_() - (double)blockPos.m_123342_();
            double deltaZ = entity.m_20189_() - (double)blockPos.m_123343_();
            if ((deltaY > (double)0.91f || deltaY < (double)-0.92f) && ((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                this.powerOff(level, blockState, blockPos, entity);
            } else if (deltaY > (double)-0.9f && deltaY < (double)0.9f && !((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                this.powerOn(level, blockState, blockPos, entity);
            }
            if (deltaZ > (double)0.9f || deltaZ < (double)-0.9f || (deltaX > (double)0.9f || deltaX < (double)-0.9f) && ((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                this.powerOff(level, blockState, blockPos, entity);
            }
        }
    }

    private void powerOff(Level level, BlockState blockState, BlockPos blockPos, Entity entity) {
        BlockState newState = (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
        this.setSignalForState(newState, 0);
        level.m_7731_(blockPos, newState, 3);
        level.m_6550_(blockPos, blockState, newState);
        this.updateNeighbours(level, blockPos);
        this.playOffSound((LevelAccessor)level, blockPos);
        level.m_142346_(entity, GameEvent.f_223703_, blockPos);
    }

    private void powerOn(Level level, BlockState blockState, BlockPos blockPos, Entity entity) {
        BlockState newState = (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        this.setSignalForState(newState, 15);
        level.m_7731_(blockPos, newState, 3);
        level.m_6550_(blockPos, blockState, newState);
        this.updateNeighbours(level, blockPos);
        this.playOnSound((LevelAccessor)level, blockPos);
        level.m_142346_(entity, GameEvent.f_223702_, blockPos);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean flag) {
        if (!flag && !blockState.m_60713_(blockState1.m_60734_())) {
            if (this.getSignalForState(blockState) > 0) {
                this.updateNeighbours(level, blockPos);
            }
            super.m_6810_(blockState, level, blockPos, blockState1, flag);
        }
    }

    protected void updateNeighbours(Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
        level.m_46672_(pos.m_7495_(), (Block)this);
        level.m_46672_(pos.m_7494_(), (Block)this);
        level.m_46672_(pos.m_122029_(), (Block)this);
        level.m_46672_(pos.m_122024_(), (Block)this);
        level.m_46672_(pos.m_122012_(), (Block)this);
        level.m_46672_(pos.m_122019_(), (Block)this);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockGetter, BlockPos pos, Direction direction) {
        return this.getSignalForState(blockState);
    }

    public int m_6376_(BlockState blockState, BlockGetter blockGetter, BlockPos pos, Direction direction) {
        return direction == Direction.UP ? this.getSignalForState(blockState) : 0;
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    public String getRegistryName() {
        return this.registryName;
    }
}

