/*
 * Decompiled with CFR 0.152.
 */
package com.veteam.voluminousenergy;

import com.veteam.voluminousenergy.achievements.triggers.VECriteriaTriggers;
import com.veteam.voluminousenergy.blocks.blocks.VEBlocks;
import com.veteam.voluminousenergy.client.renderers.entity.LaserBlockEntityRenderer;
import com.veteam.voluminousenergy.datagen.VEGlobalLootModifierData;
import com.veteam.voluminousenergy.datagen.VELootInjectionData;
import com.veteam.voluminousenergy.datagen.VETagDataGenerator;
import com.veteam.voluminousenergy.fluids.VEFluids;
import com.veteam.voluminousenergy.items.VEBlockItems;
import com.veteam.voluminousenergy.items.VEItems;
import com.veteam.voluminousenergy.items.tools.VETools;
import com.veteam.voluminousenergy.items.tools.multitool.VEMultitools;
import com.veteam.voluminousenergy.loot.VELoot;
import com.veteam.voluminousenergy.recipe.VERecipes;
import com.veteam.voluminousenergy.setup.ClientProxy;
import com.veteam.voluminousenergy.setup.IProxy;
import com.veteam.voluminousenergy.setup.ServerProxy;
import com.veteam.voluminousenergy.setup.VESetup;
import com.veteam.voluminousenergy.tools.Config;
import com.veteam.voluminousenergy.tools.networking.VENetwork;
import com.veteam.voluminousenergy.world.feature.VEFeatures;
import com.veteam.voluminousenergy.world.modifiers.VEModifiers;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="voluminousenergy")
public class VoluminousEnergy {
    public static final String MODID = "voluminousenergy";
    public static final IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static VESetup setup = new VESetup();
    public static boolean JEI_LOADED = false;
    public static final Logger LOGGER = LogManager.getLogger();
    public static MinecraftServer server;

    public void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupWhenLoadingComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        VERecipes.VE_RECIPE_SERIALIZERS_REGISTRY.register(modEventBus);
        VERecipes.VERecipeTypes.VE_RECIPE_TYPES_REGISTRY.register(modEventBus);
        VEFluids.VE_FLUIDS.register(modEventBus);
        VEFluids.VE_FLUID_BLOCKS.register(modEventBus);
        VEFluids.VE_FLUID_ITEMS.register(modEventBus);
        VEFluids.VE_FLUID_TYPES.register(modEventBus);
        VEBlocks.VE_BLOCKS_REGISTRY.register(modEventBus);
        VEBlocks.VE_TILE_REGISTRY.register(modEventBus);
        VEBlocks.VE_CONTAINER_REGISTRY.register(modEventBus);
        VEItems.VE_ITEM_REGISTRY.register(modEventBus);
        VEBlockItems.VE_BLOCK_ITEM_REGISTRY.register(modEventBus);
        VEMultitools.VE_MULTITOOL_ITEM_REGISTRY.register(modEventBus);
        VETools.VE_TOOL_REGISTRY.register(modEventBus);
        VEFeatures.VE_FEATURE_REGISTRY.register(modEventBus);
        VEModifiers.VE_BIOME_MODIFIER_REGISTRY.register(modEventBus);
        modEventBus.addListener(VESetup::registerCreativeTabs);
        VELoot.VE_LOOT_MODIFIER_REGISTRY.register(modEventBus);
        VELoot.registerLoot(modEventBus);
        VECriteriaTriggers.init();
        VoluminousEnergy.getOrCreateDirectory(FMLPaths.CONFIGDIR.get().resolve(MODID), MODID);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("voluminousenergy-common.toml"));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_BUILDER.build(), "voluminousenergy/voluminousenergy-client.toml");
        modEventBus.addListener(this::registerRenderers);
        JEI_LOADED = ModList.get().isLoaded("jei");
    }

    private static Path getOrCreateDirectory(Path dirPath, String dirLabel) {
        if (!Files.isDirectory(dirPath.getParent(), new LinkOption[0])) {
            VoluminousEnergy.getOrCreateDirectory(dirPath.getParent(), "parent of " + dirLabel);
        }
        if (!Files.isDirectory(dirPath, new LinkOption[0])) {
            LOGGER.debug("Making {} directory : {}", (Object)dirLabel, (Object)dirPath);
            try {
                Files.createDirectory(dirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) {
                    LOGGER.error("Failed to create {} directory - there is a file in the way", (Object)dirLabel);
                } else {
                    LOGGER.error("Problem with creating {} directory (Permissions?)", (Object)dirLabel, (Object)e);
                }
                throw new RuntimeException("Problem creating directory", e);
            }
            LOGGER.debug("Created {} directory : {}", (Object)dirLabel, (Object)dirPath);
        } else {
            LOGGER.debug("Found existing {} directory : {}", (Object)dirLabel, (Object)dirPath);
        }
        return dirPath;
    }

    private void setup(FMLCommonSetupEvent event) {
        setup.init();
        proxy.init();
        VENetwork.init();
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)VEBlocks.DIMENSIONAL_LASER_TILE.get(), LaserBlockEntityRenderer::new);
    }

    private void setupWhenLoadingComplete(FMLLoadCompleteEvent event) {
    }

    static {
        System.out.println("Hello World!");
        LOGGER.info("Hello World!");
        VoluminousEnergy voluminousEnergy = new VoluminousEnergy();
        voluminousEnergy.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class OnDatagenEvent {
        @SubscribeEvent
        public static void onGatherData(GatherDataEvent event) {
            DataGenerator dataGenerator = event.getGenerator();
            PackOutput packOutput = dataGenerator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            if (event.includeServer()) {
                dataGenerator.addProvider(true, (DataProvider)new VETagDataGenerator(dataGenerator.getPackOutput(), lookupProvider, event.getExistingFileHelper()));
                dataGenerator.addProvider(true, (DataProvider)new VELootInjectionData(dataGenerator));
                dataGenerator.addProvider(true, (DataProvider)new VEGlobalLootModifierData(dataGenerator.getPackOutput()));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="voluminousenergy", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientRegister {
        @SubscribeEvent
        public static void RegisterClientOnSetupEvent(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)VEBlocks.RICE_CROP.get()), (RenderType)RenderType.m_110463_()));
            event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)VEBlocks.SAWMILL_BLOCK.get()), (RenderType)RenderType.m_110463_()));
            event.enqueueWork(() -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)VEBlocks.PRESSURE_LADDER.get()), (RenderType)RenderType.m_110463_()));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterEvents {
        @SubscribeEvent
        public static void onRegistry(RegisterEvent blockRegistryEvent) {
            LOGGER.info("Running: " + blockRegistryEvent.getRegistryKey());
        }
    }
}

