/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils;

import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.impl.ImageFrame;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ImageUtils {
    private static final BlockingQueue<Pair<String, Pair<InputType, Object>>> urlRequests = new LinkedBlockingQueue<Pair<String, Pair<InputType, Object>>>();
    private static final Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<ResourceLocation>>> cachedImages = StringUtils.newConcurrentHashMap();

    public static ResourceLocation getTextureFromUrl(Minecraft instance, String textureName, String url) {
        try {
            return ImageUtils.getTextureFromUrl(instance, textureName, URI.create(url).toURL());
        }
        catch (Throwable ex) {
            CoreUtils.LOG.debugError(ex);
            return ResourceUtils.getEmptyResource();
        }
    }

    public static ResourceLocation getTextureFromUrl(Minecraft instance, String textureName, URL url) {
        try {
            return ImageUtils.getTextureFromUrl(instance, textureName, new Pair<InputType, Object>(InputType.Url, url));
        }
        catch (Throwable ex) {
            CoreUtils.LOG.debugError(ex);
            return ResourceUtils.getEmptyResource();
        }
    }

    public static ResourceLocation getTextureFromUrl(Minecraft instance, String textureName, File url) {
        try {
            return ImageUtils.getTextureFromUrl(instance, textureName, new Pair<InputType, Object>(InputType.FileData, url));
        }
        catch (Throwable ex) {
            CoreUtils.LOG.debugError(ex);
            return ResourceUtils.getEmptyResource();
        }
    }

    public static ResourceLocation getTextureFromUrl(Minecraft instance, String textureName, Object url) {
        if (url instanceof File) {
            File file = (File)url;
            return ImageUtils.getTextureFromUrl(instance, textureName, file);
        }
        if (url instanceof URL) {
            URL link = (URL)url;
            return ImageUtils.getTextureFromUrl(instance, textureName, link);
        }
        if (url.toString().toLowerCase().startsWith("http")) {
            return ImageUtils.getTextureFromUrl(instance, textureName, url.toString());
        }
        return ImageUtils.getTextureFromUrl(instance, textureName, new Pair<InputType, Object>(StringUtils.isBase64(url.toString()).getFirst() != false ? InputType.ByteStream : InputType.FileStream, url.toString()));
    }

    public static ResourceLocation getTextureFromUrl(Minecraft instance, String textureName, Pair<InputType, Object> stream) {
        Pair<Integer, List<ImageFrame>> bufferData;
        if (!cachedImages.containsKey(textureName) || !cachedImages.get(textureName).getFirst().equals(stream)) {
            cachedImages.put(textureName, new Tuple(stream, new Pair(0, StringUtils.newArrayList()), null));
            try {
                urlRequests.put(new Pair<String, Pair<InputType, Object>>(textureName, stream));
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
            }
        }
        if ((bufferData = cachedImages.get(textureName).getSecond()) == null || bufferData.getSecond() == null || bufferData.getSecond().isEmpty()) {
            return ResourceUtils.getEmptyResource();
        }
        if (textureName != null) {
            boolean shouldRepeat = textureName.endsWith(".gif") || stream.getSecond().toString().contains("gif");
            boolean doesContinue = bufferData.getFirst() < bufferData.getSecond().size() - 1;
            List<ResourceLocation> resources = cachedImages.get(textureName).getThird();
            if (bufferData.getFirst() < resources.size()) {
                ResourceLocation texLocation = resources.get(bufferData.getFirst());
                if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                    if (doesContinue) {
                        bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime();
                    } else if (shouldRepeat) {
                        bufferData.getSecond().get(bufferData.setFirst(0)).setRenderTime();
                    }
                }
                return texLocation;
            }
            try {
                DynamicTexture dynTexture = new DynamicTexture(bufferData.getSecond().get(bufferData.getFirst()).getNativeImage());
                ResourceLocation cachedTexture = instance.m_91097_().m_118490_(textureName.toLowerCase() + (String)(shouldRepeat ? "_" + String.valueOf(cachedImages.get(textureName).getSecond().getFirst()) : ""), dynTexture);
                if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                    if (doesContinue) {
                        bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime();
                    } else if (shouldRepeat) {
                        bufferData.setFirst(0);
                    }
                }
                if (!resources.contains(cachedTexture)) {
                    resources.add(cachedTexture);
                }
                return cachedTexture;
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                return ResourceUtils.getEmptyResource();
            }
        }
        return ResourceUtils.getEmptyResource();
    }

    @Deprecated(forRemoval=true, since="v1.0.3")
    public static boolean isTextureNull(ResourceLocation location) {
        return !ResourceUtils.isValidResource(location);
    }

    static {
        CoreUtils.getThreadFactory().newThread(() -> {
            block12: while (true) {
                try {
                    while (!CoreUtils.IS_CLOSING) {
                        Pair<String, Pair<InputType, Object>> request = urlRequests.take();
                        boolean isGif = request.getFirst().endsWith(".gif");
                        Pair<Integer, List<ImageFrame>> bufferData = cachedImages.get(request.getFirst()).getSecond();
                        if (bufferData == null) continue;
                        try {
                            InputStream streamData;
                            Object originData = request.getSecond().getSecond();
                            switch (request.getSecond().getFirst().ordinal()) {
                                case 0: {
                                    streamData = Files.newInputStream(((File)originData).toPath(), new OpenOption[0]);
                                    break;
                                }
                                case 1: {
                                    streamData = Files.newInputStream(Paths.get(originData.toString(), new String[0]), new OpenOption[0]);
                                    break;
                                }
                                case 2: {
                                    byte[] byArray;
                                    Tuple<Boolean, String, String> base64Data = StringUtils.isBase64(originData.toString());
                                    if (base64Data.getFirst().booleanValue()) {
                                        byArray = ImageFrame.decodeBase64(base64Data.getThird(), "UTF-8", false, false);
                                    } else if (originData instanceof byte[]) {
                                        byte[] byteData = (byte[])originData;
                                        byArray = byteData;
                                    } else {
                                        byArray = StringUtils.getBytes(originData.toString());
                                    }
                                    byte[] dataSet = byArray;
                                    streamData = dataSet != null ? new ByteArrayInputStream(dataSet) : null;
                                    isGif = base64Data.getSecond().contains("gif");
                                    break;
                                }
                                case 3: {
                                    URL url;
                                    streamData = UrlUtils.getURLStream(originData instanceof URL ? (url = (URL)originData) : URI.create(originData.toString()).toURL());
                                    isGif = originData.toString().endsWith(".gif");
                                    break;
                                }
                                default: {
                                    streamData = null;
                                }
                            }
                            if (streamData == null) continue block12;
                            if (isGif) {
                                ImageFrame[] frames;
                                for (ImageFrame frame : frames = ImageFrame.readGif(streamData)) {
                                    try {
                                        bufferData.getSecond().add(frame);
                                    }
                                    catch (Throwable ex) {
                                        CoreUtils.LOG.debugError(ex);
                                    }
                                }
                            } else {
                                bufferData.getSecond().add(new ImageFrame(NativeImage.m_85058_((InputStream)streamData)));
                            }
                            cachedImages.get(request.getFirst()).setSecond(bufferData);
                            cachedImages.get(request.getFirst()).setThird(new ArrayList(bufferData.getSecond().size()));
                            continue block12;
                        }
                        catch (Throwable ex) {
                            CoreUtils.LOG.debugError(ex);
                        }
                    }
                    break;
                }
                catch (Throwable ex) {
                    CoreUtils.LOG.debugError(ex);
                    break;
                }
            }
        }).start();
    }

    public static enum InputType {
        FileData,
        FileStream,
        ByteStream,
        Url,
        Unknown;

    }
}

