/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.toolstats;

import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import net.darkhax.toolstats.ToolStatsCommon;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.Environment;

@Mod(value="toolstats")
public class ToolStatsForge {
    private final Map<Tier, Integer> tierCache = new WeakHashMap<Tier, Integer>();
    private final Map<Integer, Tier> vanillaTierLevels = Map.of(0, Tiers.WOOD, 1, Tiers.STONE, 2, Tiers.IRON, 3, Tiers.DIAMOND, 4, Tiers.NETHERITE);

    public ToolStatsForge() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        if (Environment.get().getDist() == Dist.CLIENT) {
            ToolStatsCommon toolStatsCommon = new ToolStatsCommon(FMLPaths.CONFIGDIR.get(), IForgeItemStack::getEnchantmentValue, this::getTierLevel);
        }
    }

    public int getTierLevel(Tier tier) {
        if (!this.tierCache.containsKey(tier)) {
            if (TierSortingRegistry.isTierSorted((Tier)tier)) {
                this.tierCache.clear();
                int tierLevel = 0;
                for (Tier currentTier : TierSortingRegistry.getSortedTiers()) {
                    boolean isVanilla;
                    ResourceLocation id = TierSortingRegistry.getName((Tier)currentTier);
                    boolean bl = isVanilla = id != null && "minecraft".equals(id.m_135827_());
                    if (isVanilla || currentTier.getTag() != null && !ToolStatsForge.isTagEmpty((TagKey<Block>)currentTier.getTag())) {
                        ++tierLevel;
                    }
                    this.tierCache.put(currentTier, tierLevel);
                }
            } else if (this.vanillaTierLevels.containsKey(tier.m_6604_())) {
                this.tierCache.put(tier, this.getTierLevel(this.vanillaTierLevels.get(tier.m_6604_())));
            }
        }
        return this.tierCache.computeIfAbsent(tier, t -> -1);
    }

    private static boolean isTagEmpty(TagKey<Block> key) {
        Optional holders = BuiltInRegistries.f_256975_.m_203431_(key);
        return holders == null || holders.isEmpty() || ((HolderSet.Named)holders.get()).m_203632_() <= 0;
    }
}

