/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.toolstats;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.event.IEventHelper;
import net.darkhax.toolstats.Constants;
import net.darkhax.toolstats.config.ConfigSchema;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;

public class ToolStatsCommon {
    private final TagKey<Item> TAG_IGNORE = ToolStatsCommon.itemTag("ignored");
    private final TagKey<Item> TAG_IGNORE_HARVEST_LEVEL = ToolStatsCommon.itemTag("ignore_harvest_level");
    private final TagKey<Item> TAG_IGNORE_DIG_SPEED = ToolStatsCommon.itemTag("ignore_dig_speed");
    private final TagKey<Item> TAG_IGNORE_ENCHANTABILITY = ToolStatsCommon.itemTag("ignore_enchantability");
    private final TagKey<Item> TAG_IGNORE_REPAIR_COST = ToolStatsCommon.itemTag("ignore_repair_cost");
    private final TagKey<Item> TAG_IGNORE_DURABILITY = ToolStatsCommon.itemTag("ignore_durability");
    private final ConfigSchema config;
    private final Function<ItemStack, Integer> enchantabilityResolver;
    private final Function<Tier, Integer> harvestLevelResolver;
    private final Map<Integer, Component> enchantabilityCache = new ConcurrentHashMap<Integer, Component>();
    private final Map<Integer, Component> repairCostCache = new ConcurrentHashMap<Integer, Component>();
    private final Map<Integer, Component> harvestLevelCache = new ConcurrentHashMap<Integer, Component>();

    public ToolStatsCommon(Path configDir, Function<ItemStack, Integer> enchantabilityResolver, Function<Tier, Integer> harvestLevelResolver) {
        this.config = ConfigSchema.load(configDir.resolve("toolstats.json").toFile());
        this.enchantabilityResolver = enchantabilityResolver;
        this.harvestLevelResolver = harvestLevelResolver;
        Services.EVENTS.addItemTooltipListener(this::displayTooltipInfo, IEventHelper.Ordering.BEFORE);
    }

    private void displayTooltipInfo(ItemStack stack, List<Component> tooltip, TooltipFlag context) {
        if (!stack.m_204117_(this.TAG_IGNORE)) {
            int repairCost;
            int enchantability;
            float speed;
            ArrayList<Object> additions = new ArrayList<Object>();
            Item item = stack.m_41720_();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                if (!stack.m_204117_(this.TAG_IGNORE_HARVEST_LEVEL) && this.config.showHarvestLevel) {
                    additions.add(this.harvestLevelCache.computeIfAbsent(this.harvestLevelResolver.apply(tieredItem.m_43314_()), lvl -> Component.m_237110_((String)"tooltip.toolstats.harvestlevel", (Object[])new Object[]{lvl}).m_130940_(ChatFormatting.DARK_GREEN)));
                }
            }
            if (!stack.m_204117_(this.TAG_IGNORE_DIG_SPEED) && this.config.showEfficiency && (!(stack.m_41720_() instanceof SwordItem) || this.config.showSwordEfficiency) && (speed = ToolStatsCommon.getDestroySpeed(stack)) > 0.0f) {
                additions.add(Component.m_237110_((String)"tooltip.toolstats.efficiency", (Object[])new Object[]{Constants.DECIMAL_FORMAT.format(speed)}).m_130940_(ChatFormatting.DARK_GREEN));
            }
            if (!stack.m_204117_(this.TAG_IGNORE_ENCHANTABILITY) && this.config.showEnchantability && (this.config.alwaysShowEnchantability || Minecraft.m_91087_().f_91080_ instanceof EnchantmentScreen) && (enchantability = this.enchantabilityResolver.apply(stack).intValue()) > 0) {
                additions.add(this.enchantabilityCache.computeIfAbsent(enchantability, enchLvl -> Component.m_237110_((String)"tooltip.toolstats.enchantability", (Object[])new Object[]{enchLvl}).m_130940_(ChatFormatting.DARK_GREEN)));
            }
            if (!stack.m_204117_(this.TAG_IGNORE_REPAIR_COST) && this.config.showRepairCost && (this.config.alwaysShowRepairCost || Minecraft.m_91087_().f_91080_ instanceof AnvilScreen) && (repairCost = stack.m_41610_()) > 0) {
                additions.add(this.repairCostCache.computeIfAbsent(repairCost, cost -> Component.m_237110_((String)"tooltip.toolstats.repaircost", (Object[])new Object[]{cost}).m_130940_(ChatFormatting.DARK_GREEN)));
            }
            if (!context.m_7050_() && !stack.m_204117_(this.TAG_IGNORE_DURABILITY) && this.config.showDurability && stack.m_41763_() && (this.config.alwaysShowDurability || stack.m_41768_())) {
                additions.add(Component.m_237110_((String)"item.durability", (Object[])new Object[]{stack.m_41776_() - stack.m_41773_(), stack.m_41776_()}).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.config.showHorseArmorProtection && (item = stack.m_41720_()) instanceof HorseArmorItem) {
                HorseArmorItem horseArmor = (HorseArmorItem)item;
                additions.add(CommonComponents.f_237098_);
                additions.add(Component.m_237115_((String)"tooltip.toolstats.when_on.horse").m_130940_(ChatFormatting.GRAY));
                additions.add(Component.m_237110_((String)("attribute.modifier.plus." + AttributeModifier.Operation.ADDITION.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(horseArmor.m_41368_()), Component.m_237115_((String)Attributes.f_22284_.m_22087_())}).m_130940_(ChatFormatting.BLUE));
            }
            if (!additions.isEmpty()) {
                tooltip.addAll(ToolStatsCommon.getInsertOffset(context.m_7050_(), tooltip.size(), stack), additions);
            }
        }
    }

    private static float getDestroySpeed(ItemStack stack) {
        int efficiencyLevel;
        float destroySpeed = ToolStatsCommon.getDestroySpeed(stack, stack.m_41720_());
        if (destroySpeed > 1.0f && (efficiencyLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44984_, (ItemStack)stack)) > 0) {
            destroySpeed += (float)(efficiencyLevel * efficiencyLevel + 1);
        }
        return destroySpeed;
    }

    private static float getDestroySpeed(ItemStack stack, Item item) {
        if (item instanceof PickaxeItem) {
            PickaxeItem pickaxe = (PickaxeItem)item;
            return pickaxe.m_8102_(stack, Blocks.f_50652_.m_49966_());
        }
        if (item instanceof AxeItem) {
            AxeItem axe = (AxeItem)item;
            return axe.m_8102_(stack, Blocks.f_50705_.m_49966_());
        }
        if (item instanceof ShovelItem) {
            ShovelItem shovel = (ShovelItem)item;
            return shovel.m_8102_(stack, Blocks.f_50493_.m_49966_());
        }
        if (item instanceof HoeItem) {
            HoeItem hoe = (HoeItem)item;
            return hoe.m_8102_(stack, Blocks.f_50577_.m_49966_());
        }
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            return sword.m_8102_(stack, Blocks.f_50355_.m_49966_());
        }
        if (item instanceof ShearsItem) {
            ShearsItem shears = (ShearsItem)item;
            return shears.m_8102_(stack, Blocks.f_50050_.m_49966_());
        }
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return tieredItem.m_43314_().m_6624_();
        }
        return 0.0f;
    }

    private static int getInsertOffset(boolean advanced, int tooltipSize, ItemStack stack) {
        int offset = 0;
        if (advanced) {
            ++offset;
            if (stack.m_41782_()) {
                ++offset;
            }
            if (stack.m_41768_()) {
                ++offset;
            }
        }
        return Math.max(0, tooltipSize - offset);
    }

    private static TagKey<Item> itemTag(String key) {
        return Services.TAGS.itemTag(new ResourceLocation("toolstats", key));
    }
}

