/*
 * Decompiled with CFR 0.152.
 */
package tannyjung.tht.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import tannyjung.tht.ThtMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThtModVariables {
    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ThtMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "tht_mapvars";
        public double world_height_limit_get = 0.0;
        public double world_height_limit = 0.0;
        public boolean world_gen_roots = false;
        public boolean version_1192 = false;
        public double tree_placer_tick_set = 0.0;
        public double tree_placer_tick = 0.0;
        public double tree_placer_process_limit = 0.0;
        public double tree_placer_distance_limit = 0.0;
        public double tree_placer_count_limit = 0.0;
        public double tree_placer_auto_speed_test = 0.0;
        public boolean tree_placer_auto_speed = false;
        public double tree_location_count = 0.0;
        public boolean tree_location = false;
        public double time_convert = 0.0;
        public boolean tanny_pack_wip = false;
        public String tanny_pack_version = "";
        public double surface_detector_size = 0.0;
        public double surface_detector_height = 0.0;
        public boolean square_parts = false;
        public boolean square_leaves = false;
        public double season_detector_tick = 0.0;
        public boolean season_detector = false;
        public String season = "";
        public double safe_zone_village = 0.0;
        public double safe_zone_spawn = 0.0;
        public double rt_roots = 0.0;
        public double rt_dynamic_tick_set = 0.0;
        public double rt_dynamic_tick = 0.0;
        public double rt_dynamic_simulation = 0.0;
        public double rt_dynamic_process_limit = 0.0;
        public boolean rt_dynamic = false;
        public double pre_leaves_litter_coniferous_chance = 0.0;
        public double pre_leaves_litter_chance = 0.0;
        public boolean no_core = false;
        public String mod_version = "";
        public double loop_second = 0.0;
        public double leaves_regrow_winter_chance = 0.0;
        public double leaves_regrow_summer_chance = 0.0;
        public double leaves_regrow_spring_chance = 0.0;
        public double leaves_regrow_chance_coniferous = 0.0;
        public double leaves_regrow_autumn_chance = 0.0;
        public double leaves_litter_remover_count_limit = 0.0;
        public double leaves_litter_remover_chance = 0.0;
        public boolean leaves_litter = false;
        public double leaves_drop_winter_chance = 0.0;
        public double leaves_drop_summer_chance = 0.0;
        public double leaves_drop_spring_chance = 0.0;
        public double leaves_drop_chance_coniferous = 0.0;
        public double leaves_drop_autumn_chance = 0.0;
        public double leaves_drop_animation_count_limit = 0.0;
        public double leaves_drop_animation_chance = 0.0;
        public double leaves_coniferous_regrow_chance = 0.0;
        public double leaves_coniferous_drop_chance = 0.0;
        public double global_generate_speed_speed = 0.0;
        public double global_generate_speed_repeat = 0.0;
        public boolean global_generate_speed = false;
        public double generation_distance_max = 0.0;
        public double generation_count_max = 0.0;
        public boolean fireworks = false;
        public boolean developer_mode = false;
        public boolean detect_exist = false;
        public boolean auto_update = false;
        public double auto_gen_forceload_size = 0.0;
        public double auto_gen_count = 0.0;
        public double auto_gen_cooldown = 0.0;
        public boolean auto_gen_chat_messages = false;
        public boolean auto_gen = false;
        public boolean auto_check_update = false;
        public double global_generate_speed_tp = 0.0;
        public double global_rarity = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.world_height_limit_get = nbt.m_128459_("world_height_limit_get");
            this.world_height_limit = nbt.m_128459_("world_height_limit");
            this.world_gen_roots = nbt.m_128471_("world_gen_roots");
            this.version_1192 = nbt.m_128471_("version_1192");
            this.tree_placer_tick_set = nbt.m_128459_("tree_placer_tick_set");
            this.tree_placer_tick = nbt.m_128459_("tree_placer_tick");
            this.tree_placer_process_limit = nbt.m_128459_("tree_placer_process_limit");
            this.tree_placer_distance_limit = nbt.m_128459_("tree_placer_distance_limit");
            this.tree_placer_count_limit = nbt.m_128459_("tree_placer_count_limit");
            this.tree_placer_auto_speed_test = nbt.m_128459_("tree_placer_auto_speed_test");
            this.tree_placer_auto_speed = nbt.m_128471_("tree_placer_auto_speed");
            this.tree_location_count = nbt.m_128459_("tree_location_count");
            this.tree_location = nbt.m_128471_("tree_location");
            this.time_convert = nbt.m_128459_("time_convert");
            this.tanny_pack_wip = nbt.m_128471_("tanny_pack_wip");
            this.tanny_pack_version = nbt.m_128461_("tanny_pack_version");
            this.surface_detector_size = nbt.m_128459_("surface_detector_size");
            this.surface_detector_height = nbt.m_128459_("surface_detector_height");
            this.square_parts = nbt.m_128471_("square_parts");
            this.square_leaves = nbt.m_128471_("square_leaves");
            this.season_detector_tick = nbt.m_128459_("season_detector_tick");
            this.season_detector = nbt.m_128471_("season_detector");
            this.season = nbt.m_128461_("season");
            this.safe_zone_village = nbt.m_128459_("safe_zone_village");
            this.safe_zone_spawn = nbt.m_128459_("safe_zone_spawn");
            this.rt_roots = nbt.m_128459_("rt_roots");
            this.rt_dynamic_tick_set = nbt.m_128459_("rt_dynamic_tick_set");
            this.rt_dynamic_tick = nbt.m_128459_("rt_dynamic_tick");
            this.rt_dynamic_simulation = nbt.m_128459_("rt_dynamic_simulation");
            this.rt_dynamic_process_limit = nbt.m_128459_("rt_dynamic_process_limit");
            this.rt_dynamic = nbt.m_128471_("rt_dynamic");
            this.pre_leaves_litter_coniferous_chance = nbt.m_128459_("pre_leaves_litter_coniferous_chance");
            this.pre_leaves_litter_chance = nbt.m_128459_("pre_leaves_litter_chance");
            this.no_core = nbt.m_128471_("no_core");
            this.mod_version = nbt.m_128461_("mod_version");
            this.loop_second = nbt.m_128459_("loop_second");
            this.leaves_regrow_winter_chance = nbt.m_128459_("leaves_regrow_winter_chance");
            this.leaves_regrow_summer_chance = nbt.m_128459_("leaves_regrow_summer_chance");
            this.leaves_regrow_spring_chance = nbt.m_128459_("leaves_regrow_spring_chance");
            this.leaves_regrow_chance_coniferous = nbt.m_128459_("leaves_regrow_chance_coniferous");
            this.leaves_regrow_autumn_chance = nbt.m_128459_("leaves_regrow_autumn_chance");
            this.leaves_litter_remover_count_limit = nbt.m_128459_("leaves_litter_remover_count_limit");
            this.leaves_litter_remover_chance = nbt.m_128459_("leaves_litter_remover_chance");
            this.leaves_litter = nbt.m_128471_("leaves_litter");
            this.leaves_drop_winter_chance = nbt.m_128459_("leaves_drop_winter_chance");
            this.leaves_drop_summer_chance = nbt.m_128459_("leaves_drop_summer_chance");
            this.leaves_drop_spring_chance = nbt.m_128459_("leaves_drop_spring_chance");
            this.leaves_drop_chance_coniferous = nbt.m_128459_("leaves_drop_chance_coniferous");
            this.leaves_drop_autumn_chance = nbt.m_128459_("leaves_drop_autumn_chance");
            this.leaves_drop_animation_count_limit = nbt.m_128459_("leaves_drop_animation_count_limit");
            this.leaves_drop_animation_chance = nbt.m_128459_("leaves_drop_animation_chance");
            this.leaves_coniferous_regrow_chance = nbt.m_128459_("leaves_coniferous_regrow_chance");
            this.leaves_coniferous_drop_chance = nbt.m_128459_("leaves_coniferous_drop_chance");
            this.global_generate_speed_speed = nbt.m_128459_("global_generate_speed_speed");
            this.global_generate_speed_repeat = nbt.m_128459_("global_generate_speed_repeat");
            this.global_generate_speed = nbt.m_128471_("global_generate_speed");
            this.generation_distance_max = nbt.m_128459_("generation_distance_max");
            this.generation_count_max = nbt.m_128459_("generation_count_max");
            this.fireworks = nbt.m_128471_("fireworks");
            this.developer_mode = nbt.m_128471_("developer_mode");
            this.detect_exist = nbt.m_128471_("detect_exist");
            this.auto_update = nbt.m_128471_("auto_update");
            this.auto_gen_forceload_size = nbt.m_128459_("auto_gen_forceload_size");
            this.auto_gen_count = nbt.m_128459_("auto_gen_count");
            this.auto_gen_cooldown = nbt.m_128459_("auto_gen_cooldown");
            this.auto_gen_chat_messages = nbt.m_128471_("auto_gen_chat_messages");
            this.auto_gen = nbt.m_128471_("auto_gen");
            this.auto_check_update = nbt.m_128471_("auto_check_update");
            this.global_generate_speed_tp = nbt.m_128459_("global_generate_speed_tp");
            this.global_rarity = nbt.m_128459_("global_rarity");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("world_height_limit_get", this.world_height_limit_get);
            nbt.m_128347_("world_height_limit", this.world_height_limit);
            nbt.m_128379_("world_gen_roots", this.world_gen_roots);
            nbt.m_128379_("version_1192", this.version_1192);
            nbt.m_128347_("tree_placer_tick_set", this.tree_placer_tick_set);
            nbt.m_128347_("tree_placer_tick", this.tree_placer_tick);
            nbt.m_128347_("tree_placer_process_limit", this.tree_placer_process_limit);
            nbt.m_128347_("tree_placer_distance_limit", this.tree_placer_distance_limit);
            nbt.m_128347_("tree_placer_count_limit", this.tree_placer_count_limit);
            nbt.m_128347_("tree_placer_auto_speed_test", this.tree_placer_auto_speed_test);
            nbt.m_128379_("tree_placer_auto_speed", this.tree_placer_auto_speed);
            nbt.m_128347_("tree_location_count", this.tree_location_count);
            nbt.m_128379_("tree_location", this.tree_location);
            nbt.m_128347_("time_convert", this.time_convert);
            nbt.m_128379_("tanny_pack_wip", this.tanny_pack_wip);
            nbt.m_128359_("tanny_pack_version", this.tanny_pack_version);
            nbt.m_128347_("surface_detector_size", this.surface_detector_size);
            nbt.m_128347_("surface_detector_height", this.surface_detector_height);
            nbt.m_128379_("square_parts", this.square_parts);
            nbt.m_128379_("square_leaves", this.square_leaves);
            nbt.m_128347_("season_detector_tick", this.season_detector_tick);
            nbt.m_128379_("season_detector", this.season_detector);
            nbt.m_128359_("season", this.season);
            nbt.m_128347_("safe_zone_village", this.safe_zone_village);
            nbt.m_128347_("safe_zone_spawn", this.safe_zone_spawn);
            nbt.m_128347_("rt_roots", this.rt_roots);
            nbt.m_128347_("rt_dynamic_tick_set", this.rt_dynamic_tick_set);
            nbt.m_128347_("rt_dynamic_tick", this.rt_dynamic_tick);
            nbt.m_128347_("rt_dynamic_simulation", this.rt_dynamic_simulation);
            nbt.m_128347_("rt_dynamic_process_limit", this.rt_dynamic_process_limit);
            nbt.m_128379_("rt_dynamic", this.rt_dynamic);
            nbt.m_128347_("pre_leaves_litter_coniferous_chance", this.pre_leaves_litter_coniferous_chance);
            nbt.m_128347_("pre_leaves_litter_chance", this.pre_leaves_litter_chance);
            nbt.m_128379_("no_core", this.no_core);
            nbt.m_128359_("mod_version", this.mod_version);
            nbt.m_128347_("loop_second", this.loop_second);
            nbt.m_128347_("leaves_regrow_winter_chance", this.leaves_regrow_winter_chance);
            nbt.m_128347_("leaves_regrow_summer_chance", this.leaves_regrow_summer_chance);
            nbt.m_128347_("leaves_regrow_spring_chance", this.leaves_regrow_spring_chance);
            nbt.m_128347_("leaves_regrow_chance_coniferous", this.leaves_regrow_chance_coniferous);
            nbt.m_128347_("leaves_regrow_autumn_chance", this.leaves_regrow_autumn_chance);
            nbt.m_128347_("leaves_litter_remover_count_limit", this.leaves_litter_remover_count_limit);
            nbt.m_128347_("leaves_litter_remover_chance", this.leaves_litter_remover_chance);
            nbt.m_128379_("leaves_litter", this.leaves_litter);
            nbt.m_128347_("leaves_drop_winter_chance", this.leaves_drop_winter_chance);
            nbt.m_128347_("leaves_drop_summer_chance", this.leaves_drop_summer_chance);
            nbt.m_128347_("leaves_drop_spring_chance", this.leaves_drop_spring_chance);
            nbt.m_128347_("leaves_drop_chance_coniferous", this.leaves_drop_chance_coniferous);
            nbt.m_128347_("leaves_drop_autumn_chance", this.leaves_drop_autumn_chance);
            nbt.m_128347_("leaves_drop_animation_count_limit", this.leaves_drop_animation_count_limit);
            nbt.m_128347_("leaves_drop_animation_chance", this.leaves_drop_animation_chance);
            nbt.m_128347_("leaves_coniferous_regrow_chance", this.leaves_coniferous_regrow_chance);
            nbt.m_128347_("leaves_coniferous_drop_chance", this.leaves_coniferous_drop_chance);
            nbt.m_128347_("global_generate_speed_speed", this.global_generate_speed_speed);
            nbt.m_128347_("global_generate_speed_repeat", this.global_generate_speed_repeat);
            nbt.m_128379_("global_generate_speed", this.global_generate_speed);
            nbt.m_128347_("generation_distance_max", this.generation_distance_max);
            nbt.m_128347_("generation_count_max", this.generation_count_max);
            nbt.m_128379_("fireworks", this.fireworks);
            nbt.m_128379_("developer_mode", this.developer_mode);
            nbt.m_128379_("detect_exist", this.detect_exist);
            nbt.m_128379_("auto_update", this.auto_update);
            nbt.m_128347_("auto_gen_forceload_size", this.auto_gen_forceload_size);
            nbt.m_128347_("auto_gen_count", this.auto_gen_count);
            nbt.m_128347_("auto_gen_cooldown", this.auto_gen_cooldown);
            nbt.m_128379_("auto_gen_chat_messages", this.auto_gen_chat_messages);
            nbt.m_128379_("auto_gen", this.auto_gen);
            nbt.m_128379_("auto_check_update", this.auto_check_update);
            nbt.m_128347_("global_generate_speed_tp", this.global_generate_speed_tp);
            nbt.m_128347_("global_rarity", this.global_rarity);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ThtMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "tht_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ThtMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ThtMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ThtMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ThtMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

