/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.material.MaterialValue;
import slimeknights.tconstruct.library.recipe.partbuilder.IPartBuilderContainer;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.block.entity.table.PartBuilderBlockEntity;

public class PartBuilderContainerWrapper
implements IPartBuilderContainer {
    private final PartBuilderBlockEntity builder;
    private boolean materialNeedsUpdate = true;
    @Nullable
    private IMaterialValue material = null;

    public PartBuilderContainerWrapper(PartBuilderBlockEntity builder) {
        this.builder = builder;
    }

    public ItemStack getStack() {
        return this.builder.m_8020_(0);
    }

    @Override
    public ItemStack getPatternStack() {
        return this.builder.m_8020_(1);
    }

    protected Level getWorld() {
        return Objects.requireNonNull(this.builder.m_58904_(), "Tile entity world must be nonnull");
    }

    public void refreshMaterial() {
        this.materialNeedsUpdate = true;
        this.material = null;
    }

    @Override
    @Nullable
    public IMaterialValue getMaterial() {
        if (this.materialNeedsUpdate) {
            this.materialNeedsUpdate = false;
            ItemStack stack = this.getStack();
            if (stack.m_41619_()) {
                this.material = null;
            } else if (stack.m_204117_(TinkerTags.Items.TOOL_PARTS)) {
                MaterialVariantId material = IMaterialItem.getMaterialFromStack(stack);
                this.material = IMaterial.UNKNOWN_ID.matchesVariant(material) ? null : new MaterialValue(material, MaterialCastingLookup.getItemCost(stack.m_41720_()));
            } else {
                Level world = this.getWorld();
                this.material = world.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MATERIAL.get(), (Container)this, world).orElse(null);
            }
        }
        return this.material;
    }
}

