/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlowBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final Map<Direction, VoxelShape> BOUNDS = new EnumMap<Direction, VoxelShape>(Direction.class);

    public GlowBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN));
        this.f_60440_ = BuiltInLootTables.f_78712_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Objects.requireNonNull(BOUNDS.get(state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        if (!this.canBlockStay(worldIn, pos, (Direction)state.m_61143_((Property)FACING))) {
            worldIn.m_7471_(pos, false);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, p_220069_6_);
    }

    protected boolean canBlockStay(Level world, BlockPos pos, Direction facing) {
        BlockPos placedOn = pos.m_121945_(facing);
        boolean isSolidSide = Block.m_49918_((VoxelShape)world.m_8055_(placedOn).m_60768_((BlockGetter)world, pos), (Direction)facing.m_122424_());
        boolean isLiquid = world.m_8055_(pos).m_60734_() instanceof LiquidBlock;
        return !isLiquid && isSolidSide;
    }

    public boolean addGlow(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != this && state.m_247087_()) {
            if (this.canBlockStay(world, pos, direction)) {
                if (!world.f_46443_) {
                    world.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction));
                }
                return true;
            }
            for (Direction direction1 : Direction.values()) {
                if (!this.canBlockStay(world, pos, direction1)) continue;
                if (!world.f_46443_) {
                    world.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction1));
                }
                return true;
            }
        }
        return false;
    }

    static {
        BOUNDS.put(Direction.UP, Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        BOUNDS.put(Direction.DOWN, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0));
        BOUNDS.put(Direction.NORTH, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0));
        BOUNDS.put(Direction.SOUTH, Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0));
        BOUNDS.put(Direction.EAST, Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        BOUNDS.put(Direction.WEST, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0));
    }
}

