/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.interaction;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.interaction.InteractionToolModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class DualOptionInteraction
implements InteractionToolModule,
ToolModule {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.INTERACTION);
    public static final DualOptionInteraction INSTANCE = new DualOptionInteraction();
    public static final SingletonLoader<DualOptionInteraction> LOADER = new SingletonLoader((Object)INSTANCE);
    public static final ResourceLocation KEY = TConstruct.getResource("attack_modifiers");
    private static final String MODIFIER_FORMAT = TConstruct.makeTranslationKey("modifier", "attack_toggled");

    private DualOptionInteraction() {
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public boolean canInteract(IToolStackView tool, ModifierId modifier, InteractionSource source) {
        return source == InteractionSource.RIGHT_CLICK != ModifierSetWorktableRecipe.isInSet(tool.getPersistentData(), KEY, modifier);
    }

    public SingletonLoader<DualOptionInteraction> getLoader() {
        return LOADER;
    }

    public static Component formatModifierName(IToolStackView tool, Modifier modifier, Component originalName) {
        if (ModifierSetWorktableRecipe.isInSet(tool.getPersistentData(), KEY, modifier.getId())) {
            return modifier.applyStyle(Component.m_237110_((String)MODIFIER_FORMAT, (Object[])new Object[]{originalName}));
        }
        return originalName;
    }
}

