/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.util;

import net.minecraft.world.item.Item;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public abstract class ModuleBuilder<B extends ModuleBuilder<B, T>, T extends IToolContext> {
    protected ModifierCondition<T> condition;

    protected B self() {
        return (B)this;
    }

    public abstract B toolContext(IJsonPredicate<IToolContext> var1);

    public B toolItem(IJsonPredicate<Item> tool) {
        return this.toolContext(ToolContextPredicate.fallback(tool));
    }

    private B setLevels(IntRange range) {
        this.condition = this.condition.with(range);
        return this.self();
    }

    public B levelRange(int min, int max) {
        return this.setLevels(ModifierEntry.VALID_LEVEL.range(min, max));
    }

    public B minLevel(int min) {
        return this.setLevels(ModifierEntry.VALID_LEVEL.min(min));
    }

    public B maxLevel(int max) {
        return this.setLevels(ModifierEntry.VALID_LEVEL.max(max));
    }

    public B exactLevel(int value) {
        return this.setLevels(ModifierEntry.VALID_LEVEL.exactly(value));
    }

    public static abstract class Stack<B extends Stack<B>>
    extends ModuleBuilder<B, IToolStackView> {
        public Stack() {
            this.condition = ModifierCondition.ANY_TOOL;
        }

        public B tool(IJsonPredicate<IToolStackView> tool) {
            this.condition = this.condition.with(tool);
            return (B)((Stack)this.self());
        }

        @Override
        public B toolContext(IJsonPredicate<IToolContext> tool) {
            return this.tool(ToolStackPredicate.context(tool));
        }
    }

    public static abstract class Context<B extends Context<B>>
    extends ModuleBuilder<B, IToolContext> {
        public Context() {
            this.condition = ModifierCondition.ANY_CONTEXT;
        }

        @Override
        public B toolContext(IJsonPredicate<IToolContext> tool) {
            this.condition = this.condition.with(tool);
            return (B)((Context)this.self());
        }
    }
}

