/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.events.teleport.FluidEffectTeleportEvent;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.UnloadableFluidEffect;
import slimeknights.tconstruct.library.utils.TeleportHelper;

public interface FluidEffect<C extends FluidEffectContext>
extends GenericLoaderRegistry.IHaveLoader,
UnloadableFluidEffect<C> {
    public static final GenericLoaderRegistry<FluidEffect<? super FluidEffectContext.Block>> BLOCK_EFFECTS = new GenericLoaderRegistry("Fluid block effect", false);
    public static final GenericLoaderRegistry<FluidEffect<? super FluidEffectContext.Entity>> ENTITY_EFFECTS = new GenericLoaderRegistry("Fluid entity effect", false);
    public static final FluidEffect<FluidEffectContext> EMPTY = FluidEffect.simple((fluid, scale, context, action) -> 0.0f);
    public static final FluidEffect<FluidEffectContext.Entity> EXTINGUISH_FIRE = FluidEffect.simple((fluid, level, context, action) -> {
        Entity target = context.getTarget();
        if (target.m_6060_() && level.isFull()) {
            context.getTarget().m_20095_();
            return 1.0f;
        }
        return 0.0f;
    });
    public static final FluidEffect<FluidEffectContext.Entity> TELEPORT = FluidEffect.simple((fluid, level, context, action) -> {
        LivingEntity target = context.getLivingTarget();
        if (target != null && level.isFull()) {
            TeleportHelper.randomNearbyTeleport(target, FluidEffectTeleportEvent.TELEPORT_FACTORY);
            return 1.0f;
        }
        return 0.0f;
    });

    public static void registerGeneral(ResourceLocation id, RecordLoadable<? extends FluidEffect<FluidEffectContext>> loader) {
        BLOCK_EFFECTS.register(id, loader);
        ENTITY_EFFECTS.register(id, loader);
    }

    public RecordLoadable<? extends FluidEffect<C>> getLoader();

    public static <C extends FluidEffectContext> FluidEffect<C> simple(UnloadableFluidEffect<C> effect) {
        return (FluidEffect)SingletonLoader.singleton(loader -> new FluidEffect<C>((RecordLoadable)loader, effect){
            final /* synthetic */ RecordLoadable val$loader;
            final /* synthetic */ UnloadableFluidEffect val$effect;
            {
                this.val$loader = recordLoadable;
                this.val$effect = unloadableFluidEffect;
            }

            @Override
            public RecordLoadable<? extends FluidEffect<C>> getLoader() {
                return this.val$loader;
            }

            @Override
            public float apply(FluidStack fluid, EffectLevel level, C context, IFluidHandler.FluidAction action) {
                return this.val$effect.apply(fluid, level, context, IFluidHandler.FluidAction.EXECUTE);
            }
        });
    }
}

