/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.registration;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.deferred.BlockDeferredRegister;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.common.registration.GeodeItemObject;

public class BlockDeferredRegisterExtension
extends BlockDeferredRegister {
    private static final BlockBehaviour.Properties POTTED_PROPS = BlockBehaviour.Properties.m_284310_().m_60966_().m_60955_().m_278166_(PushReaction.DESTROY);

    public BlockDeferredRegisterExtension(String modID) {
        super(modID);
    }

    public GeodeItemObject registerGeode(String name, MapColor color, SoundType blockSound, SoundEvent chimeSound, Map<GeodeItemObject.BudSize, SoundType> clusterSounds, int baseLight, Item.Properties props) {
        RegistryObject shard = this.itemRegister.register(name, () -> new Item(props));
        return new GeodeItemObject((RegistryObject<? extends Item>)shard, this, color, blockSound, chimeSound, clusterSounds, baseLight, props);
    }

    public RegistryObject<FlowerPotBlock> registerPotted(String name, Supplier<? extends Block> block) {
        RegistryObject potted = this.registerNoItem("potted_" + name, () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, block, POTTED_PROPS));
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(this.resource(name), (Supplier)potted);
        return potted;
    }

    public RegistryObject<FlowerPotBlock> registerPotted(RegistryObject<? extends Block> block) {
        return this.registerPotted(block.getId().m_135815_(), (Supplier<? extends Block>)block);
    }

    public RegistryObject<FlowerPotBlock> registerPotted(ItemObject<? extends Block> block) {
        return this.registerPotted(block.getId().m_135815_(), (Supplier<? extends Block>)block);
    }

    public <T extends Enum<T>, B extends Block> EnumObject<T, FlowerPotBlock> registerPottedEnum(T[] values, String name, EnumObject<T, B> block) {
        EnumObject.Builder builder = new EnumObject.Builder(((Enum)values[0]).getDeclaringClass());
        for (T value : values) {
            Supplier supplier = block.getSupplier(value);
            if (supplier == null) continue;
            builder.put(value, this.registerPotted(((StringRepresentable)value).m_7912_() + "_" + name, supplier));
        }
        return builder.build();
    }
}

