/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.data.render;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.client.render.FluidCuboid;
import slimeknights.mantle.data.datamap.BlockStateDataMapProvider;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.FaucetBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;

public class RenderFluidProvider
extends BlockStateDataMapProvider<List<FluidCuboid>> {
    public RenderFluidProvider(PackOutput output) {
        super(output, PackOutput.Target.RESOURCE_PACK, FluidCuboid.REGISTRY, "tconstruct");
    }

    protected void addEntries() {
        String castingTable = "templates/casting_table";
        this.entry(castingTable, List.of(FluidCuboid.builder().from(1.0f, 15.0f, 1.0f).to(15.0f, 15.9f, 15.0f).face(Direction.UP, new Direction[0]).build()));
        this.block((Supplier)TinkerSmeltery.searedTable).variant(castingTable);
        this.block((Supplier)TinkerSmeltery.scorchedTable).variant(castingTable);
        Direction[] horizontal = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        String castingBasin = "templates/casting_basin";
        this.entry(castingBasin, List.of(FluidCuboid.builder().from(2.1f, 4.0f, 2.1f).to(13.9f, 15.9f, 13.9f).face(Direction.UP, horizontal).build()));
        this.block((Supplier)TinkerSmeltery.searedBasin).variant(castingBasin);
        this.block((Supplier)TinkerSmeltery.scorchedBasin).variant(castingBasin);
        this.block((Supplier)TinkerSmeltery.searedMelter).variant(List.of(FluidCuboid.builder().from(0.08f, 8.08f, 0.08f).to(15.92f, 15.92f, 15.92f).build()));
        this.block((Supplier)TinkerSmeltery.scorchedAlloyer).variant(List.of(FluidCuboid.builder().from(0.08f, 5.08f, 0.08f).to(15.92f, 15.92f, 15.92f).build()));
        String tank = "templates/tank";
        this.entry(tank, List.of(FluidCuboid.builder().from(0.08f, 0.08f, 0.08f).to(15.92f, 15.92f, 15.92f).build()));
        for (SearedTankBlock.TankType type : SearedTankBlock.TankType.values()) {
            this.block((Block)TinkerSmeltery.searedTank.get((Enum)type)).variant(tank);
            this.block((Block)TinkerSmeltery.scorchedTank.get((Enum)type)).variant(tank);
        }
        String faucet = "templates/faucet";
        String faucetUp = "templates/faucet_up";
        this.entry(faucet, List.of(FluidCuboid.builder().from(6.0f, 6.0f, 0.0f).to(10.0f, 9.0f, 6.0f).face(true, 0, Direction.UP, new Direction[0]).face(Direction.NORTH, new Direction[0]).build(), FluidCuboid.builder().from(6.0f, 0.0f, 6.0f).to(10.0f, 9.0f, 8.0f).face(true, 0, Direction.UP, horizontal).build()));
        this.entry(faucetUp, List.of(FluidCuboid.builder().from(6.0f, 0.0f, 6.0f).to(10.0f, 16.0f, 10.0f).face(Direction.UP, new Direction[0]).face(true, 0, Direction.NORTH, new Direction[]{Direction.EAST, Direction.SOUTH, Direction.WEST}).build()));
        this.block((Supplier)TinkerSmeltery.searedFaucet).variant(faucet).end().variant(faucetUp).when((Property)FaucetBlock.FACING, (Comparable)Direction.DOWN);
        this.block((Supplier)TinkerSmeltery.scorchedFaucet).variant(faucet).end().variant(faucetUp).when((Property)FaucetBlock.FACING, (Comparable)Direction.DOWN);
    }

    public String m_6055_() {
        return "Tinkers' Construct block render fluid provider";
    }
}

