/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public abstract class NBTRecipeSerializer<R extends NBTRecipe>
implements RecipeSerializer<R> {
    protected static final int MAX_WIDTH = 3;
    protected static final int MAX_HEIGHT = 3;

    @NotNull
    public R fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        Pair<NonNullList<Ingredient>, NBTRecipeFactory<R>> recipeData = this.readRecipeData(json);
        JsonObject resultJson = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultJson);
        try {
            result.m_41784_().m_128391_(TagParser.m_129359_((String)GsonHelper.m_13906_((JsonObject)resultJson, (String)"nbt")));
        }
        catch (CommandSyntaxException exception) {
            throw new IllegalStateException(exception);
        }
        boolean merge_nbt = GsonHelper.m_13912_((JsonObject)resultJson, (String)"merge_nbt");
        return recipeData.getValue().buildRecipe(recipeId, group, recipeData.getKey(), result, merge_nbt);
    }

    @NotNull
    protected abstract Pair<NonNullList<Ingredient>, NBTRecipeFactory<R>> readRecipeData(@NotNull JsonObject var1);

    @Nullable
    public R fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
        Pair<Integer, NBTRecipeFactory<R>> recipeData = this.readRecipeData(buffer);
        String group = buffer.m_130277_();
        NonNullList ingredients = NonNullList.m_122780_((int)recipeData.getKey(), (Object)Ingredient.f_43901_);
        ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
        ItemStack result = buffer.m_130267_();
        boolean merge_nbt = buffer.readBoolean();
        return recipeData.getValue().buildRecipe(recipeId, group, (NonNullList<Ingredient>)ingredients, result, merge_nbt);
    }

    @NotNull
    protected abstract Pair<Integer, NBTRecipeFactory<R>> readRecipeData(@NotNull FriendlyByteBuf var1);

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull R recipe) {
        this.writeRecipeData(buffer, recipe);
        buffer.m_130070_(((NBTRecipe)recipe).m_6076_());
        for (Ingredient ingredient : ((NBTRecipe)recipe).m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130055_(((NBTRecipe)recipe).getResult());
        buffer.writeBoolean(((NBTRecipe)recipe).isMergeNbt());
    }

    protected abstract void writeRecipeData(@NotNull FriendlyByteBuf var1, @NotNull R var2);
}

