/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.util;

import com.google.common.base.Suppliers;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.zeith.onlinedisplays.level.LevelImageStorage;
import org.zeith.onlinedisplays.util.io.IFileContainer;

public class ImageData
implements IFileContainer {
    protected final String fileName;
    protected final byte[] data;
    protected Supplier<String> hash = Suppliers.memoize(() -> LevelImageStorage.HASH.hashify(this.data));

    public ImageData(String fileName, byte[] data) {
        this.fileName = fileName;
        this.data = data;
    }

    public ImageData(DataInputStream in) throws IOException {
        this.fileName = in.readUTF();
        this.data = new byte[in.readInt()];
        in.readFully(this.data);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.fileName);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    public String getHash() {
        return this.hash.get();
    }

    public byte[] getData() {
        return this.data;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean exists() {
        return this.data != null && this.data.length > 0;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public InputStream openInput() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long length() {
        return this.data.length;
    }
}

