/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.api.IImageDataContainer;
import org.zeith.onlinedisplays.client.gui.GuiDisplayConfig;
import org.zeith.onlinedisplays.client.texture.ClientImageStorage;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.client.texture.OnlineTextureParser;
import org.zeith.onlinedisplays.net.TransferImageSession;
import org.zeith.onlinedisplays.proxy.CommonODProxy;
import org.zeith.onlinedisplays.tiles.TileDisplay;

public class ClientODProxy
extends CommonODProxy {
    private boolean inLevel;

    @Override
    public void construct() {
        super.construct();
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    @Override
    public boolean isLocalPlayer(ServerPlayer player) {
        MinecraftServer minecraftServer = player.m_20194_();
        if (minecraftServer instanceof IntegratedServer) {
            IntegratedServer is = (IntegratedServer)minecraftServer;
            return is.m_7779_(player.m_36316_());
        }
        return super.isLocalPlayer(player);
    }

    @Override
    public IImageDataContainer getImageContainer(Level world) {
        if (world.f_46443_) {
            return ClientImageStorage.INSTANCE;
        }
        return super.getImageContainer(world);
    }

    @Override
    public IDisplayableTexture resolveTexture(TileDisplay display) {
        String hash = (String)display.imageHash.get();
        if (hash == null || hash.isEmpty() || !ClientImageStorage.isHashedOrRequest(hash, (String)display.imageURL.get())) {
            return null;
        }
        return OnlineTextureParser.getTextureByHash(hash);
    }

    @Override
    public boolean isCurrentlyEditing(TileDisplay display) {
        GuiDisplayConfig gui;
        if (display != null && display.m_58904_().f_46443_ && (gui = (GuiDisplayConfig)((Object)Cast.cast((Object)Minecraft.m_91087_().f_91080_, GuiDisplayConfig.class))) != null && gui.display == display) {
            return true;
        }
        return super.isCurrentlyEditing(display);
    }

    @Override
    public boolean isCreative() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && player.m_7500_();
    }

    private void clientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            boolean inLevel;
            boolean bl = inLevel = Minecraft.m_91087_().f_91073_ != null;
            if (inLevel != this.inLevel) {
                this.inLevel = inLevel;
                if (!inLevel) {
                    OnlineTextureParser.cleanup();
                }
            }
        }
    }

    @Override
    public void applyClientPicture(TransferImageSession session, PacketContext ctx) {
        if (ctx == null || ctx.getSide() == LogicalSide.CLIENT) {
            if (session.isValid()) {
                Minecraft.m_91087_().m_18707_(() -> {
                    ClientImageStorage.save(session.getImageData());
                    OnlineDisplays.LOG.info("Downloaded image " + session.getImageData().getFileName() + " (" + session.getImageData().getData().length + " bytes) from server.");
                });
            } else {
                OnlineDisplays.LOG.error("Failed to download image.", (Throwable)session.getError());
            }
            return;
        }
        super.applyClientPicture(session, ctx);
    }
}

