/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.level;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.saveddata.SavedData;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.util.java.Hashers;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.api.IImageDataContainer;
import org.zeith.onlinedisplays.mixins.DimensionDataStorageAccessor;
import org.zeith.onlinedisplays.net.PacketClearRequestFlag;
import org.zeith.onlinedisplays.net.TransferImageSession;
import org.zeith.onlinedisplays.util.ImageData;
import org.zeith.onlinedisplays.util.NetUtil;

public class LevelImageStorage
extends SavedData
implements IImageDataContainer {
    public static final String DATA_NAME = "onlinedisplays.image_storage";
    public static final Hashers HASH = Hashers.SHA1;
    private File imageCacheDir;
    protected String worldKey;
    protected WeakReference<MinecraftServer> server;
    protected final Map<String, CompletableFuture<String>> downloadTasks = new HashMap<String, CompletableFuture<String>>();

    public LevelImageStorage(CompoundTag nbt) {
        this.load(nbt);
    }

    private void setImageCacheDir(File file) {
        this.imageCacheDir = file;
    }

    public Optional<String> queueDownload(String url, UUID ... sendToPlayerUUIDs) {
        CompletableFuture<String> task = this.downloadTasks.get(url);
        if (task != null) {
            if (task.isDone()) {
                return Optional.ofNullable(task.join());
            }
            return Optional.empty();
        }
        this.downloadTasks.put(url, CompletableFuture.supplyAsync(() -> {
            byte[] data = null;
            String fileName = null;
            try {
                HttpRequest req = HttpRequest.get((CharSequence)url).userAgent("MinecraftServer " + this.worldKey).accept("image/*");
                fileName = NetUtil.getFileName(req);
                int code = req.code();
                OnlineDisplays.LOG.info("GET " + req.url() + " | " + code + " => " + fileName);
                if (code / 100 == 2) {
                    data = req.bytes();
                }
                OnlineDisplays.LOG.info("GOT " + (data != null ? data.length : 0) + " bytes from " + req.url());
            }
            catch (Throwable e) {
                e.printStackTrace();
                fileName = null;
                data = null;
            }
            if (fileName != null && data != null) {
                ImageData id = new ImageData(fileName, data);
                this.save(id);
                MinecraftServer srv = (MinecraftServer)this.server.get();
                if (srv != null) {
                    List<UUID> uuids = Arrays.asList(sendToPlayerUUIDs);
                    Network.sendToAll((IPacket)new PacketClearRequestFlag(id.getHash()));
                    TransferImageSession.sendTo(id, p -> uuids.contains(p.m_20148_()));
                }
                return id.getHash();
            }
            return null;
        }));
        return Optional.empty();
    }

    public File getImageCacheDir() {
        if (!this.imageCacheDir.isDirectory()) {
            this.imageCacheDir.mkdirs();
        }
        return this.imageCacheDir;
    }

    @Override
    public void save(ImageData data) {
        String hash = data.getHash();
        File fl = new File(this.getImageCacheDir(), hash.substring(0, 2));
        if (!fl.isDirectory()) {
            fl.mkdirs();
        }
        if ((fl = new File(fl, hash + ".bin")).isFile()) {
            return;
        }
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(fl));){
            data.write(dos);
        }
        catch (IOException e) {
            OnlineDisplays.LOG.fatal("Failed to save image", (Throwable)e);
            fl.delete();
        }
    }

    @Override
    public ImageData load(String hash) {
        if (StringUtil.m_14408_((String)hash)) {
            return null;
        }
        File fl = new File(this.getImageCacheDir(), hash.substring(0, 2));
        if (!fl.isDirectory()) {
            fl.mkdirs();
        }
        if ((fl = new File(fl, hash + ".bin")).isFile()) {
            ImageData imageData;
            DataInputStream in = new DataInputStream(new FileInputStream(fl));
            try {
                imageData = new ImageData(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    OnlineDisplays.LOG.fatal("Failed to read image", (Throwable)e);
                }
            }
            in.close();
            return imageData;
        }
        return null;
    }

    @Override
    public boolean has(String hash) {
        if (StringUtil.m_14408_((String)hash)) {
            return false;
        }
        File fl = new File(this.getImageCacheDir(), hash.substring(0, 2));
        if (!fl.isDirectory()) {
            fl.mkdirs();
        }
        fl = new File(fl, hash + ".bin");
        return fl.isFile();
    }

    public void load(CompoundTag nbt) {
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        return nbt;
    }

    public static LevelImageStorage get(ServerLevel world) {
        world = world.m_7654_().m_129783_();
        LevelImageStorage data = (LevelImageStorage)world.m_8895_().m_164858_(LevelImageStorage::new, DATA_NAME);
        DimensionDataStorageAccessor a = (DimensionDataStorageAccessor)world.m_8895_();
        File file = a.callGetDataFile("onlinedisplays" + File.separator + "image_cache");
        String pth = file.getAbsolutePath();
        file = new File(pth.substring(0, pth.length() - 4));
        if (data == null) {
            data = new LevelImageStorage(new CompoundTag());
            world.m_8895_().m_164855_(DATA_NAME, (SavedData)data);
        }
        data.server = new WeakReference<MinecraftServer>(world.m_7654_());
        data.worldKey = Objects.toString(world.m_7654_());
        data.setImageCacheDir(file);
        return data;
    }
}

