/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.ext.webp;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.util.ExtensionParser;
import org.zeith.onlinedisplays.util.ImageData;
import org.zeith.webp4j.WebP;

public class ExtWebP
extends ExtensionParser {
    public static final WebP WEBP = new WebP(OnlineDisplays.getModDir());

    public ExtWebP() {
        super("webp");
    }

    @Override
    public boolean isMatchingBinary(ImageData raw) {
        ByteBuffer buffer = ByteBuffer.wrap(raw.getData(), 0, 12);
        int riff = buffer.getInt();
        int chunkSize = buffer.getInt();
        int webp = buffer.getInt();
        return riff == 1380533830 && webp == 1464156752;
    }

    @Override
    public ImageData convert(ImageData raw) {
        File webpFile = null;
        try {
            Object nfn = raw.getFileName();
            if (((String)nfn).toLowerCase(Locale.ROOT).endsWith(".webp")) {
                nfn = ((String)nfn).substring(0, ((String)nfn).length() - 5) + ".png";
            }
            OnlineDisplays.LOG.info("Attempting to convert WebP " + raw.getHash() + " " + raw.getFileName() + "...");
            webpFile = File.createTempFile("onlinedisplays_webp", "tmpnet.webp");
            Files.write(webpFile.toPath(), raw.getData(), new OpenOption[0]);
            Optional<byte[]> png = WEBP.convert(webpFile);
            webpFile.delete();
            OnlineDisplays.LOG.info("WebP " + raw.getHash() + " " + raw.getFileName() + " converted into " + png.orElse(new byte[0]).length + " bytes of PNG image.");
            return new ImageData((String)nfn, png.orElseThrow(NoSuchElementException::new));
        }
        catch (Exception e) {
            OnlineDisplays.LOG.error("Failed to convert WebP image to PNG with error:", (Throwable)e);
            if (webpFile != null) {
                webpFile.delete();
            }
            return super.convert(raw);
        }
    }
}

