/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.ext.gif;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.resources.ResourceLocation;
import org.zeith.onlinedisplays.client.texture.AnimatedDisplayableTexture;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.client.texture.ITextureFactory;
import org.zeith.onlinedisplays.ext.gif.decoders.ADecoder;
import org.zeith.onlinedisplays.ext.gif.lib.GIFFrame;
import org.zeith.onlinedisplays.util.ExtensionParser;
import org.zeith.onlinedisplays.util.ImageData;

public class ExtGIF
extends ExtensionParser {
    static final String gif87a = "GIF87a";
    static final String gif89a = "GIF89a";

    public ExtGIF() {
        super("gif");
    }

    @Override
    public boolean isMatchingBinary(ImageData raw) {
        byte[] fileBytes = raw.getData();
        return Arrays.equals(Arrays.copyOfRange(fileBytes, 0, 6), gif87a.getBytes()) || Arrays.equals(Arrays.copyOfRange(fileBytes, 0, 6), gif89a.getBytes());
    }

    @Override
    public Optional<IDisplayableTexture> loadImage(ImageData data, ITextureFactory factory) {
        GIFFrame[] frames = ADecoder.decode(data);
        if (frames != null && frames.length > 0) {
            String hash = data.getHash();
            IDisplayableTexture[] framesTx = (IDisplayableTexture[])IntStream.range(0, frames.length).mapToObj(i -> factory.createStaticImage(hash + "/" + (i + 1), frames[i].image)).toArray(IDisplayableTexture[]::new);
            int w = framesTx[0].getWidth();
            int h = framesTx[0].getHeight();
            int durationMS = Arrays.stream(frames).mapToInt(GIFFrame::getDelayMS).sum();
            Object[] allTextures = new ResourceLocation[Math.max(durationMS, 1)];
            int currentMS = 0;
            for (int i2 = 0; i2 < frames.length; ++i2) {
                int fill = frames[i2].getDelayMS();
                Arrays.fill(allTextures, currentMS, currentMS + fill, framesTx[i2].getPath(0L));
                currentMS += fill;
            }
            if (allTextures.length == 1 || framesTx.length == 1) {
                return Optional.of(framesTx[0]);
            }
            return Optional.of(new AnimatedDisplayableTexture((ResourceLocation[])allTextures, hash, w, h));
        }
        return Optional.empty();
    }
}

