/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.client.texture;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.client.texture.BufferedTexture;
import org.zeith.onlinedisplays.client.texture.ClientImageStorage;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.client.texture.ITextureFactory;
import org.zeith.onlinedisplays.util.ExtensionParser;
import org.zeith.onlinedisplays.util.ImageData;

public class OnlineTextureParser {
    public static final Map<ResourceLocation, IDisplayableTexture> LOADED_TEXTURES = new HashMap<ResourceLocation, IDisplayableTexture>();
    public static final ITextureFactory TEXTURE_FACTORY = (internalHash, image) -> {
        ResourceLocation tex = OnlineDisplays.id("generated/" + internalHash);
        IDisplayableTexture cachedTex = LOADED_TEXTURES.get(tex);
        if (cachedTex != null) {
            return cachedTex;
        }
        TextureManager txm = Minecraft.m_91087_().m_91097_();
        Object tx = txm.m_118506_(tex);
        if (!(tx instanceof IDisplayableTexture)) {
            tx = new BufferedTexture(tex, internalHash, () -> {
                byte[] byArray;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", out);
                    byArray = out.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return new byte[0];
                    }
                }
                out.close();
                return byArray;
            });
            txm.m_118495_(tex, tx);
        }
        LOADED_TEXTURES.put(tex, (IDisplayableTexture)Cast.cast((Object)tx, IDisplayableTexture.class));
        return (IDisplayableTexture)Cast.cast((Object)tx, IDisplayableTexture.class);
    };

    public static IDisplayableTexture getTextureByHash(String hash) {
        ResourceLocation tex = OnlineDisplays.id("downloaded/" + hash);
        IDisplayableTexture cachedTex = LOADED_TEXTURES.get(tex);
        if (cachedTex != null) {
            return cachedTex;
        }
        ImageData image = ClientImageStorage.load(hash);
        if (image == null) {
            return null;
        }
        TextureManager txm = Minecraft.m_91087_().m_91097_();
        Object tx = txm.m_174786_(tex, null);
        if (!(tx instanceof BufferedTexture)) {
            IDisplayableTexture idtx;
            ImageData converted;
            ExtensionParser parser;
            ImageData img = ClientImageStorage.load(hash);
            if (img != null && (parser = OnlineDisplays.findExtensionParser(img.getFileName())).isMatchingBinary(img) && (converted = parser.convert(img)) != null && (idtx = (IDisplayableTexture)parser.loadImage(converted, TEXTURE_FACTORY).orElse(null)) != null) {
                LOADED_TEXTURES.put(tex, idtx);
                return idtx;
            }
            tx = new BufferedTexture(tex, hash, () -> {
                ImageData imageData;
                ImageData img = ClientImageStorage.load(hash);
                if (img == null) {
                    return new byte[0];
                }
                ExtensionParser parser = OnlineDisplays.findExtensionParser(img.getFileName());
                if (parser.isMatchingBinary(img) && (imageData = parser.convert(img)) != null) {
                    img = imageData;
                }
                return img.getData();
            });
            txm.m_118495_(tex, tx);
        }
        LOADED_TEXTURES.put(tex, (IDisplayableTexture)Cast.cast((Object)tx, IDisplayableTexture.class));
        return (IDisplayableTexture)Cast.cast((Object)tx, BufferedTexture.class);
    }

    public static IDisplayableTexture getTextureFromIcon(ImageIcon icon) {
        String hash = icon.getDescription() + "_" + icon.getIconWidth() + "x" + icon.getIconHeight();
        ResourceLocation tex = OnlineDisplays.id("generated/" + hash.hashCode());
        IDisplayableTexture cachedTex = LOADED_TEXTURES.get(tex);
        if (cachedTex != null) {
            return cachedTex;
        }
        TextureManager txm = Minecraft.m_91087_().m_91097_();
        Object tx = txm.m_174786_(tex, null);
        if (!(tx instanceof IDisplayableTexture)) {
            tx = new BufferedTexture(tex, "", () -> {
                byte[] byArray;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
                    Graphics2D graphics = img.createGraphics();
                    icon.paintIcon(null, graphics, 0, 0);
                    graphics.dispose();
                    ImageIO.write((RenderedImage)img, "png", out);
                    byArray = out.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return new byte[0];
                    }
                }
                out.close();
                return byArray;
            });
            txm.m_118495_(tex, tx);
        }
        LOADED_TEXTURES.put(tex, (IDisplayableTexture)Cast.cast((Object)tx, IDisplayableTexture.class));
        return (IDisplayableTexture)Cast.cast((Object)tx, IDisplayableTexture.class);
    }

    public static void cleanup() {
        OnlineDisplays.LOG.info("Cleanup " + LOADED_TEXTURES.size() + " images.");
        TextureManager txm = Minecraft.m_91087_().m_91097_();
        for (ResourceLocation tex : LOADED_TEXTURES.keySet()) {
            txm.m_118513_(tex);
        }
        LOADED_TEXTURES.clear();
        ClientImageStorage.REQUESTED.clear();
        ClientImageStorage.HASHED.clear();
    }
}

