/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.client.utils.Scissors;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.client.texture.OnlineTextureParser;

public class FileBrowserScreen
extends Screen {
    private File selectedFile;
    private File rootDirectory = new File(".");
    private FileListWidget fileList;
    private Consumer<File> onChosen;
    private Runnable onCancelled;

    public FileBrowserScreen(Consumer<File> onChosen, Runnable onCancelled) {
        super(OnlineDisplays.EMPTY_TXT);
        this.onChosen = onChosen;
        this.onCancelled = onCancelled;
    }

    public FileBrowserScreen withRootDirectory(File dir) {
        if (dir.isDirectory()) {
            this.rootDirectory = dir;
        }
        return this;
    }

    public void m_7856_() {
        int x = this.f_96543_ / 2 - 100;
        int y = this.f_96544_ / 4 - 10;
        this.fileList = (FileListWidget)this.m_7787_((GuiEventListener)new FileListWidget(this, x, y, 200, 160, this.rootDirectory));
        this.m_7522_((GuiEventListener)this.fileList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)OnlineDisplays.gui("cancel"), button -> this.cancel()).m_252794_(x, y += 162).m_253046_(99, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)OnlineDisplays.gui("select"), button -> this.selectFile()).m_252794_(x += 101, y).m_253046_(99, 20).m_253136_());
    }

    private void selectFile() {
        this.f_96541_.popGuiLayer();
        if (this.selectedFile != null) {
            this.onChosen.accept(this.selectedFile);
        } else if (this.onCancelled != null) {
            this.onCancelled.run();
        }
    }

    private void cancel() {
        if (this.onCancelled != null) {
            this.onCancelled.run();
        }
        this.f_96541_.popGuiLayer();
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        int x = this.f_96543_ / 2 - 100;
        int y = this.f_96544_ / 4 - 10;
        this.m_280273_(gfx);
        Scissors.begin((int)x, (int)y, (int)200, (int)160);
        this.fileList.m_88315_(gfx, mouseX, mouseY, partialTicks);
        Scissors.end();
        gfx.m_280653_(this.f_96547_, (Component)OnlineDisplays.gui("select_file"), this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(gfx, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    private class FileListWidget
    extends AbstractSelectionList<FileListEntry> {
        private final FileBrowserScreen parentScreen;
        private File rootDirectory;

        public FileListWidget(FileBrowserScreen screen, int x, int y, int width, int height, File rootDirectory) {
            Minecraft minecraft = screen.f_96541_;
            Objects.requireNonNull(screen.f_96547_);
            super(minecraft, width, height, y, y + height, 9 + 2);
            this.m_93507_(x);
            this.parentScreen = screen;
            this.rootDirectory = rootDirectory;
            this.refreshEntries();
            this.f_93395_ = 0;
            this.m_93496_(false);
        }

        protected int m_5756_() {
            return this.f_93393_ + this.f_93388_ - 6;
        }

        private void refreshEntries() {
            File parent;
            File[] files;
            this.m_93410_(0.0);
            this.m_93516_();
            boolean listingRoots = this.rootDirectory == null;
            File[] fileArray = files = listingRoots ? File.listRoots() : this.rootDirectory.listFiles();
            if (this.rootDirectory != null && (parent = new File(this.rootDirectory, "..")).isDirectory()) {
                this.m_7085_(new FileListEntry(parent, this.parentScreen.f_96547_, this, false));
            }
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory() || file.isHidden() && this.rootDirectory != null) continue;
                    this.m_7085_(new FileListEntry(file, this.parentScreen.f_96547_, this, listingRoots));
                }
                for (File file : files) {
                    if (!file.isFile() || file.isHidden() && this.rootDirectory != null) continue;
                    this.m_7085_(new FileListEntry(file, this.parentScreen.f_96547_, this, listingRoots));
                }
            }
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public void m_142291_(NarrationElementOutput out) {
        }

        private class FileListEntry
        extends AbstractSelectionList.Entry<FileListEntry> {
            private final File file;
            private final Font font;
            private final FileListWidget widget;
            private boolean isRoot;
            private long lastClickTime;

            public FileListEntry(File file, Font font, FileListWidget widget, boolean isRoot) {
                this.file = file;
                this.font = font;
                this.widget = widget;
                this.isRoot = isRoot;
            }

            public String getName() {
                return this.isRoot ? this.file.toString() : this.file.getName();
            }

            public void m_6311_(GuiGraphics gfx, int id, int y, int x, int width, int heightPadded, int p_93529_, int p_93530_, boolean hovered, float p_93532_) {
                boolean isSelected = this.widget.m_93511_() == this;
                String name = this.getName();
                try {
                    ImageIcon ii;
                    IDisplayableTexture tx;
                    Icon icon = FileSystemView.getFileSystemView().getSystemIcon(this.file);
                    if (icon instanceof ImageIcon && (tx = OnlineTextureParser.getTextureFromIcon(ii = (ImageIcon)icon)) != null) {
                        FXUtils.bindTexture((ResourceLocation)tx.getPath(System.currentTimeMillis()));
                        RenderSystem.enableBlend();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        RenderUtils.drawFullTexturedModalRect((GuiGraphics)gfx, (float)((float)x - 0.5f), (float)((float)y - 0.5f), (float)8.0f, (float)8.0f);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                gfx.m_280488_(this.font, name, x + 10, y, hovered ? 0xFF5500 : (isSelected ? 0xFFAA00 : 0xFFFFFF));
            }

            public boolean m_6375_(double p_231044_1_, double p_231044_3_, int btn) {
                if (btn == 0) {
                    if (System.currentTimeMillis() - this.lastClickTime < 500L && this.file.isDirectory()) {
                        try {
                            FileListWidget.this.rootDirectory = this.file.getCanonicalFile();
                            if (this.file.getName().equals("..") && FileListWidget.this.rootDirectory.getAbsolutePath().equals(new File(FileListWidget.this.rootDirectory, "..").getCanonicalPath()) && this.file.getParentFile().toPath().getNameCount() == 0) {
                                FileListWidget.this.rootDirectory = null;
                                this.widget.rootDirectory = null;
                                this.widget.refreshEntries();
                                return true;
                            }
                        }
                        catch (IOException e) {
                            FileListWidget.this.rootDirectory = this.file.toPath().normalize().toFile();
                        }
                        this.widget.rootDirectory = FileListWidget.this.rootDirectory;
                        this.widget.refreshEntries();
                    } else {
                        this.lastClickTime = System.currentTimeMillis();
                        this.widget.m_6987_(this);
                        if (this.file.isFile()) {
                            FileBrowserScreen.this.selectedFile = this.file;
                        }
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

